package com.morphcloud.api;

import com.morphcloud.api.entity.EntityTransformExclude;
import com.morphcloud.api.request.RequestNewTransformExclude;
import com.morphcloud.navigator.node.NodeKey;
import com.morphcloud.navigator.query.QueryParameterBuilder;

import java.util.List;

class ApiTransformExcludeResourceImpl  extends ApiBaseResource<EntityTransformExclude> implements ApiTransformExcludeResource {
    ApiTransformExcludeResourceImpl(ApiBase<?> base, Integer size) {
        super(base, NodeKey.exclude, EntityTransformExclude.class, QueryParameterBuilder.size(size));
    }

    @Override
    public List<EntityTransformExclude> getList() {
        return getData().getPage().orElseThrow().getContent();
    }

    @Override
    public EntityTransformExclude create(Integer sheetRowIndex, Boolean excludeAllAfter) {
        return super.post(new RequestNewTransformExclude(sheetRowIndex, excludeAllAfter, false));
    }
}