/*
 * Decompiled with CFR 0.152.
 */
package com.mparticle.sdk.model.eventprocessing;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.mparticle.sdk.model.eventprocessing.ApplicationStateTransitionEvent;
import com.mparticle.sdk.model.eventprocessing.AttributionEvent;
import com.mparticle.sdk.model.eventprocessing.CustomEvent;
import com.mparticle.sdk.model.eventprocessing.ErrorEvent;
import com.mparticle.sdk.model.eventprocessing.EventProcessingRequest;
import com.mparticle.sdk.model.eventprocessing.ImpressionEvent;
import com.mparticle.sdk.model.eventprocessing.Location;
import com.mparticle.sdk.model.eventprocessing.PrivacySettingChangeEvent;
import com.mparticle.sdk.model.eventprocessing.ProductActionEvent;
import com.mparticle.sdk.model.eventprocessing.PromotionActionEvent;
import com.mparticle.sdk.model.eventprocessing.PushMessageReceiptEvent;
import com.mparticle.sdk.model.eventprocessing.PushSubscriptionEvent;
import com.mparticle.sdk.model.eventprocessing.RuntimeEnvironment;
import com.mparticle.sdk.model.eventprocessing.ScreenViewEvent;
import com.mparticle.sdk.model.eventprocessing.SessionEndEvent;
import com.mparticle.sdk.model.eventprocessing.SessionStartEvent;
import com.mparticle.sdk.model.eventprocessing.UserAttributeChangeEvent;
import com.mparticle.sdk.model.eventprocessing.UserIdentity;
import com.mparticle.sdk.model.eventprocessing.UserIdentityChangeEvent;
import com.mparticle.sdk.model.registration.Account;
import java.util.List;
import java.util.Map;
import java.util.UUID;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(name="session_start", value=SessionStartEvent.class), @JsonSubTypes.Type(name="session_end", value=SessionEndEvent.class), @JsonSubTypes.Type(name="custom_event", value=CustomEvent.class), @JsonSubTypes.Type(name="screen_view", value=ScreenViewEvent.class), @JsonSubTypes.Type(name="error", value=ErrorEvent.class), @JsonSubTypes.Type(name="privacy_setting_change", value=PrivacySettingChangeEvent.class), @JsonSubTypes.Type(name="user_attribute_change", value=UserAttributeChangeEvent.class), @JsonSubTypes.Type(name="user_identity_change", value=UserIdentityChangeEvent.class), @JsonSubTypes.Type(name="push_subscription", value=PushSubscriptionEvent.class), @JsonSubTypes.Type(name="application_state_transition", value=ApplicationStateTransitionEvent.class), @JsonSubTypes.Type(name="push_message_receipt", value=PushMessageReceiptEvent.class), @JsonSubTypes.Type(name="product_action", value=ProductActionEvent.class), @JsonSubTypes.Type(name="promotion_action", value=PromotionActionEvent.class), @JsonSubTypes.Type(name="impression", value=ImpressionEvent.class), @JsonSubTypes.Type(name="attribution", value=AttributionEvent.class)})
public abstract class Event {
    private final Type type;
    @JsonProperty(value="id", required=true)
    private final UUID id;
    @JsonProperty(value="timestamp_ms", required=true)
    private long timestamp;
    @JsonProperty(value="source_id")
    private String sourceId;
    @JsonProperty(value="session_id")
    private Long sessionId;
    @JsonProperty(value="location")
    private Location location;
    private Context context;

    public Type getType() {
        return this.type;
    }

    public UUID getId() {
        return this.id;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public Long getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(Long sessionId) {
        this.sessionId = sessionId;
    }

    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public Event(Type eventType) {
        this.type = eventType;
        this.id = UUID.randomUUID();
        this.timestamp = System.currentTimeMillis();
    }

    public static final class Context {
        private final Account account;
        private final List<UserIdentity> userIdentities;
        private final Map<String, String> userAttributes;
        private final Map<String, List<String>> userAttributeLists;
        private final RuntimeEnvironment runtimeEnvironment;

        public Account getAccount() {
            return this.account;
        }

        public List<UserIdentity> getUserIdentities() {
            return this.userIdentities;
        }

        public Map<String, String> getUserAttributes() {
            return this.userAttributes;
        }

        public Map<String, List<String>> getUserAttributeLists() {
            return this.userAttributeLists;
        }

        public RuntimeEnvironment getRuntimeEnvironment() {
            return this.runtimeEnvironment;
        }

        public Context(EventProcessingRequest request) {
            this.account = request.getAccount();
            this.userIdentities = request.getUserIdentities();
            this.userAttributes = request.getUserAttributes();
            this.userAttributeLists = request.getUserAttributeLists();
            this.runtimeEnvironment = request.getRuntimeEnvironment();
        }
    }

    public static enum Type {
        SESSION_START,
        SESSION_END,
        CUSTOM_EVENT,
        SCREEN_VIEW,
        ERROR,
        PRIVACY_SETTING_CHANGE,
        USER_ATTRIBUTE_CHANGE,
        USER_IDENTITY_CHANGE,
        PUSH_SUBSCRIPTION,
        APPLICATION_STATE_TRANSITION,
        PUSH_MESSAGE_RECEIPT,
        PRODUCT_ACTION,
        PROMOTION_ACTION,
        IMPRESSION,
        ATTRIBUTION;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

