/*
 * Decompiled with CFR 0.152.
 */
package com.mparticle.sdk.model.registration;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.mparticle.sdk.Utils;
import com.mparticle.sdk.model.registration.BooleanSetting;
import com.mparticle.sdk.model.registration.FloatSetting;
import com.mparticle.sdk.model.registration.IntegerSetting;
import com.mparticle.sdk.model.registration.TextSetting;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(name="text", value=TextSetting.class), @JsonSubTypes.Type(name="integer", value=IntegerSetting.class), @JsonSubTypes.Type(name="float", value=FloatSetting.class), @JsonSubTypes.Type(name="boolean", value=BooleanSetting.class)})
public abstract class Setting {
    private final Type type;
    @JsonProperty(value="id", required=true)
    private String id;
    @JsonProperty(value="name", required=true)
    private String name;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="visible")
    private boolean isVisible;

    public Type getType() {
        return this.type;
    }

    public String getId() {
        return this.id;
    }

    public Setting setId(String id) {
        if (Utils.isNullOrEmpty(id)) {
            throw new IllegalArgumentException();
        }
        this.id = id;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public Setting setName(String name) throws IllegalArgumentException {
        if (Utils.isNullOrEmpty(name)) {
            throw new IllegalArgumentException();
        }
        this.name = name;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public Setting setDescription(String description) {
        this.description = description;
        return this;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public Setting setIsVisible(boolean visible) {
        this.isVisible = visible;
        return this;
    }

    public Setting(Type type, String id, String name) {
        this.type = type;
        this.setId(id);
        this.setName(name);
        this.setIsVisible(true);
    }

    public static enum Type {
        TEXT,
        INTEGER,
        FLOAT,
        BOOLEAN;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

