/*
 * MX Platform API
 * The MX Platform API is a powerful, fully-featured API designed to make aggregating and enhancing financial data easy and reliable. It can seamlessly connect your app or website to tens of thousands of financial institutions.
 *
 * The version of the OpenAPI document: 0.1.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.mx.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.mx.client.model.CredentialRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * MemberCreateRequest
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class MemberCreateRequest {
  public static final String SERIALIZED_NAME_BACKGROUND_AGGREGATION_IS_DISABLED = "background_aggregation_is_disabled";
  @SerializedName(SERIALIZED_NAME_BACKGROUND_AGGREGATION_IS_DISABLED)
  private Boolean backgroundAggregationIsDisabled;

  public static final String SERIALIZED_NAME_CLIENT_REDIRECT_URL = "client_redirect_url";
  @SerializedName(SERIALIZED_NAME_CLIENT_REDIRECT_URL)
  private String clientRedirectUrl;

  public static final String SERIALIZED_NAME_CREDENTIALS = "credentials";
  @SerializedName(SERIALIZED_NAME_CREDENTIALS)
  private List<CredentialRequest> credentials = new ArrayList<CredentialRequest>();

  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private String id;

  public static final String SERIALIZED_NAME_INSTITUTION_CODE = "institution_code";
  @SerializedName(SERIALIZED_NAME_INSTITUTION_CODE)
  private String institutionCode;

  public static final String SERIALIZED_NAME_IS_OAUTH = "is_oauth";
  @SerializedName(SERIALIZED_NAME_IS_OAUTH)
  private Boolean isOauth;

  public static final String SERIALIZED_NAME_METADATA = "metadata";
  @SerializedName(SERIALIZED_NAME_METADATA)
  private String metadata;

  public static final String SERIALIZED_NAME_SKIP_AGGREGATION = "skip_aggregation";
  @SerializedName(SERIALIZED_NAME_SKIP_AGGREGATION)
  private Boolean skipAggregation;

  public MemberCreateRequest() { 
  }

  public MemberCreateRequest backgroundAggregationIsDisabled(Boolean backgroundAggregationIsDisabled) {
    
    this.backgroundAggregationIsDisabled = backgroundAggregationIsDisabled;
    return this;
  }

   /**
   * Get backgroundAggregationIsDisabled
   * @return backgroundAggregationIsDisabled
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "")

  public Boolean getBackgroundAggregationIsDisabled() {
    return backgroundAggregationIsDisabled;
  }


  public void setBackgroundAggregationIsDisabled(Boolean backgroundAggregationIsDisabled) {
    this.backgroundAggregationIsDisabled = backgroundAggregationIsDisabled;
  }


  public MemberCreateRequest clientRedirectUrl(String clientRedirectUrl) {
    
    this.clientRedirectUrl = clientRedirectUrl;
    return this;
  }

   /**
   * Get clientRedirectUrl
   * @return clientRedirectUrl
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "https://mx.com", value = "")

  public String getClientRedirectUrl() {
    return clientRedirectUrl;
  }


  public void setClientRedirectUrl(String clientRedirectUrl) {
    this.clientRedirectUrl = clientRedirectUrl;
  }


  public MemberCreateRequest credentials(List<CredentialRequest> credentials) {
    
    this.credentials = credentials;
    return this;
  }

  public MemberCreateRequest addCredentialsItem(CredentialRequest credentialsItem) {
    this.credentials.add(credentialsItem);
    return this;
  }

   /**
   * Get credentials
   * @return credentials
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "")

  public List<CredentialRequest> getCredentials() {
    return credentials;
  }


  public void setCredentials(List<CredentialRequest> credentials) {
    this.credentials = credentials;
  }


  public MemberCreateRequest id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * Get id
   * @return id
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "unique_id", value = "")

  public String getId() {
    return id;
  }


  public void setId(String id) {
    this.id = id;
  }


  public MemberCreateRequest institutionCode(String institutionCode) {
    
    this.institutionCode = institutionCode;
    return this;
  }

   /**
   * Get institutionCode
   * @return institutionCode
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(example = "chase", required = true, value = "")

  public String getInstitutionCode() {
    return institutionCode;
  }


  public void setInstitutionCode(String institutionCode) {
    this.institutionCode = institutionCode;
  }


  public MemberCreateRequest isOauth(Boolean isOauth) {
    
    this.isOauth = isOauth;
    return this;
  }

   /**
   * Get isOauth
   * @return isOauth
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "")

  public Boolean getIsOauth() {
    return isOauth;
  }


  public void setIsOauth(Boolean isOauth) {
    this.isOauth = isOauth;
  }


  public MemberCreateRequest metadata(String metadata) {
    
    this.metadata = metadata;
    return this;
  }

   /**
   * Get metadata
   * @return metadata
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "\\\"credentials_last_refreshed_at\\\": \\\"2015-10-15\\\"", value = "")

  public String getMetadata() {
    return metadata;
  }


  public void setMetadata(String metadata) {
    this.metadata = metadata;
  }


  public MemberCreateRequest skipAggregation(Boolean skipAggregation) {
    
    this.skipAggregation = skipAggregation;
    return this;
  }

   /**
   * Get skipAggregation
   * @return skipAggregation
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "")

  public Boolean getSkipAggregation() {
    return skipAggregation;
  }


  public void setSkipAggregation(Boolean skipAggregation) {
    this.skipAggregation = skipAggregation;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MemberCreateRequest memberCreateRequest = (MemberCreateRequest) o;
    return Objects.equals(this.backgroundAggregationIsDisabled, memberCreateRequest.backgroundAggregationIsDisabled) &&
        Objects.equals(this.clientRedirectUrl, memberCreateRequest.clientRedirectUrl) &&
        Objects.equals(this.credentials, memberCreateRequest.credentials) &&
        Objects.equals(this.id, memberCreateRequest.id) &&
        Objects.equals(this.institutionCode, memberCreateRequest.institutionCode) &&
        Objects.equals(this.isOauth, memberCreateRequest.isOauth) &&
        Objects.equals(this.metadata, memberCreateRequest.metadata) &&
        Objects.equals(this.skipAggregation, memberCreateRequest.skipAggregation);
  }

  @Override
  public int hashCode() {
    return Objects.hash(backgroundAggregationIsDisabled, clientRedirectUrl, credentials, id, institutionCode, isOauth, metadata, skipAggregation);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MemberCreateRequest {\n");
    sb.append("    backgroundAggregationIsDisabled: ").append(toIndentedString(backgroundAggregationIsDisabled)).append("\n");
    sb.append("    clientRedirectUrl: ").append(toIndentedString(clientRedirectUrl)).append("\n");
    sb.append("    credentials: ").append(toIndentedString(credentials)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    institutionCode: ").append(toIndentedString(institutionCode)).append("\n");
    sb.append("    isOauth: ").append(toIndentedString(isOauth)).append("\n");
    sb.append("    metadata: ").append(toIndentedString(metadata)).append("\n");
    sb.append("    skipAggregation: ").append(toIndentedString(skipAggregation)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

