/*
 * Decompiled with CFR 0.152.
 */
package com.mx.client.mx_platform_api;

import com.google.gson.reflect.TypeToken;
import com.mx.client.ApiCallback;
import com.mx.client.ApiClient;
import com.mx.client.ApiException;
import com.mx.client.ApiResponse;
import com.mx.client.Configuration;
import com.mx.client.Pair;
import com.mx.client.model.AccountCreateRequestBody;
import com.mx.client.model.AccountNumbersResponseBody;
import com.mx.client.model.AccountOwnersResponseBody;
import com.mx.client.model.AccountResponseBody;
import com.mx.client.model.AccountUpdateRequestBody;
import com.mx.client.model.AccountsResponseBody;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class AccountsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public AccountsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AccountsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createManualAccountCall(String userGuid, AccountCreateRequestBody accountCreateRequestBody, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        AccountCreateRequestBody localVarPostBody = accountCreateRequestBody;
        String localVarPath = "/users/{user_guid}/accounts".replace("{user_guid}", this.localVarApiClient.escapeString(userGuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.mx.api.v1+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createManualAccountValidateBeforeCall(String userGuid, AccountCreateRequestBody accountCreateRequestBody, ApiCallback _callback) throws ApiException {
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling createManualAccount(Async)");
        }
        if (accountCreateRequestBody == null) {
            throw new ApiException("Missing the required parameter 'accountCreateRequestBody' when calling createManualAccount(Async)");
        }
        return this.createManualAccountCall(userGuid, accountCreateRequestBody, _callback);
    }

    public AccountResponseBody createManualAccount(String userGuid, AccountCreateRequestBody accountCreateRequestBody) throws ApiException {
        ApiResponse<AccountResponseBody> localVarResp = this.createManualAccountWithHttpInfo(userGuid, accountCreateRequestBody);
        return localVarResp.getData();
    }

    public ApiResponse<AccountResponseBody> createManualAccountWithHttpInfo(String userGuid, AccountCreateRequestBody accountCreateRequestBody) throws ApiException {
        Call localVarCall = this.createManualAccountValidateBeforeCall(userGuid, accountCreateRequestBody, null);
        Type localVarReturnType = new TypeToken<AccountResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createManualAccountAsync(String userGuid, AccountCreateRequestBody accountCreateRequestBody, ApiCallback<AccountResponseBody> _callback) throws ApiException {
        Call localVarCall = this.createManualAccountValidateBeforeCall(userGuid, accountCreateRequestBody, _callback);
        Type localVarReturnType = new TypeToken<AccountResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteManualAccountCall(String accountGuid, String accept, String userGuid, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/users/{user_guid}/accounts/{account_guid}".replace("{account_guid}", this.localVarApiClient.escapeString(accountGuid.toString())).replace("{user_guid}", this.localVarApiClient.escapeString(userGuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (accept != null) {
            localVarHeaderParams.put("Accept", this.localVarApiClient.parameterToString(accept));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[0])) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteManualAccountValidateBeforeCall(String accountGuid, String accept, String userGuid, ApiCallback _callback) throws ApiException {
        if (accountGuid == null) {
            throw new ApiException("Missing the required parameter 'accountGuid' when calling deleteManualAccount(Async)");
        }
        if (accept == null) {
            throw new ApiException("Missing the required parameter 'accept' when calling deleteManualAccount(Async)");
        }
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling deleteManualAccount(Async)");
        }
        return this.deleteManualAccountCall(accountGuid, accept, userGuid, _callback);
    }

    public void deleteManualAccount(String accountGuid, String accept, String userGuid) throws ApiException {
        this.deleteManualAccountWithHttpInfo(accountGuid, accept, userGuid);
    }

    public ApiResponse<Void> deleteManualAccountWithHttpInfo(String accountGuid, String accept, String userGuid) throws ApiException {
        Call localVarCall = this.deleteManualAccountValidateBeforeCall(accountGuid, accept, userGuid, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteManualAccountAsync(String accountGuid, String accept, String userGuid, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteManualAccountValidateBeforeCall(accountGuid, accept, userGuid, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call listAccountNumbersByAccountCall(String accountGuid, String userGuid, Integer page, Integer recordsPerPage, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/users/{user_guid}/accounts/{account_guid}/account_numbers".replace("{account_guid}", this.localVarApiClient.escapeString(accountGuid.toString())).replace("{user_guid}", this.localVarApiClient.escapeString(userGuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (recordsPerPage != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("records_per_page", recordsPerPage));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/vnd.mx.api.v1+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listAccountNumbersByAccountValidateBeforeCall(String accountGuid, String userGuid, Integer page, Integer recordsPerPage, ApiCallback _callback) throws ApiException {
        if (accountGuid == null) {
            throw new ApiException("Missing the required parameter 'accountGuid' when calling listAccountNumbersByAccount(Async)");
        }
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling listAccountNumbersByAccount(Async)");
        }
        return this.listAccountNumbersByAccountCall(accountGuid, userGuid, page, recordsPerPage, _callback);
    }

    public AccountNumbersResponseBody listAccountNumbersByAccount(String accountGuid, String userGuid, Integer page, Integer recordsPerPage) throws ApiException {
        ApiResponse<AccountNumbersResponseBody> localVarResp = this.listAccountNumbersByAccountWithHttpInfo(accountGuid, userGuid, page, recordsPerPage);
        return localVarResp.getData();
    }

    public ApiResponse<AccountNumbersResponseBody> listAccountNumbersByAccountWithHttpInfo(String accountGuid, String userGuid, Integer page, Integer recordsPerPage) throws ApiException {
        Call localVarCall = this.listAccountNumbersByAccountValidateBeforeCall(accountGuid, userGuid, page, recordsPerPage, null);
        Type localVarReturnType = new TypeToken<AccountNumbersResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listAccountNumbersByAccountAsync(String accountGuid, String userGuid, Integer page, Integer recordsPerPage, ApiCallback<AccountNumbersResponseBody> _callback) throws ApiException {
        Call localVarCall = this.listAccountNumbersByAccountValidateBeforeCall(accountGuid, userGuid, page, recordsPerPage, _callback);
        Type localVarReturnType = new TypeToken<AccountNumbersResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listAccountNumbersByMemberCall(String memberGuid, String userGuid, Integer page, Integer recordsPerPage, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/users/{user_guid}/members/{member_guid}/account_numbers".replace("{member_guid}", this.localVarApiClient.escapeString(memberGuid.toString())).replace("{user_guid}", this.localVarApiClient.escapeString(userGuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (recordsPerPage != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("records_per_page", recordsPerPage));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/vnd.mx.api.v1+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listAccountNumbersByMemberValidateBeforeCall(String memberGuid, String userGuid, Integer page, Integer recordsPerPage, ApiCallback _callback) throws ApiException {
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling listAccountNumbersByMember(Async)");
        }
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling listAccountNumbersByMember(Async)");
        }
        return this.listAccountNumbersByMemberCall(memberGuid, userGuid, page, recordsPerPage, _callback);
    }

    public AccountNumbersResponseBody listAccountNumbersByMember(String memberGuid, String userGuid, Integer page, Integer recordsPerPage) throws ApiException {
        ApiResponse<AccountNumbersResponseBody> localVarResp = this.listAccountNumbersByMemberWithHttpInfo(memberGuid, userGuid, page, recordsPerPage);
        return localVarResp.getData();
    }

    public ApiResponse<AccountNumbersResponseBody> listAccountNumbersByMemberWithHttpInfo(String memberGuid, String userGuid, Integer page, Integer recordsPerPage) throws ApiException {
        Call localVarCall = this.listAccountNumbersByMemberValidateBeforeCall(memberGuid, userGuid, page, recordsPerPage, null);
        Type localVarReturnType = new TypeToken<AccountNumbersResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listAccountNumbersByMemberAsync(String memberGuid, String userGuid, Integer page, Integer recordsPerPage, ApiCallback<AccountNumbersResponseBody> _callback) throws ApiException {
        Call localVarCall = this.listAccountNumbersByMemberValidateBeforeCall(memberGuid, userGuid, page, recordsPerPage, _callback);
        Type localVarReturnType = new TypeToken<AccountNumbersResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listAccountOwnersByMemberCall(String memberGuid, String userGuid, Integer page, Integer recordsPerPage, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/users/{user_guid}/members/{member_guid}/account_owners".replace("{member_guid}", this.localVarApiClient.escapeString(memberGuid.toString())).replace("{user_guid}", this.localVarApiClient.escapeString(userGuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (recordsPerPage != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("records_per_page", recordsPerPage));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/vnd.mx.api.v1+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listAccountOwnersByMemberValidateBeforeCall(String memberGuid, String userGuid, Integer page, Integer recordsPerPage, ApiCallback _callback) throws ApiException {
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling listAccountOwnersByMember(Async)");
        }
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling listAccountOwnersByMember(Async)");
        }
        return this.listAccountOwnersByMemberCall(memberGuid, userGuid, page, recordsPerPage, _callback);
    }

    public AccountOwnersResponseBody listAccountOwnersByMember(String memberGuid, String userGuid, Integer page, Integer recordsPerPage) throws ApiException {
        ApiResponse<AccountOwnersResponseBody> localVarResp = this.listAccountOwnersByMemberWithHttpInfo(memberGuid, userGuid, page, recordsPerPage);
        return localVarResp.getData();
    }

    public ApiResponse<AccountOwnersResponseBody> listAccountOwnersByMemberWithHttpInfo(String memberGuid, String userGuid, Integer page, Integer recordsPerPage) throws ApiException {
        Call localVarCall = this.listAccountOwnersByMemberValidateBeforeCall(memberGuid, userGuid, page, recordsPerPage, null);
        Type localVarReturnType = new TypeToken<AccountOwnersResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listAccountOwnersByMemberAsync(String memberGuid, String userGuid, Integer page, Integer recordsPerPage, ApiCallback<AccountOwnersResponseBody> _callback) throws ApiException {
        Call localVarCall = this.listAccountOwnersByMemberValidateBeforeCall(memberGuid, userGuid, page, recordsPerPage, _callback);
        Type localVarReturnType = new TypeToken<AccountOwnersResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listMemberAccountsCall(String userGuid, String memberGuid, Boolean memberIsManagedByUser, Integer page, Integer recordsPerPage, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/users/{user_guid}/members/{member_guid}/accounts".replace("{user_guid}", this.localVarApiClient.escapeString(userGuid.toString())).replace("{member_guid}", this.localVarApiClient.escapeString(memberGuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (memberIsManagedByUser != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("member_is_managed_by_user", memberIsManagedByUser));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (recordsPerPage != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("records_per_page", recordsPerPage));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/vnd.mx.api.v1+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listMemberAccountsValidateBeforeCall(String userGuid, String memberGuid, Boolean memberIsManagedByUser, Integer page, Integer recordsPerPage, ApiCallback _callback) throws ApiException {
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling listMemberAccounts(Async)");
        }
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling listMemberAccounts(Async)");
        }
        return this.listMemberAccountsCall(userGuid, memberGuid, memberIsManagedByUser, page, recordsPerPage, _callback);
    }

    public AccountsResponseBody listMemberAccounts(String userGuid, String memberGuid, Boolean memberIsManagedByUser, Integer page, Integer recordsPerPage) throws ApiException {
        ApiResponse<AccountsResponseBody> localVarResp = this.listMemberAccountsWithHttpInfo(userGuid, memberGuid, memberIsManagedByUser, page, recordsPerPage);
        return localVarResp.getData();
    }

    public ApiResponse<AccountsResponseBody> listMemberAccountsWithHttpInfo(String userGuid, String memberGuid, Boolean memberIsManagedByUser, Integer page, Integer recordsPerPage) throws ApiException {
        Call localVarCall = this.listMemberAccountsValidateBeforeCall(userGuid, memberGuid, memberIsManagedByUser, page, recordsPerPage, null);
        Type localVarReturnType = new TypeToken<AccountsResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listMemberAccountsAsync(String userGuid, String memberGuid, Boolean memberIsManagedByUser, Integer page, Integer recordsPerPage, ApiCallback<AccountsResponseBody> _callback) throws ApiException {
        Call localVarCall = this.listMemberAccountsValidateBeforeCall(userGuid, memberGuid, memberIsManagedByUser, page, recordsPerPage, _callback);
        Type localVarReturnType = new TypeToken<AccountsResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listUserAccountsCall(String userGuid, Integer page, Boolean memberIsManagedByUser, Boolean isManual, Integer recordsPerPage, String useCase, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/users/{user_guid}/accounts".replace("{user_guid}", this.localVarApiClient.escapeString(userGuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (memberIsManagedByUser != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("member_is_managed_by_user", memberIsManagedByUser));
        }
        if (isManual != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("is_manual", isManual));
        }
        if (recordsPerPage != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("records_per_page", recordsPerPage));
        }
        if (useCase != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("use_case", useCase));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/vnd.mx.api.v1+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listUserAccountsValidateBeforeCall(String userGuid, Integer page, Boolean memberIsManagedByUser, Boolean isManual, Integer recordsPerPage, String useCase, ApiCallback _callback) throws ApiException {
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling listUserAccounts(Async)");
        }
        return this.listUserAccountsCall(userGuid, page, memberIsManagedByUser, isManual, recordsPerPage, useCase, _callback);
    }

    public AccountsResponseBody listUserAccounts(String userGuid, Integer page, Boolean memberIsManagedByUser, Boolean isManual, Integer recordsPerPage, String useCase) throws ApiException {
        ApiResponse<AccountsResponseBody> localVarResp = this.listUserAccountsWithHttpInfo(userGuid, page, memberIsManagedByUser, isManual, recordsPerPage, useCase);
        return localVarResp.getData();
    }

    public ApiResponse<AccountsResponseBody> listUserAccountsWithHttpInfo(String userGuid, Integer page, Boolean memberIsManagedByUser, Boolean isManual, Integer recordsPerPage, String useCase) throws ApiException {
        Call localVarCall = this.listUserAccountsValidateBeforeCall(userGuid, page, memberIsManagedByUser, isManual, recordsPerPage, useCase, null);
        Type localVarReturnType = new TypeToken<AccountsResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listUserAccountsAsync(String userGuid, Integer page, Boolean memberIsManagedByUser, Boolean isManual, Integer recordsPerPage, String useCase, ApiCallback<AccountsResponseBody> _callback) throws ApiException {
        Call localVarCall = this.listUserAccountsValidateBeforeCall(userGuid, page, memberIsManagedByUser, isManual, recordsPerPage, useCase, _callback);
        Type localVarReturnType = new TypeToken<AccountsResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readAccountCall(String accountGuid, String userGuid, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/users/{user_guid}/accounts/{account_guid}".replace("{account_guid}", this.localVarApiClient.escapeString(accountGuid.toString())).replace("{user_guid}", this.localVarApiClient.escapeString(userGuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.mx.api.v1+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readAccountValidateBeforeCall(String accountGuid, String userGuid, ApiCallback _callback) throws ApiException {
        if (accountGuid == null) {
            throw new ApiException("Missing the required parameter 'accountGuid' when calling readAccount(Async)");
        }
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling readAccount(Async)");
        }
        return this.readAccountCall(accountGuid, userGuid, _callback);
    }

    public AccountResponseBody readAccount(String accountGuid, String userGuid) throws ApiException {
        ApiResponse<AccountResponseBody> localVarResp = this.readAccountWithHttpInfo(accountGuid, userGuid);
        return localVarResp.getData();
    }

    public ApiResponse<AccountResponseBody> readAccountWithHttpInfo(String accountGuid, String userGuid) throws ApiException {
        Call localVarCall = this.readAccountValidateBeforeCall(accountGuid, userGuid, null);
        Type localVarReturnType = new TypeToken<AccountResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readAccountAsync(String accountGuid, String userGuid, ApiCallback<AccountResponseBody> _callback) throws ApiException {
        Call localVarCall = this.readAccountValidateBeforeCall(accountGuid, userGuid, _callback);
        Type localVarReturnType = new TypeToken<AccountResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readAccountByMemberCall(String accountGuid, String memberGuid, String userGuid, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/users/{user_guid}/members/{member_guid}/accounts/{account_guid}".replace("{account_guid}", this.localVarApiClient.escapeString(accountGuid.toString())).replace("{member_guid}", this.localVarApiClient.escapeString(memberGuid.toString())).replace("{user_guid}", this.localVarApiClient.escapeString(userGuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.mx.api.v1+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readAccountByMemberValidateBeforeCall(String accountGuid, String memberGuid, String userGuid, ApiCallback _callback) throws ApiException {
        if (accountGuid == null) {
            throw new ApiException("Missing the required parameter 'accountGuid' when calling readAccountByMember(Async)");
        }
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling readAccountByMember(Async)");
        }
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling readAccountByMember(Async)");
        }
        return this.readAccountByMemberCall(accountGuid, memberGuid, userGuid, _callback);
    }

    public AccountResponseBody readAccountByMember(String accountGuid, String memberGuid, String userGuid) throws ApiException {
        ApiResponse<AccountResponseBody> localVarResp = this.readAccountByMemberWithHttpInfo(accountGuid, memberGuid, userGuid);
        return localVarResp.getData();
    }

    public ApiResponse<AccountResponseBody> readAccountByMemberWithHttpInfo(String accountGuid, String memberGuid, String userGuid) throws ApiException {
        Call localVarCall = this.readAccountByMemberValidateBeforeCall(accountGuid, memberGuid, userGuid, null);
        Type localVarReturnType = new TypeToken<AccountResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readAccountByMemberAsync(String accountGuid, String memberGuid, String userGuid, ApiCallback<AccountResponseBody> _callback) throws ApiException {
        Call localVarCall = this.readAccountByMemberValidateBeforeCall(accountGuid, memberGuid, userGuid, _callback);
        Type localVarReturnType = new TypeToken<AccountResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateAccountByMemberCall(String accountGuid, String memberGuid, String userGuid, AccountUpdateRequestBody accountUpdateRequestBody, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        AccountUpdateRequestBody localVarPostBody = accountUpdateRequestBody;
        String localVarPath = "/users/{user_guid}/members/{member_guid}/accounts/{account_guid}".replace("{account_guid}", this.localVarApiClient.escapeString(accountGuid.toString())).replace("{member_guid}", this.localVarApiClient.escapeString(memberGuid.toString())).replace("{user_guid}", this.localVarApiClient.escapeString(userGuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.mx.api.v1+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateAccountByMemberValidateBeforeCall(String accountGuid, String memberGuid, String userGuid, AccountUpdateRequestBody accountUpdateRequestBody, ApiCallback _callback) throws ApiException {
        if (accountGuid == null) {
            throw new ApiException("Missing the required parameter 'accountGuid' when calling updateAccountByMember(Async)");
        }
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling updateAccountByMember(Async)");
        }
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling updateAccountByMember(Async)");
        }
        if (accountUpdateRequestBody == null) {
            throw new ApiException("Missing the required parameter 'accountUpdateRequestBody' when calling updateAccountByMember(Async)");
        }
        return this.updateAccountByMemberCall(accountGuid, memberGuid, userGuid, accountUpdateRequestBody, _callback);
    }

    public AccountResponseBody updateAccountByMember(String accountGuid, String memberGuid, String userGuid, AccountUpdateRequestBody accountUpdateRequestBody) throws ApiException {
        ApiResponse<AccountResponseBody> localVarResp = this.updateAccountByMemberWithHttpInfo(accountGuid, memberGuid, userGuid, accountUpdateRequestBody);
        return localVarResp.getData();
    }

    public ApiResponse<AccountResponseBody> updateAccountByMemberWithHttpInfo(String accountGuid, String memberGuid, String userGuid, AccountUpdateRequestBody accountUpdateRequestBody) throws ApiException {
        Call localVarCall = this.updateAccountByMemberValidateBeforeCall(accountGuid, memberGuid, userGuid, accountUpdateRequestBody, null);
        Type localVarReturnType = new TypeToken<AccountResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateAccountByMemberAsync(String accountGuid, String memberGuid, String userGuid, AccountUpdateRequestBody accountUpdateRequestBody, ApiCallback<AccountResponseBody> _callback) throws ApiException {
        Call localVarCall = this.updateAccountByMemberValidateBeforeCall(accountGuid, memberGuid, userGuid, accountUpdateRequestBody, _callback);
        Type localVarReturnType = new TypeToken<AccountResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

