/*
 * Decompiled with CFR 0.152.
 */
package com.mx.client.mx_platform_api;

import com.google.gson.reflect.TypeToken;
import com.mx.client.ApiCallback;
import com.mx.client.ApiClient;
import com.mx.client.ApiException;
import com.mx.client.ApiResponse;
import com.mx.client.Configuration;
import com.mx.client.Pair;
import com.mx.client.model.BudgetCreateRequestBody;
import com.mx.client.model.BudgetResponseBody;
import com.mx.client.model.BudgetUpdateRequestBody;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class BudgetsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public BudgetsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public BudgetsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call autoGenerateBudgetsCall(String userGuid, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/users/{user_guid}/budgets/generate".replace("{user_guid}", this.localVarApiClient.escapeString(userGuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.mx.api.v1+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call autoGenerateBudgetsValidateBeforeCall(String userGuid, ApiCallback _callback) throws ApiException {
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling autoGenerateBudgets(Async)");
        }
        return this.autoGenerateBudgetsCall(userGuid, _callback);
    }

    public BudgetResponseBody autoGenerateBudgets(String userGuid) throws ApiException {
        ApiResponse<BudgetResponseBody> localVarResp = this.autoGenerateBudgetsWithHttpInfo(userGuid);
        return localVarResp.getData();
    }

    public ApiResponse<BudgetResponseBody> autoGenerateBudgetsWithHttpInfo(String userGuid) throws ApiException {
        Call localVarCall = this.autoGenerateBudgetsValidateBeforeCall(userGuid, null);
        Type localVarReturnType = new TypeToken<BudgetResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call autoGenerateBudgetsAsync(String userGuid, ApiCallback<BudgetResponseBody> _callback) throws ApiException {
        Call localVarCall = this.autoGenerateBudgetsValidateBeforeCall(userGuid, _callback);
        Type localVarReturnType = new TypeToken<BudgetResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call createBudgetCall(String userGuid, BudgetCreateRequestBody budgetCreateRequestBody, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        BudgetCreateRequestBody localVarPostBody = budgetCreateRequestBody;
        String localVarPath = "/users/{user_guid}/budgets".replace("{user_guid}", this.localVarApiClient.escapeString(userGuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/vnd.mx.api.v1+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createBudgetValidateBeforeCall(String userGuid, BudgetCreateRequestBody budgetCreateRequestBody, ApiCallback _callback) throws ApiException {
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling createBudget(Async)");
        }
        if (budgetCreateRequestBody == null) {
            throw new ApiException("Missing the required parameter 'budgetCreateRequestBody' when calling createBudget(Async)");
        }
        return this.createBudgetCall(userGuid, budgetCreateRequestBody, _callback);
    }

    public BudgetResponseBody createBudget(String userGuid, BudgetCreateRequestBody budgetCreateRequestBody) throws ApiException {
        ApiResponse<BudgetResponseBody> localVarResp = this.createBudgetWithHttpInfo(userGuid, budgetCreateRequestBody);
        return localVarResp.getData();
    }

    public ApiResponse<BudgetResponseBody> createBudgetWithHttpInfo(String userGuid, BudgetCreateRequestBody budgetCreateRequestBody) throws ApiException {
        Call localVarCall = this.createBudgetValidateBeforeCall(userGuid, budgetCreateRequestBody, null);
        Type localVarReturnType = new TypeToken<BudgetResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createBudgetAsync(String userGuid, BudgetCreateRequestBody budgetCreateRequestBody, ApiCallback<BudgetResponseBody> _callback) throws ApiException {
        Call localVarCall = this.createBudgetValidateBeforeCall(userGuid, budgetCreateRequestBody, _callback);
        Type localVarReturnType = new TypeToken<BudgetResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteBudgetCall(String userGuid, String budgetGuid, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/users/{user_guid}/budgets/{budget_guid}".replace("{user_guid}", this.localVarApiClient.escapeString(userGuid.toString())).replace("{budget_guid}", this.localVarApiClient.escapeString(budgetGuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteBudgetValidateBeforeCall(String userGuid, String budgetGuid, ApiCallback _callback) throws ApiException {
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling deleteBudget(Async)");
        }
        if (budgetGuid == null) {
            throw new ApiException("Missing the required parameter 'budgetGuid' when calling deleteBudget(Async)");
        }
        return this.deleteBudgetCall(userGuid, budgetGuid, _callback);
    }

    public void deleteBudget(String userGuid, String budgetGuid) throws ApiException {
        this.deleteBudgetWithHttpInfo(userGuid, budgetGuid);
    }

    public ApiResponse<Void> deleteBudgetWithHttpInfo(String userGuid, String budgetGuid) throws ApiException {
        Call localVarCall = this.deleteBudgetValidateBeforeCall(userGuid, budgetGuid, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteBudgetAsync(String userGuid, String budgetGuid, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteBudgetValidateBeforeCall(userGuid, budgetGuid, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call listAllBudgetsCall(String userGuid, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/users/{user_guid}/budgets".replace("{user_guid}", this.localVarApiClient.escapeString(userGuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.mx.api.v1+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listAllBudgetsValidateBeforeCall(String userGuid, ApiCallback _callback) throws ApiException {
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling listAllBudgets(Async)");
        }
        return this.listAllBudgetsCall(userGuid, _callback);
    }

    public BudgetResponseBody listAllBudgets(String userGuid) throws ApiException {
        ApiResponse<BudgetResponseBody> localVarResp = this.listAllBudgetsWithHttpInfo(userGuid);
        return localVarResp.getData();
    }

    public ApiResponse<BudgetResponseBody> listAllBudgetsWithHttpInfo(String userGuid) throws ApiException {
        Call localVarCall = this.listAllBudgetsValidateBeforeCall(userGuid, null);
        Type localVarReturnType = new TypeToken<BudgetResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listAllBudgetsAsync(String userGuid, ApiCallback<BudgetResponseBody> _callback) throws ApiException {
        Call localVarCall = this.listAllBudgetsValidateBeforeCall(userGuid, _callback);
        Type localVarReturnType = new TypeToken<BudgetResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readSpecificBudgetCall(String userGuid, String budgetGuid, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/users/{user_guid}/budgets/{budget_guid}".replace("{user_guid}", this.localVarApiClient.escapeString(userGuid.toString())).replace("{budget_guid}", this.localVarApiClient.escapeString(budgetGuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.mx.api.v1+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readSpecificBudgetValidateBeforeCall(String userGuid, String budgetGuid, ApiCallback _callback) throws ApiException {
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling readSpecificBudget(Async)");
        }
        if (budgetGuid == null) {
            throw new ApiException("Missing the required parameter 'budgetGuid' when calling readSpecificBudget(Async)");
        }
        return this.readSpecificBudgetCall(userGuid, budgetGuid, _callback);
    }

    public BudgetResponseBody readSpecificBudget(String userGuid, String budgetGuid) throws ApiException {
        ApiResponse<BudgetResponseBody> localVarResp = this.readSpecificBudgetWithHttpInfo(userGuid, budgetGuid);
        return localVarResp.getData();
    }

    public ApiResponse<BudgetResponseBody> readSpecificBudgetWithHttpInfo(String userGuid, String budgetGuid) throws ApiException {
        Call localVarCall = this.readSpecificBudgetValidateBeforeCall(userGuid, budgetGuid, null);
        Type localVarReturnType = new TypeToken<BudgetResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readSpecificBudgetAsync(String userGuid, String budgetGuid, ApiCallback<BudgetResponseBody> _callback) throws ApiException {
        Call localVarCall = this.readSpecificBudgetValidateBeforeCall(userGuid, budgetGuid, _callback);
        Type localVarReturnType = new TypeToken<BudgetResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateSpecificBudgetCall(String userGuid, String budgetGuid, BudgetUpdateRequestBody budgetUpdateRequestBody, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        BudgetUpdateRequestBody localVarPostBody = budgetUpdateRequestBody;
        String localVarPath = "/users/{user_guid}/budgets/{budget_guid}".replace("{user_guid}", this.localVarApiClient.escapeString(userGuid.toString())).replace("{budget_guid}", this.localVarApiClient.escapeString(budgetGuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/vnd.mx.api.v1+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateSpecificBudgetValidateBeforeCall(String userGuid, String budgetGuid, BudgetUpdateRequestBody budgetUpdateRequestBody, ApiCallback _callback) throws ApiException {
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling updateSpecificBudget(Async)");
        }
        if (budgetGuid == null) {
            throw new ApiException("Missing the required parameter 'budgetGuid' when calling updateSpecificBudget(Async)");
        }
        return this.updateSpecificBudgetCall(userGuid, budgetGuid, budgetUpdateRequestBody, _callback);
    }

    public BudgetResponseBody updateSpecificBudget(String userGuid, String budgetGuid, BudgetUpdateRequestBody budgetUpdateRequestBody) throws ApiException {
        ApiResponse<BudgetResponseBody> localVarResp = this.updateSpecificBudgetWithHttpInfo(userGuid, budgetGuid, budgetUpdateRequestBody);
        return localVarResp.getData();
    }

    public ApiResponse<BudgetResponseBody> updateSpecificBudgetWithHttpInfo(String userGuid, String budgetGuid, BudgetUpdateRequestBody budgetUpdateRequestBody) throws ApiException {
        Call localVarCall = this.updateSpecificBudgetValidateBeforeCall(userGuid, budgetGuid, budgetUpdateRequestBody, null);
        Type localVarReturnType = new TypeToken<BudgetResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateSpecificBudgetAsync(String userGuid, String budgetGuid, BudgetUpdateRequestBody budgetUpdateRequestBody, ApiCallback<BudgetResponseBody> _callback) throws ApiException {
        Call localVarCall = this.updateSpecificBudgetValidateBeforeCall(userGuid, budgetGuid, budgetUpdateRequestBody, _callback);
        Type localVarReturnType = new TypeToken<BudgetResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

