/*
 * Decompiled with CFR 0.152.
 */
package com.mx.client.mx_platform_api;

import com.google.gson.reflect.TypeToken;
import com.mx.client.ApiCallback;
import com.mx.client.ApiClient;
import com.mx.client.ApiException;
import com.mx.client.ApiResponse;
import com.mx.client.Configuration;
import com.mx.client.Pair;
import com.mx.client.model.CategoriesResponseBody;
import com.mx.client.model.CategoryCreateRequestBody;
import com.mx.client.model.CategoryResponseBody;
import com.mx.client.model.CategoryUpdateRequestBody;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class CategoriesApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public CategoriesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public CategoriesApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createCategoryCall(String userGuid, CategoryCreateRequestBody categoryCreateRequestBody, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CategoryCreateRequestBody localVarPostBody = categoryCreateRequestBody;
        String localVarPath = "/users/{user_guid}/categories".replace("{user_guid}", this.localVarApiClient.escapeString(userGuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.mx.api.v1+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createCategoryValidateBeforeCall(String userGuid, CategoryCreateRequestBody categoryCreateRequestBody, ApiCallback _callback) throws ApiException {
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling createCategory(Async)");
        }
        if (categoryCreateRequestBody == null) {
            throw new ApiException("Missing the required parameter 'categoryCreateRequestBody' when calling createCategory(Async)");
        }
        return this.createCategoryCall(userGuid, categoryCreateRequestBody, _callback);
    }

    public CategoryResponseBody createCategory(String userGuid, CategoryCreateRequestBody categoryCreateRequestBody) throws ApiException {
        ApiResponse<CategoryResponseBody> localVarResp = this.createCategoryWithHttpInfo(userGuid, categoryCreateRequestBody);
        return localVarResp.getData();
    }

    public ApiResponse<CategoryResponseBody> createCategoryWithHttpInfo(String userGuid, CategoryCreateRequestBody categoryCreateRequestBody) throws ApiException {
        Call localVarCall = this.createCategoryValidateBeforeCall(userGuid, categoryCreateRequestBody, null);
        Type localVarReturnType = new TypeToken<CategoryResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createCategoryAsync(String userGuid, CategoryCreateRequestBody categoryCreateRequestBody, ApiCallback<CategoryResponseBody> _callback) throws ApiException {
        Call localVarCall = this.createCategoryValidateBeforeCall(userGuid, categoryCreateRequestBody, _callback);
        Type localVarReturnType = new TypeToken<CategoryResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteCategoryCall(String categoryGuid, String userGuid, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/users/{user_guid}/categories/{category_guid}".replace("{category_guid}", this.localVarApiClient.escapeString(categoryGuid.toString())).replace("{user_guid}", this.localVarApiClient.escapeString(userGuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteCategoryValidateBeforeCall(String categoryGuid, String userGuid, ApiCallback _callback) throws ApiException {
        if (categoryGuid == null) {
            throw new ApiException("Missing the required parameter 'categoryGuid' when calling deleteCategory(Async)");
        }
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling deleteCategory(Async)");
        }
        return this.deleteCategoryCall(categoryGuid, userGuid, _callback);
    }

    public void deleteCategory(String categoryGuid, String userGuid) throws ApiException {
        this.deleteCategoryWithHttpInfo(categoryGuid, userGuid);
    }

    public ApiResponse<Void> deleteCategoryWithHttpInfo(String categoryGuid, String userGuid) throws ApiException {
        Call localVarCall = this.deleteCategoryValidateBeforeCall(categoryGuid, userGuid, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteCategoryAsync(String categoryGuid, String userGuid, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteCategoryValidateBeforeCall(categoryGuid, userGuid, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call listCategoriesCall(String userGuid, Integer page, Integer recordsPerPage, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/users/{user_guid}/categories".replace("{user_guid}", this.localVarApiClient.escapeString(userGuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (recordsPerPage != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("records_per_page", recordsPerPage));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/vnd.mx.api.v1+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listCategoriesValidateBeforeCall(String userGuid, Integer page, Integer recordsPerPage, ApiCallback _callback) throws ApiException {
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling listCategories(Async)");
        }
        return this.listCategoriesCall(userGuid, page, recordsPerPage, _callback);
    }

    public CategoriesResponseBody listCategories(String userGuid, Integer page, Integer recordsPerPage) throws ApiException {
        ApiResponse<CategoriesResponseBody> localVarResp = this.listCategoriesWithHttpInfo(userGuid, page, recordsPerPage);
        return localVarResp.getData();
    }

    public ApiResponse<CategoriesResponseBody> listCategoriesWithHttpInfo(String userGuid, Integer page, Integer recordsPerPage) throws ApiException {
        Call localVarCall = this.listCategoriesValidateBeforeCall(userGuid, page, recordsPerPage, null);
        Type localVarReturnType = new TypeToken<CategoriesResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listCategoriesAsync(String userGuid, Integer page, Integer recordsPerPage, ApiCallback<CategoriesResponseBody> _callback) throws ApiException {
        Call localVarCall = this.listCategoriesValidateBeforeCall(userGuid, page, recordsPerPage, _callback);
        Type localVarReturnType = new TypeToken<CategoriesResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listDefaultCategoriesCall(Integer page, Integer recordsPerPage, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/categories/default";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (recordsPerPage != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("records_per_page", recordsPerPage));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/vnd.mx.api.v1+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listDefaultCategoriesValidateBeforeCall(Integer page, Integer recordsPerPage, ApiCallback _callback) throws ApiException {
        return this.listDefaultCategoriesCall(page, recordsPerPage, _callback);
    }

    public CategoriesResponseBody listDefaultCategories(Integer page, Integer recordsPerPage) throws ApiException {
        ApiResponse<CategoriesResponseBody> localVarResp = this.listDefaultCategoriesWithHttpInfo(page, recordsPerPage);
        return localVarResp.getData();
    }

    public ApiResponse<CategoriesResponseBody> listDefaultCategoriesWithHttpInfo(Integer page, Integer recordsPerPage) throws ApiException {
        Call localVarCall = this.listDefaultCategoriesValidateBeforeCall(page, recordsPerPage, null);
        Type localVarReturnType = new TypeToken<CategoriesResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listDefaultCategoriesAsync(Integer page, Integer recordsPerPage, ApiCallback<CategoriesResponseBody> _callback) throws ApiException {
        Call localVarCall = this.listDefaultCategoriesValidateBeforeCall(page, recordsPerPage, _callback);
        Type localVarReturnType = new TypeToken<CategoriesResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listDefaultCategoriesByUserCall(String userGuid, Integer page, Integer recordsPerPage, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/users/{user_guid}/categories/default".replace("{user_guid}", this.localVarApiClient.escapeString(userGuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (recordsPerPage != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("records_per_page", recordsPerPage));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/vnd.mx.api.v1+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listDefaultCategoriesByUserValidateBeforeCall(String userGuid, Integer page, Integer recordsPerPage, ApiCallback _callback) throws ApiException {
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling listDefaultCategoriesByUser(Async)");
        }
        return this.listDefaultCategoriesByUserCall(userGuid, page, recordsPerPage, _callback);
    }

    public CategoriesResponseBody listDefaultCategoriesByUser(String userGuid, Integer page, Integer recordsPerPage) throws ApiException {
        ApiResponse<CategoriesResponseBody> localVarResp = this.listDefaultCategoriesByUserWithHttpInfo(userGuid, page, recordsPerPage);
        return localVarResp.getData();
    }

    public ApiResponse<CategoriesResponseBody> listDefaultCategoriesByUserWithHttpInfo(String userGuid, Integer page, Integer recordsPerPage) throws ApiException {
        Call localVarCall = this.listDefaultCategoriesByUserValidateBeforeCall(userGuid, page, recordsPerPage, null);
        Type localVarReturnType = new TypeToken<CategoriesResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listDefaultCategoriesByUserAsync(String userGuid, Integer page, Integer recordsPerPage, ApiCallback<CategoriesResponseBody> _callback) throws ApiException {
        Call localVarCall = this.listDefaultCategoriesByUserValidateBeforeCall(userGuid, page, recordsPerPage, _callback);
        Type localVarReturnType = new TypeToken<CategoriesResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readCategoryCall(String categoryGuid, String userGuid, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/users/{user_guid}/categories/{category_guid}".replace("{category_guid}", this.localVarApiClient.escapeString(categoryGuid.toString())).replace("{user_guid}", this.localVarApiClient.escapeString(userGuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.mx.api.v1+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readCategoryValidateBeforeCall(String categoryGuid, String userGuid, ApiCallback _callback) throws ApiException {
        if (categoryGuid == null) {
            throw new ApiException("Missing the required parameter 'categoryGuid' when calling readCategory(Async)");
        }
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling readCategory(Async)");
        }
        return this.readCategoryCall(categoryGuid, userGuid, _callback);
    }

    public CategoryResponseBody readCategory(String categoryGuid, String userGuid) throws ApiException {
        ApiResponse<CategoryResponseBody> localVarResp = this.readCategoryWithHttpInfo(categoryGuid, userGuid);
        return localVarResp.getData();
    }

    public ApiResponse<CategoryResponseBody> readCategoryWithHttpInfo(String categoryGuid, String userGuid) throws ApiException {
        Call localVarCall = this.readCategoryValidateBeforeCall(categoryGuid, userGuid, null);
        Type localVarReturnType = new TypeToken<CategoryResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readCategoryAsync(String categoryGuid, String userGuid, ApiCallback<CategoryResponseBody> _callback) throws ApiException {
        Call localVarCall = this.readCategoryValidateBeforeCall(categoryGuid, userGuid, _callback);
        Type localVarReturnType = new TypeToken<CategoryResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readDefaultCategoryCall(String categoryGuid, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/categories/{category_guid}".replace("{category_guid}", this.localVarApiClient.escapeString(categoryGuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.mx.api.v1+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readDefaultCategoryValidateBeforeCall(String categoryGuid, ApiCallback _callback) throws ApiException {
        if (categoryGuid == null) {
            throw new ApiException("Missing the required parameter 'categoryGuid' when calling readDefaultCategory(Async)");
        }
        return this.readDefaultCategoryCall(categoryGuid, _callback);
    }

    public CategoryResponseBody readDefaultCategory(String categoryGuid) throws ApiException {
        ApiResponse<CategoryResponseBody> localVarResp = this.readDefaultCategoryWithHttpInfo(categoryGuid);
        return localVarResp.getData();
    }

    public ApiResponse<CategoryResponseBody> readDefaultCategoryWithHttpInfo(String categoryGuid) throws ApiException {
        Call localVarCall = this.readDefaultCategoryValidateBeforeCall(categoryGuid, null);
        Type localVarReturnType = new TypeToken<CategoryResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readDefaultCategoryAsync(String categoryGuid, ApiCallback<CategoryResponseBody> _callback) throws ApiException {
        Call localVarCall = this.readDefaultCategoryValidateBeforeCall(categoryGuid, _callback);
        Type localVarReturnType = new TypeToken<CategoryResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateCategoryCall(String categoryGuid, String userGuid, CategoryUpdateRequestBody categoryUpdateRequestBody, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CategoryUpdateRequestBody localVarPostBody = categoryUpdateRequestBody;
        String localVarPath = "/users/{user_guid}/categories/{category_guid}".replace("{category_guid}", this.localVarApiClient.escapeString(categoryGuid.toString())).replace("{user_guid}", this.localVarApiClient.escapeString(userGuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.mx.api.v1+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateCategoryValidateBeforeCall(String categoryGuid, String userGuid, CategoryUpdateRequestBody categoryUpdateRequestBody, ApiCallback _callback) throws ApiException {
        if (categoryGuid == null) {
            throw new ApiException("Missing the required parameter 'categoryGuid' when calling updateCategory(Async)");
        }
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling updateCategory(Async)");
        }
        if (categoryUpdateRequestBody == null) {
            throw new ApiException("Missing the required parameter 'categoryUpdateRequestBody' when calling updateCategory(Async)");
        }
        return this.updateCategoryCall(categoryGuid, userGuid, categoryUpdateRequestBody, _callback);
    }

    public CategoryResponseBody updateCategory(String categoryGuid, String userGuid, CategoryUpdateRequestBody categoryUpdateRequestBody) throws ApiException {
        ApiResponse<CategoryResponseBody> localVarResp = this.updateCategoryWithHttpInfo(categoryGuid, userGuid, categoryUpdateRequestBody);
        return localVarResp.getData();
    }

    public ApiResponse<CategoryResponseBody> updateCategoryWithHttpInfo(String categoryGuid, String userGuid, CategoryUpdateRequestBody categoryUpdateRequestBody) throws ApiException {
        Call localVarCall = this.updateCategoryValidateBeforeCall(categoryGuid, userGuid, categoryUpdateRequestBody, null);
        Type localVarReturnType = new TypeToken<CategoryResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateCategoryAsync(String categoryGuid, String userGuid, CategoryUpdateRequestBody categoryUpdateRequestBody, ApiCallback<CategoryResponseBody> _callback) throws ApiException {
        Call localVarCall = this.updateCategoryValidateBeforeCall(categoryGuid, userGuid, categoryUpdateRequestBody, _callback);
        Type localVarReturnType = new TypeToken<CategoryResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

