/*
 * Decompiled with CFR 0.152.
 */
package com.mx.client.mx_platform_api;

import com.google.gson.reflect.TypeToken;
import com.mx.client.ApiCallback;
import com.mx.client.ApiClient;
import com.mx.client.ApiException;
import com.mx.client.ApiResponse;
import com.mx.client.Configuration;
import com.mx.client.Pair;
import com.mx.client.model.AccountResponseBody;
import com.mx.client.model.AccountsResponseBody;
import com.mx.client.model.InstitutionsResponseBody;
import com.mx.client.model.ManagedAccountCreateRequestBody;
import com.mx.client.model.ManagedAccountUpdateRequestBody;
import com.mx.client.model.ManagedMemberCreateRequestBody;
import com.mx.client.model.ManagedMemberUpdateRequestBody;
import com.mx.client.model.ManagedTransactionCreateRequestBody;
import com.mx.client.model.ManagedTransactionUpdateRequestBody;
import com.mx.client.model.MemberResponseBody;
import com.mx.client.model.MembersResponseBody;
import com.mx.client.model.TransactionResponseBody;
import com.mx.client.model.TransactionsResponseBody;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class ManagedDataApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public ManagedDataApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ManagedDataApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createManagedAccountCall(String memberGuid, String userGuid, ManagedAccountCreateRequestBody managedAccountCreateRequestBody, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ManagedAccountCreateRequestBody localVarPostBody = managedAccountCreateRequestBody;
        String localVarPath = "/users/{user_guid}/managed_members/{member_guid}/accounts".replace("{member_guid}", this.localVarApiClient.escapeString(memberGuid.toString())).replace("{user_guid}", this.localVarApiClient.escapeString(userGuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.mx.api.v1+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createManagedAccountValidateBeforeCall(String memberGuid, String userGuid, ManagedAccountCreateRequestBody managedAccountCreateRequestBody, ApiCallback _callback) throws ApiException {
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling createManagedAccount(Async)");
        }
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling createManagedAccount(Async)");
        }
        if (managedAccountCreateRequestBody == null) {
            throw new ApiException("Missing the required parameter 'managedAccountCreateRequestBody' when calling createManagedAccount(Async)");
        }
        return this.createManagedAccountCall(memberGuid, userGuid, managedAccountCreateRequestBody, _callback);
    }

    public AccountResponseBody createManagedAccount(String memberGuid, String userGuid, ManagedAccountCreateRequestBody managedAccountCreateRequestBody) throws ApiException {
        ApiResponse<AccountResponseBody> localVarResp = this.createManagedAccountWithHttpInfo(memberGuid, userGuid, managedAccountCreateRequestBody);
        return localVarResp.getData();
    }

    public ApiResponse<AccountResponseBody> createManagedAccountWithHttpInfo(String memberGuid, String userGuid, ManagedAccountCreateRequestBody managedAccountCreateRequestBody) throws ApiException {
        Call localVarCall = this.createManagedAccountValidateBeforeCall(memberGuid, userGuid, managedAccountCreateRequestBody, null);
        Type localVarReturnType = new TypeToken<AccountResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createManagedAccountAsync(String memberGuid, String userGuid, ManagedAccountCreateRequestBody managedAccountCreateRequestBody, ApiCallback<AccountResponseBody> _callback) throws ApiException {
        Call localVarCall = this.createManagedAccountValidateBeforeCall(memberGuid, userGuid, managedAccountCreateRequestBody, _callback);
        Type localVarReturnType = new TypeToken<AccountResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call createManagedMemberCall(String userGuid, ManagedMemberCreateRequestBody managedMemberCreateRequestBody, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ManagedMemberCreateRequestBody localVarPostBody = managedMemberCreateRequestBody;
        String localVarPath = "/users/{user_guid}/managed_members".replace("{user_guid}", this.localVarApiClient.escapeString(userGuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.mx.api.v1+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createManagedMemberValidateBeforeCall(String userGuid, ManagedMemberCreateRequestBody managedMemberCreateRequestBody, ApiCallback _callback) throws ApiException {
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling createManagedMember(Async)");
        }
        if (managedMemberCreateRequestBody == null) {
            throw new ApiException("Missing the required parameter 'managedMemberCreateRequestBody' when calling createManagedMember(Async)");
        }
        return this.createManagedMemberCall(userGuid, managedMemberCreateRequestBody, _callback);
    }

    public MemberResponseBody createManagedMember(String userGuid, ManagedMemberCreateRequestBody managedMemberCreateRequestBody) throws ApiException {
        ApiResponse<MemberResponseBody> localVarResp = this.createManagedMemberWithHttpInfo(userGuid, managedMemberCreateRequestBody);
        return localVarResp.getData();
    }

    public ApiResponse<MemberResponseBody> createManagedMemberWithHttpInfo(String userGuid, ManagedMemberCreateRequestBody managedMemberCreateRequestBody) throws ApiException {
        Call localVarCall = this.createManagedMemberValidateBeforeCall(userGuid, managedMemberCreateRequestBody, null);
        Type localVarReturnType = new TypeToken<MemberResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createManagedMemberAsync(String userGuid, ManagedMemberCreateRequestBody managedMemberCreateRequestBody, ApiCallback<MemberResponseBody> _callback) throws ApiException {
        Call localVarCall = this.createManagedMemberValidateBeforeCall(userGuid, managedMemberCreateRequestBody, _callback);
        Type localVarReturnType = new TypeToken<MemberResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call createManagedTransactionCall(String accountGuid, String memberGuid, String userGuid, ManagedTransactionCreateRequestBody managedTransactionCreateRequestBody, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ManagedTransactionCreateRequestBody localVarPostBody = managedTransactionCreateRequestBody;
        String localVarPath = "/users/{user_guid}/managed_members/{member_guid}/accounts/{account_guid}/transactions".replace("{account_guid}", this.localVarApiClient.escapeString(accountGuid.toString())).replace("{member_guid}", this.localVarApiClient.escapeString(memberGuid.toString())).replace("{user_guid}", this.localVarApiClient.escapeString(userGuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.mx.api.v1+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createManagedTransactionValidateBeforeCall(String accountGuid, String memberGuid, String userGuid, ManagedTransactionCreateRequestBody managedTransactionCreateRequestBody, ApiCallback _callback) throws ApiException {
        if (accountGuid == null) {
            throw new ApiException("Missing the required parameter 'accountGuid' when calling createManagedTransaction(Async)");
        }
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling createManagedTransaction(Async)");
        }
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling createManagedTransaction(Async)");
        }
        if (managedTransactionCreateRequestBody == null) {
            throw new ApiException("Missing the required parameter 'managedTransactionCreateRequestBody' when calling createManagedTransaction(Async)");
        }
        return this.createManagedTransactionCall(accountGuid, memberGuid, userGuid, managedTransactionCreateRequestBody, _callback);
    }

    public TransactionResponseBody createManagedTransaction(String accountGuid, String memberGuid, String userGuid, ManagedTransactionCreateRequestBody managedTransactionCreateRequestBody) throws ApiException {
        ApiResponse<TransactionResponseBody> localVarResp = this.createManagedTransactionWithHttpInfo(accountGuid, memberGuid, userGuid, managedTransactionCreateRequestBody);
        return localVarResp.getData();
    }

    public ApiResponse<TransactionResponseBody> createManagedTransactionWithHttpInfo(String accountGuid, String memberGuid, String userGuid, ManagedTransactionCreateRequestBody managedTransactionCreateRequestBody) throws ApiException {
        Call localVarCall = this.createManagedTransactionValidateBeforeCall(accountGuid, memberGuid, userGuid, managedTransactionCreateRequestBody, null);
        Type localVarReturnType = new TypeToken<TransactionResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createManagedTransactionAsync(String accountGuid, String memberGuid, String userGuid, ManagedTransactionCreateRequestBody managedTransactionCreateRequestBody, ApiCallback<TransactionResponseBody> _callback) throws ApiException {
        Call localVarCall = this.createManagedTransactionValidateBeforeCall(accountGuid, memberGuid, userGuid, managedTransactionCreateRequestBody, _callback);
        Type localVarReturnType = new TypeToken<TransactionResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteManagedAccountCall(String accountGuid, String memberGuid, String userGuid, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/users/{user_guid}/managed_members/{member_guid}/accounts/{account_guid}".replace("{account_guid}", this.localVarApiClient.escapeString(accountGuid.toString())).replace("{member_guid}", this.localVarApiClient.escapeString(memberGuid.toString())).replace("{user_guid}", this.localVarApiClient.escapeString(userGuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteManagedAccountValidateBeforeCall(String accountGuid, String memberGuid, String userGuid, ApiCallback _callback) throws ApiException {
        if (accountGuid == null) {
            throw new ApiException("Missing the required parameter 'accountGuid' when calling deleteManagedAccount(Async)");
        }
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling deleteManagedAccount(Async)");
        }
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling deleteManagedAccount(Async)");
        }
        return this.deleteManagedAccountCall(accountGuid, memberGuid, userGuid, _callback);
    }

    public void deleteManagedAccount(String accountGuid, String memberGuid, String userGuid) throws ApiException {
        this.deleteManagedAccountWithHttpInfo(accountGuid, memberGuid, userGuid);
    }

    public ApiResponse<Void> deleteManagedAccountWithHttpInfo(String accountGuid, String memberGuid, String userGuid) throws ApiException {
        Call localVarCall = this.deleteManagedAccountValidateBeforeCall(accountGuid, memberGuid, userGuid, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteManagedAccountAsync(String accountGuid, String memberGuid, String userGuid, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteManagedAccountValidateBeforeCall(accountGuid, memberGuid, userGuid, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call deleteManagedMemberCall(String memberGuid, String accept, String userGuid, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/users/{user_guid}/managed_members/{member_guid}".replace("{member_guid}", this.localVarApiClient.escapeString(memberGuid.toString())).replace("{user_guid}", this.localVarApiClient.escapeString(userGuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (accept != null) {
            localVarHeaderParams.put("Accept", this.localVarApiClient.parameterToString(accept));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[0])) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteManagedMemberValidateBeforeCall(String memberGuid, String accept, String userGuid, ApiCallback _callback) throws ApiException {
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling deleteManagedMember(Async)");
        }
        if (accept == null) {
            throw new ApiException("Missing the required parameter 'accept' when calling deleteManagedMember(Async)");
        }
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling deleteManagedMember(Async)");
        }
        return this.deleteManagedMemberCall(memberGuid, accept, userGuid, _callback);
    }

    public void deleteManagedMember(String memberGuid, String accept, String userGuid) throws ApiException {
        this.deleteManagedMemberWithHttpInfo(memberGuid, accept, userGuid);
    }

    public ApiResponse<Void> deleteManagedMemberWithHttpInfo(String memberGuid, String accept, String userGuid) throws ApiException {
        Call localVarCall = this.deleteManagedMemberValidateBeforeCall(memberGuid, accept, userGuid, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteManagedMemberAsync(String memberGuid, String accept, String userGuid, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteManagedMemberValidateBeforeCall(memberGuid, accept, userGuid, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call deleteManagedTransactionCall(String accountGuid, String memberGuid, String transactionGuid, String userGuid, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/users/{user_guid}/managed_members/{member_guid}/accounts/{account_guid}/transactions/{transaction_guid}".replace("{account_guid}", this.localVarApiClient.escapeString(accountGuid.toString())).replace("{member_guid}", this.localVarApiClient.escapeString(memberGuid.toString())).replace("{transaction_guid}", this.localVarApiClient.escapeString(transactionGuid.toString())).replace("{user_guid}", this.localVarApiClient.escapeString(userGuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteManagedTransactionValidateBeforeCall(String accountGuid, String memberGuid, String transactionGuid, String userGuid, ApiCallback _callback) throws ApiException {
        if (accountGuid == null) {
            throw new ApiException("Missing the required parameter 'accountGuid' when calling deleteManagedTransaction(Async)");
        }
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling deleteManagedTransaction(Async)");
        }
        if (transactionGuid == null) {
            throw new ApiException("Missing the required parameter 'transactionGuid' when calling deleteManagedTransaction(Async)");
        }
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling deleteManagedTransaction(Async)");
        }
        return this.deleteManagedTransactionCall(accountGuid, memberGuid, transactionGuid, userGuid, _callback);
    }

    public void deleteManagedTransaction(String accountGuid, String memberGuid, String transactionGuid, String userGuid) throws ApiException {
        this.deleteManagedTransactionWithHttpInfo(accountGuid, memberGuid, transactionGuid, userGuid);
    }

    public ApiResponse<Void> deleteManagedTransactionWithHttpInfo(String accountGuid, String memberGuid, String transactionGuid, String userGuid) throws ApiException {
        Call localVarCall = this.deleteManagedTransactionValidateBeforeCall(accountGuid, memberGuid, transactionGuid, userGuid, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteManagedTransactionAsync(String accountGuid, String memberGuid, String transactionGuid, String userGuid, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteManagedTransactionValidateBeforeCall(accountGuid, memberGuid, transactionGuid, userGuid, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call listManagedAccountsCall(String memberGuid, String userGuid, Integer page, Integer recordsPerPage, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/users/{user_guid}/managed_members/{member_guid}/accounts".replace("{member_guid}", this.localVarApiClient.escapeString(memberGuid.toString())).replace("{user_guid}", this.localVarApiClient.escapeString(userGuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (recordsPerPage != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("records_per_page", recordsPerPage));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/vnd.mx.api.v1+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listManagedAccountsValidateBeforeCall(String memberGuid, String userGuid, Integer page, Integer recordsPerPage, ApiCallback _callback) throws ApiException {
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling listManagedAccounts(Async)");
        }
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling listManagedAccounts(Async)");
        }
        return this.listManagedAccountsCall(memberGuid, userGuid, page, recordsPerPage, _callback);
    }

    public AccountsResponseBody listManagedAccounts(String memberGuid, String userGuid, Integer page, Integer recordsPerPage) throws ApiException {
        ApiResponse<AccountsResponseBody> localVarResp = this.listManagedAccountsWithHttpInfo(memberGuid, userGuid, page, recordsPerPage);
        return localVarResp.getData();
    }

    public ApiResponse<AccountsResponseBody> listManagedAccountsWithHttpInfo(String memberGuid, String userGuid, Integer page, Integer recordsPerPage) throws ApiException {
        Call localVarCall = this.listManagedAccountsValidateBeforeCall(memberGuid, userGuid, page, recordsPerPage, null);
        Type localVarReturnType = new TypeToken<AccountsResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listManagedAccountsAsync(String memberGuid, String userGuid, Integer page, Integer recordsPerPage, ApiCallback<AccountsResponseBody> _callback) throws ApiException {
        Call localVarCall = this.listManagedAccountsValidateBeforeCall(memberGuid, userGuid, page, recordsPerPage, _callback);
        Type localVarReturnType = new TypeToken<AccountsResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listManagedInstitutionsCall(Integer page, Integer recordsPerPage, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/managed_institutions";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (recordsPerPage != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("records_per_page", recordsPerPage));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/vnd.mx.api.v1+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listManagedInstitutionsValidateBeforeCall(Integer page, Integer recordsPerPage, ApiCallback _callback) throws ApiException {
        return this.listManagedInstitutionsCall(page, recordsPerPage, _callback);
    }

    public InstitutionsResponseBody listManagedInstitutions(Integer page, Integer recordsPerPage) throws ApiException {
        ApiResponse<InstitutionsResponseBody> localVarResp = this.listManagedInstitutionsWithHttpInfo(page, recordsPerPage);
        return localVarResp.getData();
    }

    public ApiResponse<InstitutionsResponseBody> listManagedInstitutionsWithHttpInfo(Integer page, Integer recordsPerPage) throws ApiException {
        Call localVarCall = this.listManagedInstitutionsValidateBeforeCall(page, recordsPerPage, null);
        Type localVarReturnType = new TypeToken<InstitutionsResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listManagedInstitutionsAsync(Integer page, Integer recordsPerPage, ApiCallback<InstitutionsResponseBody> _callback) throws ApiException {
        Call localVarCall = this.listManagedInstitutionsValidateBeforeCall(page, recordsPerPage, _callback);
        Type localVarReturnType = new TypeToken<InstitutionsResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listManagedMembersCall(String userGuid, Integer page, Integer recordsPerPage, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/users/{user_guid}/managed_members".replace("{user_guid}", this.localVarApiClient.escapeString(userGuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (recordsPerPage != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("records_per_page", recordsPerPage));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/vnd.mx.api.v1+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listManagedMembersValidateBeforeCall(String userGuid, Integer page, Integer recordsPerPage, ApiCallback _callback) throws ApiException {
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling listManagedMembers(Async)");
        }
        return this.listManagedMembersCall(userGuid, page, recordsPerPage, _callback);
    }

    public MembersResponseBody listManagedMembers(String userGuid, Integer page, Integer recordsPerPage) throws ApiException {
        ApiResponse<MembersResponseBody> localVarResp = this.listManagedMembersWithHttpInfo(userGuid, page, recordsPerPage);
        return localVarResp.getData();
    }

    public ApiResponse<MembersResponseBody> listManagedMembersWithHttpInfo(String userGuid, Integer page, Integer recordsPerPage) throws ApiException {
        Call localVarCall = this.listManagedMembersValidateBeforeCall(userGuid, page, recordsPerPage, null);
        Type localVarReturnType = new TypeToken<MembersResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listManagedMembersAsync(String userGuid, Integer page, Integer recordsPerPage, ApiCallback<MembersResponseBody> _callback) throws ApiException {
        Call localVarCall = this.listManagedMembersValidateBeforeCall(userGuid, page, recordsPerPage, _callback);
        Type localVarReturnType = new TypeToken<MembersResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listManagedTransactionsCall(String accountGuid, String memberGuid, String userGuid, Integer page, String fromDate, String toDate, Integer recordsPerPage, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/users/{user_guid}/managed_members/{member_guid}/accounts/{account_guid}/transactions".replace("{account_guid}", this.localVarApiClient.escapeString(accountGuid.toString())).replace("{member_guid}", this.localVarApiClient.escapeString(memberGuid.toString())).replace("{user_guid}", this.localVarApiClient.escapeString(userGuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (fromDate != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("from_date", fromDate));
        }
        if (toDate != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("to_date", toDate));
        }
        if (recordsPerPage != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("records_per_page", recordsPerPage));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/vnd.mx.api.v1+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listManagedTransactionsValidateBeforeCall(String accountGuid, String memberGuid, String userGuid, Integer page, String fromDate, String toDate, Integer recordsPerPage, ApiCallback _callback) throws ApiException {
        if (accountGuid == null) {
            throw new ApiException("Missing the required parameter 'accountGuid' when calling listManagedTransactions(Async)");
        }
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling listManagedTransactions(Async)");
        }
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling listManagedTransactions(Async)");
        }
        return this.listManagedTransactionsCall(accountGuid, memberGuid, userGuid, page, fromDate, toDate, recordsPerPage, _callback);
    }

    public TransactionsResponseBody listManagedTransactions(String accountGuid, String memberGuid, String userGuid, Integer page, String fromDate, String toDate, Integer recordsPerPage) throws ApiException {
        ApiResponse<TransactionsResponseBody> localVarResp = this.listManagedTransactionsWithHttpInfo(accountGuid, memberGuid, userGuid, page, fromDate, toDate, recordsPerPage);
        return localVarResp.getData();
    }

    public ApiResponse<TransactionsResponseBody> listManagedTransactionsWithHttpInfo(String accountGuid, String memberGuid, String userGuid, Integer page, String fromDate, String toDate, Integer recordsPerPage) throws ApiException {
        Call localVarCall = this.listManagedTransactionsValidateBeforeCall(accountGuid, memberGuid, userGuid, page, fromDate, toDate, recordsPerPage, null);
        Type localVarReturnType = new TypeToken<TransactionsResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listManagedTransactionsAsync(String accountGuid, String memberGuid, String userGuid, Integer page, String fromDate, String toDate, Integer recordsPerPage, ApiCallback<TransactionsResponseBody> _callback) throws ApiException {
        Call localVarCall = this.listManagedTransactionsValidateBeforeCall(accountGuid, memberGuid, userGuid, page, fromDate, toDate, recordsPerPage, _callback);
        Type localVarReturnType = new TypeToken<TransactionsResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readManagedAccountCall(String accountGuid, String memberGuid, String userGuid, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/users/{user_guid}/managed_members/{member_guid}/accounts/{account_guid}".replace("{account_guid}", this.localVarApiClient.escapeString(accountGuid.toString())).replace("{member_guid}", this.localVarApiClient.escapeString(memberGuid.toString())).replace("{user_guid}", this.localVarApiClient.escapeString(userGuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.mx.api.v1+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readManagedAccountValidateBeforeCall(String accountGuid, String memberGuid, String userGuid, ApiCallback _callback) throws ApiException {
        if (accountGuid == null) {
            throw new ApiException("Missing the required parameter 'accountGuid' when calling readManagedAccount(Async)");
        }
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling readManagedAccount(Async)");
        }
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling readManagedAccount(Async)");
        }
        return this.readManagedAccountCall(accountGuid, memberGuid, userGuid, _callback);
    }

    public AccountResponseBody readManagedAccount(String accountGuid, String memberGuid, String userGuid) throws ApiException {
        ApiResponse<AccountResponseBody> localVarResp = this.readManagedAccountWithHttpInfo(accountGuid, memberGuid, userGuid);
        return localVarResp.getData();
    }

    public ApiResponse<AccountResponseBody> readManagedAccountWithHttpInfo(String accountGuid, String memberGuid, String userGuid) throws ApiException {
        Call localVarCall = this.readManagedAccountValidateBeforeCall(accountGuid, memberGuid, userGuid, null);
        Type localVarReturnType = new TypeToken<AccountResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readManagedAccountAsync(String accountGuid, String memberGuid, String userGuid, ApiCallback<AccountResponseBody> _callback) throws ApiException {
        Call localVarCall = this.readManagedAccountValidateBeforeCall(accountGuid, memberGuid, userGuid, _callback);
        Type localVarReturnType = new TypeToken<AccountResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readManagedMemberCall(String memberGuid, String userGuid, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/users/{user_guid}/managed_members/{member_guid}".replace("{member_guid}", this.localVarApiClient.escapeString(memberGuid.toString())).replace("{user_guid}", this.localVarApiClient.escapeString(userGuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.mx.api.v1+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readManagedMemberValidateBeforeCall(String memberGuid, String userGuid, ApiCallback _callback) throws ApiException {
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling readManagedMember(Async)");
        }
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling readManagedMember(Async)");
        }
        return this.readManagedMemberCall(memberGuid, userGuid, _callback);
    }

    public MemberResponseBody readManagedMember(String memberGuid, String userGuid) throws ApiException {
        ApiResponse<MemberResponseBody> localVarResp = this.readManagedMemberWithHttpInfo(memberGuid, userGuid);
        return localVarResp.getData();
    }

    public ApiResponse<MemberResponseBody> readManagedMemberWithHttpInfo(String memberGuid, String userGuid) throws ApiException {
        Call localVarCall = this.readManagedMemberValidateBeforeCall(memberGuid, userGuid, null);
        Type localVarReturnType = new TypeToken<MemberResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readManagedMemberAsync(String memberGuid, String userGuid, ApiCallback<MemberResponseBody> _callback) throws ApiException {
        Call localVarCall = this.readManagedMemberValidateBeforeCall(memberGuid, userGuid, _callback);
        Type localVarReturnType = new TypeToken<MemberResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readManagedTransactionCall(String accountGuid, String memberGuid, String transactionGuid, String userGuid, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/users/{user_guid}/managed_members/{member_guid}/accounts/{account_guid}/transactions/{transaction_guid}".replace("{account_guid}", this.localVarApiClient.escapeString(accountGuid.toString())).replace("{member_guid}", this.localVarApiClient.escapeString(memberGuid.toString())).replace("{transaction_guid}", this.localVarApiClient.escapeString(transactionGuid.toString())).replace("{user_guid}", this.localVarApiClient.escapeString(userGuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.mx.api.v1+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readManagedTransactionValidateBeforeCall(String accountGuid, String memberGuid, String transactionGuid, String userGuid, ApiCallback _callback) throws ApiException {
        if (accountGuid == null) {
            throw new ApiException("Missing the required parameter 'accountGuid' when calling readManagedTransaction(Async)");
        }
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling readManagedTransaction(Async)");
        }
        if (transactionGuid == null) {
            throw new ApiException("Missing the required parameter 'transactionGuid' when calling readManagedTransaction(Async)");
        }
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling readManagedTransaction(Async)");
        }
        return this.readManagedTransactionCall(accountGuid, memberGuid, transactionGuid, userGuid, _callback);
    }

    public TransactionResponseBody readManagedTransaction(String accountGuid, String memberGuid, String transactionGuid, String userGuid) throws ApiException {
        ApiResponse<TransactionResponseBody> localVarResp = this.readManagedTransactionWithHttpInfo(accountGuid, memberGuid, transactionGuid, userGuid);
        return localVarResp.getData();
    }

    public ApiResponse<TransactionResponseBody> readManagedTransactionWithHttpInfo(String accountGuid, String memberGuid, String transactionGuid, String userGuid) throws ApiException {
        Call localVarCall = this.readManagedTransactionValidateBeforeCall(accountGuid, memberGuid, transactionGuid, userGuid, null);
        Type localVarReturnType = new TypeToken<TransactionResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readManagedTransactionAsync(String accountGuid, String memberGuid, String transactionGuid, String userGuid, ApiCallback<TransactionResponseBody> _callback) throws ApiException {
        Call localVarCall = this.readManagedTransactionValidateBeforeCall(accountGuid, memberGuid, transactionGuid, userGuid, _callback);
        Type localVarReturnType = new TypeToken<TransactionResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateManagedAccountCall(String accountGuid, String memberGuid, String userGuid, ManagedAccountUpdateRequestBody managedAccountUpdateRequestBody, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ManagedAccountUpdateRequestBody localVarPostBody = managedAccountUpdateRequestBody;
        String localVarPath = "/users/{user_guid}/managed_members/{member_guid}/accounts/{account_guid}".replace("{account_guid}", this.localVarApiClient.escapeString(accountGuid.toString())).replace("{member_guid}", this.localVarApiClient.escapeString(memberGuid.toString())).replace("{user_guid}", this.localVarApiClient.escapeString(userGuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.mx.api.v1+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateManagedAccountValidateBeforeCall(String accountGuid, String memberGuid, String userGuid, ManagedAccountUpdateRequestBody managedAccountUpdateRequestBody, ApiCallback _callback) throws ApiException {
        if (accountGuid == null) {
            throw new ApiException("Missing the required parameter 'accountGuid' when calling updateManagedAccount(Async)");
        }
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling updateManagedAccount(Async)");
        }
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling updateManagedAccount(Async)");
        }
        if (managedAccountUpdateRequestBody == null) {
            throw new ApiException("Missing the required parameter 'managedAccountUpdateRequestBody' when calling updateManagedAccount(Async)");
        }
        return this.updateManagedAccountCall(accountGuid, memberGuid, userGuid, managedAccountUpdateRequestBody, _callback);
    }

    public AccountResponseBody updateManagedAccount(String accountGuid, String memberGuid, String userGuid, ManagedAccountUpdateRequestBody managedAccountUpdateRequestBody) throws ApiException {
        ApiResponse<AccountResponseBody> localVarResp = this.updateManagedAccountWithHttpInfo(accountGuid, memberGuid, userGuid, managedAccountUpdateRequestBody);
        return localVarResp.getData();
    }

    public ApiResponse<AccountResponseBody> updateManagedAccountWithHttpInfo(String accountGuid, String memberGuid, String userGuid, ManagedAccountUpdateRequestBody managedAccountUpdateRequestBody) throws ApiException {
        Call localVarCall = this.updateManagedAccountValidateBeforeCall(accountGuid, memberGuid, userGuid, managedAccountUpdateRequestBody, null);
        Type localVarReturnType = new TypeToken<AccountResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateManagedAccountAsync(String accountGuid, String memberGuid, String userGuid, ManagedAccountUpdateRequestBody managedAccountUpdateRequestBody, ApiCallback<AccountResponseBody> _callback) throws ApiException {
        Call localVarCall = this.updateManagedAccountValidateBeforeCall(accountGuid, memberGuid, userGuid, managedAccountUpdateRequestBody, _callback);
        Type localVarReturnType = new TypeToken<AccountResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateManagedMemberCall(String memberGuid, String userGuid, ManagedMemberUpdateRequestBody managedMemberUpdateRequestBody, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ManagedMemberUpdateRequestBody localVarPostBody = managedMemberUpdateRequestBody;
        String localVarPath = "/users/{user_guid}/managed_members/{member_guid}".replace("{member_guid}", this.localVarApiClient.escapeString(memberGuid.toString())).replace("{user_guid}", this.localVarApiClient.escapeString(userGuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.mx.api.v1+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateManagedMemberValidateBeforeCall(String memberGuid, String userGuid, ManagedMemberUpdateRequestBody managedMemberUpdateRequestBody, ApiCallback _callback) throws ApiException {
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling updateManagedMember(Async)");
        }
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling updateManagedMember(Async)");
        }
        if (managedMemberUpdateRequestBody == null) {
            throw new ApiException("Missing the required parameter 'managedMemberUpdateRequestBody' when calling updateManagedMember(Async)");
        }
        return this.updateManagedMemberCall(memberGuid, userGuid, managedMemberUpdateRequestBody, _callback);
    }

    public MemberResponseBody updateManagedMember(String memberGuid, String userGuid, ManagedMemberUpdateRequestBody managedMemberUpdateRequestBody) throws ApiException {
        ApiResponse<MemberResponseBody> localVarResp = this.updateManagedMemberWithHttpInfo(memberGuid, userGuid, managedMemberUpdateRequestBody);
        return localVarResp.getData();
    }

    public ApiResponse<MemberResponseBody> updateManagedMemberWithHttpInfo(String memberGuid, String userGuid, ManagedMemberUpdateRequestBody managedMemberUpdateRequestBody) throws ApiException {
        Call localVarCall = this.updateManagedMemberValidateBeforeCall(memberGuid, userGuid, managedMemberUpdateRequestBody, null);
        Type localVarReturnType = new TypeToken<MemberResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateManagedMemberAsync(String memberGuid, String userGuid, ManagedMemberUpdateRequestBody managedMemberUpdateRequestBody, ApiCallback<MemberResponseBody> _callback) throws ApiException {
        Call localVarCall = this.updateManagedMemberValidateBeforeCall(memberGuid, userGuid, managedMemberUpdateRequestBody, _callback);
        Type localVarReturnType = new TypeToken<MemberResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateManagedTransactionCall(String accountGuid, String memberGuid, String transactionGuid, String userGuid, ManagedTransactionUpdateRequestBody managedTransactionUpdateRequestBody, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ManagedTransactionUpdateRequestBody localVarPostBody = managedTransactionUpdateRequestBody;
        String localVarPath = "/users/{user_guid}/managed_members/{member_guid}/accounts/{account_guid}/transactions/{transaction_guid}".replace("{account_guid}", this.localVarApiClient.escapeString(accountGuid.toString())).replace("{member_guid}", this.localVarApiClient.escapeString(memberGuid.toString())).replace("{transaction_guid}", this.localVarApiClient.escapeString(transactionGuid.toString())).replace("{user_guid}", this.localVarApiClient.escapeString(userGuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.mx.api.v1+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateManagedTransactionValidateBeforeCall(String accountGuid, String memberGuid, String transactionGuid, String userGuid, ManagedTransactionUpdateRequestBody managedTransactionUpdateRequestBody, ApiCallback _callback) throws ApiException {
        if (accountGuid == null) {
            throw new ApiException("Missing the required parameter 'accountGuid' when calling updateManagedTransaction(Async)");
        }
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling updateManagedTransaction(Async)");
        }
        if (transactionGuid == null) {
            throw new ApiException("Missing the required parameter 'transactionGuid' when calling updateManagedTransaction(Async)");
        }
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling updateManagedTransaction(Async)");
        }
        if (managedTransactionUpdateRequestBody == null) {
            throw new ApiException("Missing the required parameter 'managedTransactionUpdateRequestBody' when calling updateManagedTransaction(Async)");
        }
        return this.updateManagedTransactionCall(accountGuid, memberGuid, transactionGuid, userGuid, managedTransactionUpdateRequestBody, _callback);
    }

    public TransactionResponseBody updateManagedTransaction(String accountGuid, String memberGuid, String transactionGuid, String userGuid, ManagedTransactionUpdateRequestBody managedTransactionUpdateRequestBody) throws ApiException {
        ApiResponse<TransactionResponseBody> localVarResp = this.updateManagedTransactionWithHttpInfo(accountGuid, memberGuid, transactionGuid, userGuid, managedTransactionUpdateRequestBody);
        return localVarResp.getData();
    }

    public ApiResponse<TransactionResponseBody> updateManagedTransactionWithHttpInfo(String accountGuid, String memberGuid, String transactionGuid, String userGuid, ManagedTransactionUpdateRequestBody managedTransactionUpdateRequestBody) throws ApiException {
        Call localVarCall = this.updateManagedTransactionValidateBeforeCall(accountGuid, memberGuid, transactionGuid, userGuid, managedTransactionUpdateRequestBody, null);
        Type localVarReturnType = new TypeToken<TransactionResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateManagedTransactionAsync(String accountGuid, String memberGuid, String transactionGuid, String userGuid, ManagedTransactionUpdateRequestBody managedTransactionUpdateRequestBody, ApiCallback<TransactionResponseBody> _callback) throws ApiException {
        Call localVarCall = this.updateManagedTransactionValidateBeforeCall(accountGuid, memberGuid, transactionGuid, userGuid, managedTransactionUpdateRequestBody, _callback);
        Type localVarReturnType = new TypeToken<TransactionResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

