/*
 * Decompiled with CFR 0.152.
 */
package com.mx.client.mx_platform_api;

import com.google.gson.reflect.TypeToken;
import com.mx.client.ApiCallback;
import com.mx.client.ApiClient;
import com.mx.client.ApiException;
import com.mx.client.ApiResponse;
import com.mx.client.Configuration;
import com.mx.client.Pair;
import com.mx.client.model.NotificationResponseBody;
import com.mx.client.model.NotificationsResponseBody;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class NotificationsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public NotificationsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public NotificationsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createNotificationCall(String userGuid, String content, String subject, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/users/{user_guid}/notifications".replace("{user_guid}", this.localVarApiClient.escapeString(userGuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (content != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("content", content));
        }
        if (subject != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("subject", subject));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createNotificationValidateBeforeCall(String userGuid, String content, String subject, ApiCallback _callback) throws ApiException {
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling createNotification(Async)");
        }
        if (content == null) {
            throw new ApiException("Missing the required parameter 'content' when calling createNotification(Async)");
        }
        if (subject == null) {
            throw new ApiException("Missing the required parameter 'subject' when calling createNotification(Async)");
        }
        return this.createNotificationCall(userGuid, content, subject, _callback);
    }

    public NotificationResponseBody createNotification(String userGuid, String content, String subject) throws ApiException {
        ApiResponse<NotificationResponseBody> localVarResp = this.createNotificationWithHttpInfo(userGuid, content, subject);
        return localVarResp.getData();
    }

    public ApiResponse<NotificationResponseBody> createNotificationWithHttpInfo(String userGuid, String content, String subject) throws ApiException {
        Call localVarCall = this.createNotificationValidateBeforeCall(userGuid, content, subject, null);
        Type localVarReturnType = new TypeToken<NotificationResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createNotificationAsync(String userGuid, String content, String subject, ApiCallback<NotificationResponseBody> _callback) throws ApiException {
        Call localVarCall = this.createNotificationValidateBeforeCall(userGuid, content, subject, _callback);
        Type localVarReturnType = new TypeToken<NotificationResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listNotificationsCall(String userGuid, String fromDate, String toDate, Integer page, Integer recordsPerPage, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/users/{user_guid}/notifications".replace("{user_guid}", this.localVarApiClient.escapeString(userGuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fromDate != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("from_date", fromDate));
        }
        if (toDate != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("to_date", toDate));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (recordsPerPage != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("records_per_page", recordsPerPage));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listNotificationsValidateBeforeCall(String userGuid, String fromDate, String toDate, Integer page, Integer recordsPerPage, ApiCallback _callback) throws ApiException {
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling listNotifications(Async)");
        }
        return this.listNotificationsCall(userGuid, fromDate, toDate, page, recordsPerPage, _callback);
    }

    public NotificationsResponseBody listNotifications(String userGuid, String fromDate, String toDate, Integer page, Integer recordsPerPage) throws ApiException {
        ApiResponse<NotificationsResponseBody> localVarResp = this.listNotificationsWithHttpInfo(userGuid, fromDate, toDate, page, recordsPerPage);
        return localVarResp.getData();
    }

    public ApiResponse<NotificationsResponseBody> listNotificationsWithHttpInfo(String userGuid, String fromDate, String toDate, Integer page, Integer recordsPerPage) throws ApiException {
        Call localVarCall = this.listNotificationsValidateBeforeCall(userGuid, fromDate, toDate, page, recordsPerPage, null);
        Type localVarReturnType = new TypeToken<NotificationsResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listNotificationsAsync(String userGuid, String fromDate, String toDate, Integer page, Integer recordsPerPage, ApiCallback<NotificationsResponseBody> _callback) throws ApiException {
        Call localVarCall = this.listNotificationsValidateBeforeCall(userGuid, fromDate, toDate, page, recordsPerPage, _callback);
        Type localVarReturnType = new TypeToken<NotificationsResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readNotificationsCall(String userGuid, String notificationGuid, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/users/{user_guid}/notifications/{notification_guid}".replace("{user_guid}", this.localVarApiClient.escapeString(userGuid.toString())).replace("{notification_guid}", this.localVarApiClient.escapeString(notificationGuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readNotificationsValidateBeforeCall(String userGuid, String notificationGuid, ApiCallback _callback) throws ApiException {
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling readNotifications(Async)");
        }
        if (notificationGuid == null) {
            throw new ApiException("Missing the required parameter 'notificationGuid' when calling readNotifications(Async)");
        }
        return this.readNotificationsCall(userGuid, notificationGuid, _callback);
    }

    public NotificationResponseBody readNotifications(String userGuid, String notificationGuid) throws ApiException {
        ApiResponse<NotificationResponseBody> localVarResp = this.readNotificationsWithHttpInfo(userGuid, notificationGuid);
        return localVarResp.getData();
    }

    public ApiResponse<NotificationResponseBody> readNotificationsWithHttpInfo(String userGuid, String notificationGuid) throws ApiException {
        Call localVarCall = this.readNotificationsValidateBeforeCall(userGuid, notificationGuid, null);
        Type localVarReturnType = new TypeToken<NotificationResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readNotificationsAsync(String userGuid, String notificationGuid, ApiCallback<NotificationResponseBody> _callback) throws ApiException {
        Call localVarCall = this.readNotificationsValidateBeforeCall(userGuid, notificationGuid, _callback);
        Type localVarReturnType = new TypeToken<NotificationResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

