/*
 * Decompiled with CFR 0.152.
 */
package com.mx.client.mx_platform_api;

import com.google.gson.reflect.TypeToken;
import com.mx.client.ApiCallback;
import com.mx.client.ApiClient;
import com.mx.client.ApiException;
import com.mx.client.ApiResponse;
import com.mx.client.Configuration;
import com.mx.client.Pair;
import com.mx.client.model.CredentialsResponseBody;
import com.mx.client.model.InstitutionResponseBody;
import com.mx.client.model.InstitutionsResponseBody;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;

public class InstitutionsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public InstitutionsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public InstitutionsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call listFavoriteInstitutionsCall(List<String> isoCountryCode, Integer page, Integer recordsPerPage, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/institutions/favorites";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (isoCountryCode != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "iso_country_code", isoCountryCode));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (recordsPerPage != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("records_per_page", recordsPerPage));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/vnd.mx.api.v1+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listFavoriteInstitutionsValidateBeforeCall(List<String> isoCountryCode, Integer page, Integer recordsPerPage, ApiCallback _callback) throws ApiException {
        return this.listFavoriteInstitutionsCall(isoCountryCode, page, recordsPerPage, _callback);
    }

    public InstitutionsResponseBody listFavoriteInstitutions(List<String> isoCountryCode, Integer page, Integer recordsPerPage) throws ApiException {
        ApiResponse<InstitutionsResponseBody> localVarResp = this.listFavoriteInstitutionsWithHttpInfo(isoCountryCode, page, recordsPerPage);
        return localVarResp.getData();
    }

    public ApiResponse<InstitutionsResponseBody> listFavoriteInstitutionsWithHttpInfo(List<String> isoCountryCode, Integer page, Integer recordsPerPage) throws ApiException {
        Call localVarCall = this.listFavoriteInstitutionsValidateBeforeCall(isoCountryCode, page, recordsPerPage, null);
        Type localVarReturnType = new TypeToken<InstitutionsResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listFavoriteInstitutionsAsync(List<String> isoCountryCode, Integer page, Integer recordsPerPage, ApiCallback<InstitutionsResponseBody> _callback) throws ApiException {
        Call localVarCall = this.listFavoriteInstitutionsValidateBeforeCall(isoCountryCode, page, recordsPerPage, _callback);
        Type localVarReturnType = new TypeToken<InstitutionsResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listInstitutionCredentialsCall(String institutionCode, Integer page, Integer recordsPerPage, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/institutions/{institution_code}/credentials".replace("{institution_code}", this.localVarApiClient.escapeString(institutionCode.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (recordsPerPage != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("records_per_page", recordsPerPage));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/vnd.mx.api.v1+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listInstitutionCredentialsValidateBeforeCall(String institutionCode, Integer page, Integer recordsPerPage, ApiCallback _callback) throws ApiException {
        if (institutionCode == null) {
            throw new ApiException("Missing the required parameter 'institutionCode' when calling listInstitutionCredentials(Async)");
        }
        return this.listInstitutionCredentialsCall(institutionCode, page, recordsPerPage, _callback);
    }

    public CredentialsResponseBody listInstitutionCredentials(String institutionCode, Integer page, Integer recordsPerPage) throws ApiException {
        ApiResponse<CredentialsResponseBody> localVarResp = this.listInstitutionCredentialsWithHttpInfo(institutionCode, page, recordsPerPage);
        return localVarResp.getData();
    }

    public ApiResponse<CredentialsResponseBody> listInstitutionCredentialsWithHttpInfo(String institutionCode, Integer page, Integer recordsPerPage) throws ApiException {
        Call localVarCall = this.listInstitutionCredentialsValidateBeforeCall(institutionCode, page, recordsPerPage, null);
        Type localVarReturnType = new TypeToken<CredentialsResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listInstitutionCredentialsAsync(String institutionCode, Integer page, Integer recordsPerPage, ApiCallback<CredentialsResponseBody> _callback) throws ApiException {
        Call localVarCall = this.listInstitutionCredentialsValidateBeforeCall(institutionCode, page, recordsPerPage, _callback);
        Type localVarReturnType = new TypeToken<CredentialsResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listInstitutionsCall(String name, List<String> isoCountryCode, Integer page, Integer recordsPerPage, Boolean supportsAccountIdentification, Boolean supportsAccountStatement, Boolean supportsAccountVerification, Boolean supportsTransactionHistory, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/institutions";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (name != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("name", name));
        }
        if (isoCountryCode != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "iso_country_code", isoCountryCode));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (recordsPerPage != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("records_per_page", recordsPerPage));
        }
        if (supportsAccountIdentification != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("supports_account_identification", supportsAccountIdentification));
        }
        if (supportsAccountStatement != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("supports_account_statement", supportsAccountStatement));
        }
        if (supportsAccountVerification != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("supports_account_verification", supportsAccountVerification));
        }
        if (supportsTransactionHistory != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("supports_transaction_history", supportsTransactionHistory));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/vnd.mx.api.v1+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listInstitutionsValidateBeforeCall(String name, List<String> isoCountryCode, Integer page, Integer recordsPerPage, Boolean supportsAccountIdentification, Boolean supportsAccountStatement, Boolean supportsAccountVerification, Boolean supportsTransactionHistory, ApiCallback _callback) throws ApiException {
        return this.listInstitutionsCall(name, isoCountryCode, page, recordsPerPage, supportsAccountIdentification, supportsAccountStatement, supportsAccountVerification, supportsTransactionHistory, _callback);
    }

    public InstitutionsResponseBody listInstitutions(String name, List<String> isoCountryCode, Integer page, Integer recordsPerPage, Boolean supportsAccountIdentification, Boolean supportsAccountStatement, Boolean supportsAccountVerification, Boolean supportsTransactionHistory) throws ApiException {
        ApiResponse<InstitutionsResponseBody> localVarResp = this.listInstitutionsWithHttpInfo(name, isoCountryCode, page, recordsPerPage, supportsAccountIdentification, supportsAccountStatement, supportsAccountVerification, supportsTransactionHistory);
        return localVarResp.getData();
    }

    public ApiResponse<InstitutionsResponseBody> listInstitutionsWithHttpInfo(String name, List<String> isoCountryCode, Integer page, Integer recordsPerPage, Boolean supportsAccountIdentification, Boolean supportsAccountStatement, Boolean supportsAccountVerification, Boolean supportsTransactionHistory) throws ApiException {
        Call localVarCall = this.listInstitutionsValidateBeforeCall(name, isoCountryCode, page, recordsPerPage, supportsAccountIdentification, supportsAccountStatement, supportsAccountVerification, supportsTransactionHistory, null);
        Type localVarReturnType = new TypeToken<InstitutionsResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listInstitutionsAsync(String name, List<String> isoCountryCode, Integer page, Integer recordsPerPage, Boolean supportsAccountIdentification, Boolean supportsAccountStatement, Boolean supportsAccountVerification, Boolean supportsTransactionHistory, ApiCallback<InstitutionsResponseBody> _callback) throws ApiException {
        Call localVarCall = this.listInstitutionsValidateBeforeCall(name, isoCountryCode, page, recordsPerPage, supportsAccountIdentification, supportsAccountStatement, supportsAccountVerification, supportsTransactionHistory, _callback);
        Type localVarReturnType = new TypeToken<InstitutionsResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readInstitutionCall(String institutionCode, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/institutions/{institution_code}".replace("{institution_code}", this.localVarApiClient.escapeString(institutionCode.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.mx.api.v1+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readInstitutionValidateBeforeCall(String institutionCode, ApiCallback _callback) throws ApiException {
        if (institutionCode == null) {
            throw new ApiException("Missing the required parameter 'institutionCode' when calling readInstitution(Async)");
        }
        return this.readInstitutionCall(institutionCode, _callback);
    }

    public InstitutionResponseBody readInstitution(String institutionCode) throws ApiException {
        ApiResponse<InstitutionResponseBody> localVarResp = this.readInstitutionWithHttpInfo(institutionCode);
        return localVarResp.getData();
    }

    public ApiResponse<InstitutionResponseBody> readInstitutionWithHttpInfo(String institutionCode) throws ApiException {
        Call localVarCall = this.readInstitutionValidateBeforeCall(institutionCode, null);
        Type localVarReturnType = new TypeToken<InstitutionResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readInstitutionAsync(String institutionCode, ApiCallback<InstitutionResponseBody> _callback) throws ApiException {
        Call localVarCall = this.readInstitutionValidateBeforeCall(institutionCode, _callback);
        Type localVarReturnType = new TypeToken<InstitutionResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

