/*
 * Decompiled with CFR 0.152.
 */
package com.mx.client.mx_platform_api;

import com.google.gson.reflect.TypeToken;
import com.mx.client.ApiCallback;
import com.mx.client.ApiClient;
import com.mx.client.ApiException;
import com.mx.client.ApiResponse;
import com.mx.client.Configuration;
import com.mx.client.Pair;
import com.mx.client.model.ChallengesResponseBody;
import com.mx.client.model.CredentialsResponseBody;
import com.mx.client.model.MemberCreateRequestBody;
import com.mx.client.model.MemberResponseBody;
import com.mx.client.model.MemberResumeRequestBody;
import com.mx.client.model.MemberStatusResponseBody;
import com.mx.client.model.MemberUpdateRequestBody;
import com.mx.client.model.MembersResponseBody;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class MembersApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public MembersApi() {
        this(Configuration.getDefaultApiClient());
    }

    public MembersApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call aggregateMemberCall(String memberGuid, String userGuid, String X_CALLBACK_PAYLOAD, Boolean includeHoldings, Boolean includeTransactions, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/users/{user_guid}/members/{member_guid}/aggregate".replace("{member_guid}", this.localVarApiClient.escapeString(memberGuid.toString())).replace("{user_guid}", this.localVarApiClient.escapeString(userGuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (includeHoldings != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("include_holdings", includeHoldings));
        }
        if (includeTransactions != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("include_transactions", includeTransactions));
        }
        if (X_CALLBACK_PAYLOAD != null) {
            localVarHeaderParams.put("X-CALLBACK-PAYLOAD", this.localVarApiClient.parameterToString(X_CALLBACK_PAYLOAD));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/vnd.mx.api.v1+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call aggregateMemberValidateBeforeCall(String memberGuid, String userGuid, String X_CALLBACK_PAYLOAD, Boolean includeHoldings, Boolean includeTransactions, ApiCallback _callback) throws ApiException {
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling aggregateMember(Async)");
        }
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling aggregateMember(Async)");
        }
        return this.aggregateMemberCall(memberGuid, userGuid, X_CALLBACK_PAYLOAD, includeHoldings, includeTransactions, _callback);
    }

    public MemberResponseBody aggregateMember(String memberGuid, String userGuid, String X_CALLBACK_PAYLOAD, Boolean includeHoldings, Boolean includeTransactions) throws ApiException {
        ApiResponse<MemberResponseBody> localVarResp = this.aggregateMemberWithHttpInfo(memberGuid, userGuid, X_CALLBACK_PAYLOAD, includeHoldings, includeTransactions);
        return localVarResp.getData();
    }

    public ApiResponse<MemberResponseBody> aggregateMemberWithHttpInfo(String memberGuid, String userGuid, String X_CALLBACK_PAYLOAD, Boolean includeHoldings, Boolean includeTransactions) throws ApiException {
        Call localVarCall = this.aggregateMemberValidateBeforeCall(memberGuid, userGuid, X_CALLBACK_PAYLOAD, includeHoldings, includeTransactions, null);
        Type localVarReturnType = new TypeToken<MemberResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call aggregateMemberAsync(String memberGuid, String userGuid, String X_CALLBACK_PAYLOAD, Boolean includeHoldings, Boolean includeTransactions, ApiCallback<MemberResponseBody> _callback) throws ApiException {
        Call localVarCall = this.aggregateMemberValidateBeforeCall(memberGuid, userGuid, X_CALLBACK_PAYLOAD, includeHoldings, includeTransactions, _callback);
        Type localVarReturnType = new TypeToken<MemberResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call checkBalancesCall(String memberGuid, String userGuid, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/users/{user_guid}/members/{member_guid}/check_balance".replace("{member_guid}", this.localVarApiClient.escapeString(memberGuid.toString())).replace("{user_guid}", this.localVarApiClient.escapeString(userGuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.mx.api.v1+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call checkBalancesValidateBeforeCall(String memberGuid, String userGuid, ApiCallback _callback) throws ApiException {
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling checkBalances(Async)");
        }
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling checkBalances(Async)");
        }
        return this.checkBalancesCall(memberGuid, userGuid, _callback);
    }

    public MemberResponseBody checkBalances(String memberGuid, String userGuid) throws ApiException {
        ApiResponse<MemberResponseBody> localVarResp = this.checkBalancesWithHttpInfo(memberGuid, userGuid);
        return localVarResp.getData();
    }

    public ApiResponse<MemberResponseBody> checkBalancesWithHttpInfo(String memberGuid, String userGuid) throws ApiException {
        Call localVarCall = this.checkBalancesValidateBeforeCall(memberGuid, userGuid, null);
        Type localVarReturnType = new TypeToken<MemberResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call checkBalancesAsync(String memberGuid, String userGuid, ApiCallback<MemberResponseBody> _callback) throws ApiException {
        Call localVarCall = this.checkBalancesValidateBeforeCall(memberGuid, userGuid, _callback);
        Type localVarReturnType = new TypeToken<MemberResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call createMemberCall(String userGuid, MemberCreateRequestBody memberCreateRequestBody, String X_CALLBACK_PAYLOAD, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        MemberCreateRequestBody localVarPostBody = memberCreateRequestBody;
        String localVarPath = "/users/{user_guid}/members".replace("{user_guid}", this.localVarApiClient.escapeString(userGuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (X_CALLBACK_PAYLOAD != null) {
            localVarHeaderParams.put("X-CALLBACK-PAYLOAD", this.localVarApiClient.parameterToString(X_CALLBACK_PAYLOAD));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/vnd.mx.api.v1+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createMemberValidateBeforeCall(String userGuid, MemberCreateRequestBody memberCreateRequestBody, String X_CALLBACK_PAYLOAD, ApiCallback _callback) throws ApiException {
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling createMember(Async)");
        }
        if (memberCreateRequestBody == null) {
            throw new ApiException("Missing the required parameter 'memberCreateRequestBody' when calling createMember(Async)");
        }
        return this.createMemberCall(userGuid, memberCreateRequestBody, X_CALLBACK_PAYLOAD, _callback);
    }

    public MemberResponseBody createMember(String userGuid, MemberCreateRequestBody memberCreateRequestBody, String X_CALLBACK_PAYLOAD) throws ApiException {
        ApiResponse<MemberResponseBody> localVarResp = this.createMemberWithHttpInfo(userGuid, memberCreateRequestBody, X_CALLBACK_PAYLOAD);
        return localVarResp.getData();
    }

    public ApiResponse<MemberResponseBody> createMemberWithHttpInfo(String userGuid, MemberCreateRequestBody memberCreateRequestBody, String X_CALLBACK_PAYLOAD) throws ApiException {
        Call localVarCall = this.createMemberValidateBeforeCall(userGuid, memberCreateRequestBody, X_CALLBACK_PAYLOAD, null);
        Type localVarReturnType = new TypeToken<MemberResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createMemberAsync(String userGuid, MemberCreateRequestBody memberCreateRequestBody, String X_CALLBACK_PAYLOAD, ApiCallback<MemberResponseBody> _callback) throws ApiException {
        Call localVarCall = this.createMemberValidateBeforeCall(userGuid, memberCreateRequestBody, X_CALLBACK_PAYLOAD, _callback);
        Type localVarReturnType = new TypeToken<MemberResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteMemberCall(String memberGuid, String userGuid, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/users/{user_guid}/members/{member_guid}".replace("{member_guid}", this.localVarApiClient.escapeString(memberGuid.toString())).replace("{user_guid}", this.localVarApiClient.escapeString(userGuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteMemberValidateBeforeCall(String memberGuid, String userGuid, ApiCallback _callback) throws ApiException {
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling deleteMember(Async)");
        }
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling deleteMember(Async)");
        }
        return this.deleteMemberCall(memberGuid, userGuid, _callback);
    }

    public void deleteMember(String memberGuid, String userGuid) throws ApiException {
        this.deleteMemberWithHttpInfo(memberGuid, userGuid);
    }

    public ApiResponse<Void> deleteMemberWithHttpInfo(String memberGuid, String userGuid) throws ApiException {
        Call localVarCall = this.deleteMemberValidateBeforeCall(memberGuid, userGuid, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteMemberAsync(String memberGuid, String userGuid, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteMemberValidateBeforeCall(memberGuid, userGuid, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call identifyMemberCall(String memberGuid, String userGuid, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/users/{user_guid}/members/{member_guid}/identify".replace("{member_guid}", this.localVarApiClient.escapeString(memberGuid.toString())).replace("{user_guid}", this.localVarApiClient.escapeString(userGuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.mx.api.v1+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call identifyMemberValidateBeforeCall(String memberGuid, String userGuid, ApiCallback _callback) throws ApiException {
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling identifyMember(Async)");
        }
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling identifyMember(Async)");
        }
        return this.identifyMemberCall(memberGuid, userGuid, _callback);
    }

    public MemberResponseBody identifyMember(String memberGuid, String userGuid) throws ApiException {
        ApiResponse<MemberResponseBody> localVarResp = this.identifyMemberWithHttpInfo(memberGuid, userGuid);
        return localVarResp.getData();
    }

    public ApiResponse<MemberResponseBody> identifyMemberWithHttpInfo(String memberGuid, String userGuid) throws ApiException {
        Call localVarCall = this.identifyMemberValidateBeforeCall(memberGuid, userGuid, null);
        Type localVarReturnType = new TypeToken<MemberResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call identifyMemberAsync(String memberGuid, String userGuid, ApiCallback<MemberResponseBody> _callback) throws ApiException {
        Call localVarCall = this.identifyMemberValidateBeforeCall(memberGuid, userGuid, _callback);
        Type localVarReturnType = new TypeToken<MemberResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listMemberChallengesCall(String memberGuid, String userGuid, Integer page, Integer recordsPerPage, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/users/{user_guid}/members/{member_guid}/challenges".replace("{member_guid}", this.localVarApiClient.escapeString(memberGuid.toString())).replace("{user_guid}", this.localVarApiClient.escapeString(userGuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (recordsPerPage != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("records_per_page", recordsPerPage));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/vnd.mx.api.v1+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listMemberChallengesValidateBeforeCall(String memberGuid, String userGuid, Integer page, Integer recordsPerPage, ApiCallback _callback) throws ApiException {
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling listMemberChallenges(Async)");
        }
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling listMemberChallenges(Async)");
        }
        return this.listMemberChallengesCall(memberGuid, userGuid, page, recordsPerPage, _callback);
    }

    public ChallengesResponseBody listMemberChallenges(String memberGuid, String userGuid, Integer page, Integer recordsPerPage) throws ApiException {
        ApiResponse<ChallengesResponseBody> localVarResp = this.listMemberChallengesWithHttpInfo(memberGuid, userGuid, page, recordsPerPage);
        return localVarResp.getData();
    }

    public ApiResponse<ChallengesResponseBody> listMemberChallengesWithHttpInfo(String memberGuid, String userGuid, Integer page, Integer recordsPerPage) throws ApiException {
        Call localVarCall = this.listMemberChallengesValidateBeforeCall(memberGuid, userGuid, page, recordsPerPage, null);
        Type localVarReturnType = new TypeToken<ChallengesResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listMemberChallengesAsync(String memberGuid, String userGuid, Integer page, Integer recordsPerPage, ApiCallback<ChallengesResponseBody> _callback) throws ApiException {
        Call localVarCall = this.listMemberChallengesValidateBeforeCall(memberGuid, userGuid, page, recordsPerPage, _callback);
        Type localVarReturnType = new TypeToken<ChallengesResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listMemberCredentialsCall(String memberGuid, String userGuid, Integer page, Integer recordsPerPage, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/users/{user_guid}/members/{member_guid}/credentials".replace("{member_guid}", this.localVarApiClient.escapeString(memberGuid.toString())).replace("{user_guid}", this.localVarApiClient.escapeString(userGuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (recordsPerPage != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("records_per_page", recordsPerPage));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/vnd.mx.api.v1+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listMemberCredentialsValidateBeforeCall(String memberGuid, String userGuid, Integer page, Integer recordsPerPage, ApiCallback _callback) throws ApiException {
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling listMemberCredentials(Async)");
        }
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling listMemberCredentials(Async)");
        }
        return this.listMemberCredentialsCall(memberGuid, userGuid, page, recordsPerPage, _callback);
    }

    public CredentialsResponseBody listMemberCredentials(String memberGuid, String userGuid, Integer page, Integer recordsPerPage) throws ApiException {
        ApiResponse<CredentialsResponseBody> localVarResp = this.listMemberCredentialsWithHttpInfo(memberGuid, userGuid, page, recordsPerPage);
        return localVarResp.getData();
    }

    public ApiResponse<CredentialsResponseBody> listMemberCredentialsWithHttpInfo(String memberGuid, String userGuid, Integer page, Integer recordsPerPage) throws ApiException {
        Call localVarCall = this.listMemberCredentialsValidateBeforeCall(memberGuid, userGuid, page, recordsPerPage, null);
        Type localVarReturnType = new TypeToken<CredentialsResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listMemberCredentialsAsync(String memberGuid, String userGuid, Integer page, Integer recordsPerPage, ApiCallback<CredentialsResponseBody> _callback) throws ApiException {
        Call localVarCall = this.listMemberCredentialsValidateBeforeCall(memberGuid, userGuid, page, recordsPerPage, _callback);
        Type localVarReturnType = new TypeToken<CredentialsResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listMembersCall(String userGuid, Integer page, Integer recordsPerPage, String useCase, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/users/{user_guid}/members".replace("{user_guid}", this.localVarApiClient.escapeString(userGuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (recordsPerPage != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("records_per_page", recordsPerPage));
        }
        if (useCase != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("use_case", useCase));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/vnd.mx.api.v1+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listMembersValidateBeforeCall(String userGuid, Integer page, Integer recordsPerPage, String useCase, ApiCallback _callback) throws ApiException {
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling listMembers(Async)");
        }
        return this.listMembersCall(userGuid, page, recordsPerPage, useCase, _callback);
    }

    public MembersResponseBody listMembers(String userGuid, Integer page, Integer recordsPerPage, String useCase) throws ApiException {
        ApiResponse<MembersResponseBody> localVarResp = this.listMembersWithHttpInfo(userGuid, page, recordsPerPage, useCase);
        return localVarResp.getData();
    }

    public ApiResponse<MembersResponseBody> listMembersWithHttpInfo(String userGuid, Integer page, Integer recordsPerPage, String useCase) throws ApiException {
        Call localVarCall = this.listMembersValidateBeforeCall(userGuid, page, recordsPerPage, useCase, null);
        Type localVarReturnType = new TypeToken<MembersResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listMembersAsync(String userGuid, Integer page, Integer recordsPerPage, String useCase, ApiCallback<MembersResponseBody> _callback) throws ApiException {
        Call localVarCall = this.listMembersValidateBeforeCall(userGuid, page, recordsPerPage, useCase, _callback);
        Type localVarReturnType = new TypeToken<MembersResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readMemberCall(String memberGuid, String userGuid, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/users/{user_guid}/members/{member_guid}".replace("{member_guid}", this.localVarApiClient.escapeString(memberGuid.toString())).replace("{user_guid}", this.localVarApiClient.escapeString(userGuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.mx.api.v1+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readMemberValidateBeforeCall(String memberGuid, String userGuid, ApiCallback _callback) throws ApiException {
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling readMember(Async)");
        }
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling readMember(Async)");
        }
        return this.readMemberCall(memberGuid, userGuid, _callback);
    }

    public MemberResponseBody readMember(String memberGuid, String userGuid) throws ApiException {
        ApiResponse<MemberResponseBody> localVarResp = this.readMemberWithHttpInfo(memberGuid, userGuid);
        return localVarResp.getData();
    }

    public ApiResponse<MemberResponseBody> readMemberWithHttpInfo(String memberGuid, String userGuid) throws ApiException {
        Call localVarCall = this.readMemberValidateBeforeCall(memberGuid, userGuid, null);
        Type localVarReturnType = new TypeToken<MemberResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readMemberAsync(String memberGuid, String userGuid, ApiCallback<MemberResponseBody> _callback) throws ApiException {
        Call localVarCall = this.readMemberValidateBeforeCall(memberGuid, userGuid, _callback);
        Type localVarReturnType = new TypeToken<MemberResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readMemberStatusCall(String memberGuid, String userGuid, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/users/{user_guid}/members/{member_guid}/status".replace("{member_guid}", this.localVarApiClient.escapeString(memberGuid.toString())).replace("{user_guid}", this.localVarApiClient.escapeString(userGuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.mx.api.v1+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readMemberStatusValidateBeforeCall(String memberGuid, String userGuid, ApiCallback _callback) throws ApiException {
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling readMemberStatus(Async)");
        }
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling readMemberStatus(Async)");
        }
        return this.readMemberStatusCall(memberGuid, userGuid, _callback);
    }

    public MemberStatusResponseBody readMemberStatus(String memberGuid, String userGuid) throws ApiException {
        ApiResponse<MemberStatusResponseBody> localVarResp = this.readMemberStatusWithHttpInfo(memberGuid, userGuid);
        return localVarResp.getData();
    }

    public ApiResponse<MemberStatusResponseBody> readMemberStatusWithHttpInfo(String memberGuid, String userGuid) throws ApiException {
        Call localVarCall = this.readMemberStatusValidateBeforeCall(memberGuid, userGuid, null);
        Type localVarReturnType = new TypeToken<MemberStatusResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readMemberStatusAsync(String memberGuid, String userGuid, ApiCallback<MemberStatusResponseBody> _callback) throws ApiException {
        Call localVarCall = this.readMemberStatusValidateBeforeCall(memberGuid, userGuid, _callback);
        Type localVarReturnType = new TypeToken<MemberStatusResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call resumeAggregationCall(String memberGuid, String userGuid, MemberResumeRequestBody memberResumeRequestBody, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        MemberResumeRequestBody localVarPostBody = memberResumeRequestBody;
        String localVarPath = "/users/{user_guid}/members/{member_guid}/resume".replace("{member_guid}", this.localVarApiClient.escapeString(memberGuid.toString())).replace("{user_guid}", this.localVarApiClient.escapeString(userGuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.mx.api.v1+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call resumeAggregationValidateBeforeCall(String memberGuid, String userGuid, MemberResumeRequestBody memberResumeRequestBody, ApiCallback _callback) throws ApiException {
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling resumeAggregation(Async)");
        }
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling resumeAggregation(Async)");
        }
        if (memberResumeRequestBody == null) {
            throw new ApiException("Missing the required parameter 'memberResumeRequestBody' when calling resumeAggregation(Async)");
        }
        return this.resumeAggregationCall(memberGuid, userGuid, memberResumeRequestBody, _callback);
    }

    public MemberResponseBody resumeAggregation(String memberGuid, String userGuid, MemberResumeRequestBody memberResumeRequestBody) throws ApiException {
        ApiResponse<MemberResponseBody> localVarResp = this.resumeAggregationWithHttpInfo(memberGuid, userGuid, memberResumeRequestBody);
        return localVarResp.getData();
    }

    public ApiResponse<MemberResponseBody> resumeAggregationWithHttpInfo(String memberGuid, String userGuid, MemberResumeRequestBody memberResumeRequestBody) throws ApiException {
        Call localVarCall = this.resumeAggregationValidateBeforeCall(memberGuid, userGuid, memberResumeRequestBody, null);
        Type localVarReturnType = new TypeToken<MemberResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call resumeAggregationAsync(String memberGuid, String userGuid, MemberResumeRequestBody memberResumeRequestBody, ApiCallback<MemberResponseBody> _callback) throws ApiException {
        Call localVarCall = this.resumeAggregationValidateBeforeCall(memberGuid, userGuid, memberResumeRequestBody, _callback);
        Type localVarReturnType = new TypeToken<MemberResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateMemberCall(String memberGuid, String userGuid, MemberUpdateRequestBody memberUpdateRequestBody, String X_CALLBACK_PAYLOAD, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        MemberUpdateRequestBody localVarPostBody = memberUpdateRequestBody;
        String localVarPath = "/users/{user_guid}/members/{member_guid}".replace("{member_guid}", this.localVarApiClient.escapeString(memberGuid.toString())).replace("{user_guid}", this.localVarApiClient.escapeString(userGuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (X_CALLBACK_PAYLOAD != null) {
            localVarHeaderParams.put("X-CALLBACK-PAYLOAD", this.localVarApiClient.parameterToString(X_CALLBACK_PAYLOAD));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/vnd.mx.api.v1+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateMemberValidateBeforeCall(String memberGuid, String userGuid, MemberUpdateRequestBody memberUpdateRequestBody, String X_CALLBACK_PAYLOAD, ApiCallback _callback) throws ApiException {
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling updateMember(Async)");
        }
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling updateMember(Async)");
        }
        if (memberUpdateRequestBody == null) {
            throw new ApiException("Missing the required parameter 'memberUpdateRequestBody' when calling updateMember(Async)");
        }
        return this.updateMemberCall(memberGuid, userGuid, memberUpdateRequestBody, X_CALLBACK_PAYLOAD, _callback);
    }

    public MemberResponseBody updateMember(String memberGuid, String userGuid, MemberUpdateRequestBody memberUpdateRequestBody, String X_CALLBACK_PAYLOAD) throws ApiException {
        ApiResponse<MemberResponseBody> localVarResp = this.updateMemberWithHttpInfo(memberGuid, userGuid, memberUpdateRequestBody, X_CALLBACK_PAYLOAD);
        return localVarResp.getData();
    }

    public ApiResponse<MemberResponseBody> updateMemberWithHttpInfo(String memberGuid, String userGuid, MemberUpdateRequestBody memberUpdateRequestBody, String X_CALLBACK_PAYLOAD) throws ApiException {
        Call localVarCall = this.updateMemberValidateBeforeCall(memberGuid, userGuid, memberUpdateRequestBody, X_CALLBACK_PAYLOAD, null);
        Type localVarReturnType = new TypeToken<MemberResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateMemberAsync(String memberGuid, String userGuid, MemberUpdateRequestBody memberUpdateRequestBody, String X_CALLBACK_PAYLOAD, ApiCallback<MemberResponseBody> _callback) throws ApiException {
        Call localVarCall = this.updateMemberValidateBeforeCall(memberGuid, userGuid, memberUpdateRequestBody, X_CALLBACK_PAYLOAD, _callback);
        Type localVarReturnType = new TypeToken<MemberResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call verifyMemberCall(String memberGuid, String userGuid, String X_CALLBACK_PAYLOAD, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/users/{user_guid}/members/{member_guid}/verify".replace("{member_guid}", this.localVarApiClient.escapeString(memberGuid.toString())).replace("{user_guid}", this.localVarApiClient.escapeString(userGuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (X_CALLBACK_PAYLOAD != null) {
            localVarHeaderParams.put("X-CALLBACK-PAYLOAD", this.localVarApiClient.parameterToString(X_CALLBACK_PAYLOAD));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/vnd.mx.api.v1+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call verifyMemberValidateBeforeCall(String memberGuid, String userGuid, String X_CALLBACK_PAYLOAD, ApiCallback _callback) throws ApiException {
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling verifyMember(Async)");
        }
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling verifyMember(Async)");
        }
        return this.verifyMemberCall(memberGuid, userGuid, X_CALLBACK_PAYLOAD, _callback);
    }

    public MemberResponseBody verifyMember(String memberGuid, String userGuid, String X_CALLBACK_PAYLOAD) throws ApiException {
        ApiResponse<MemberResponseBody> localVarResp = this.verifyMemberWithHttpInfo(memberGuid, userGuid, X_CALLBACK_PAYLOAD);
        return localVarResp.getData();
    }

    public ApiResponse<MemberResponseBody> verifyMemberWithHttpInfo(String memberGuid, String userGuid, String X_CALLBACK_PAYLOAD) throws ApiException {
        Call localVarCall = this.verifyMemberValidateBeforeCall(memberGuid, userGuid, X_CALLBACK_PAYLOAD, null);
        Type localVarReturnType = new TypeToken<MemberResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call verifyMemberAsync(String memberGuid, String userGuid, String X_CALLBACK_PAYLOAD, ApiCallback<MemberResponseBody> _callback) throws ApiException {
        Call localVarCall = this.verifyMemberValidateBeforeCall(memberGuid, userGuid, X_CALLBACK_PAYLOAD, _callback);
        Type localVarReturnType = new TypeToken<MemberResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

