/*
 * Decompiled with CFR 0.152.
 */
package com.mx.client.mx_platform_api;

import com.google.gson.reflect.TypeToken;
import com.mx.client.ApiCallback;
import com.mx.client.ApiClient;
import com.mx.client.ApiException;
import com.mx.client.ApiResponse;
import com.mx.client.Configuration;
import com.mx.client.Pair;
import com.mx.client.model.MerchantLocationResponseBody;
import com.mx.client.model.MerchantResponseBody;
import com.mx.client.model.MerchantsResponseBody;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class MerchantsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public MerchantsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public MerchantsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call listMerchantsCall(String name, Integer page, Integer recordsPerPage, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/merchants";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (name != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("name", name));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (recordsPerPage != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("records_per_page", recordsPerPage));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/vnd.mx.api.v1+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listMerchantsValidateBeforeCall(String name, Integer page, Integer recordsPerPage, ApiCallback _callback) throws ApiException {
        return this.listMerchantsCall(name, page, recordsPerPage, _callback);
    }

    public MerchantsResponseBody listMerchants(String name, Integer page, Integer recordsPerPage) throws ApiException {
        ApiResponse<MerchantsResponseBody> localVarResp = this.listMerchantsWithHttpInfo(name, page, recordsPerPage);
        return localVarResp.getData();
    }

    public ApiResponse<MerchantsResponseBody> listMerchantsWithHttpInfo(String name, Integer page, Integer recordsPerPage) throws ApiException {
        Call localVarCall = this.listMerchantsValidateBeforeCall(name, page, recordsPerPage, null);
        Type localVarReturnType = new TypeToken<MerchantsResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listMerchantsAsync(String name, Integer page, Integer recordsPerPage, ApiCallback<MerchantsResponseBody> _callback) throws ApiException {
        Call localVarCall = this.listMerchantsValidateBeforeCall(name, page, recordsPerPage, _callback);
        Type localVarReturnType = new TypeToken<MerchantsResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readMerchantCall(String merchantGuid, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/merchants/{merchant_guid}".replace("{merchant_guid}", this.localVarApiClient.escapeString(merchantGuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.mx.api.v1+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readMerchantValidateBeforeCall(String merchantGuid, ApiCallback _callback) throws ApiException {
        if (merchantGuid == null) {
            throw new ApiException("Missing the required parameter 'merchantGuid' when calling readMerchant(Async)");
        }
        return this.readMerchantCall(merchantGuid, _callback);
    }

    public MerchantResponseBody readMerchant(String merchantGuid) throws ApiException {
        ApiResponse<MerchantResponseBody> localVarResp = this.readMerchantWithHttpInfo(merchantGuid);
        return localVarResp.getData();
    }

    public ApiResponse<MerchantResponseBody> readMerchantWithHttpInfo(String merchantGuid) throws ApiException {
        Call localVarCall = this.readMerchantValidateBeforeCall(merchantGuid, null);
        Type localVarReturnType = new TypeToken<MerchantResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readMerchantAsync(String merchantGuid, ApiCallback<MerchantResponseBody> _callback) throws ApiException {
        Call localVarCall = this.readMerchantValidateBeforeCall(merchantGuid, _callback);
        Type localVarReturnType = new TypeToken<MerchantResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readMerchantLocationCall(String merchantLocationGuid, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/merchant_locations/{merchant_location_guid}".replace("{merchant_location_guid}", this.localVarApiClient.escapeString(merchantLocationGuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.mx.api.v1+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readMerchantLocationValidateBeforeCall(String merchantLocationGuid, ApiCallback _callback) throws ApiException {
        if (merchantLocationGuid == null) {
            throw new ApiException("Missing the required parameter 'merchantLocationGuid' when calling readMerchantLocation(Async)");
        }
        return this.readMerchantLocationCall(merchantLocationGuid, _callback);
    }

    public MerchantLocationResponseBody readMerchantLocation(String merchantLocationGuid) throws ApiException {
        ApiResponse<MerchantLocationResponseBody> localVarResp = this.readMerchantLocationWithHttpInfo(merchantLocationGuid);
        return localVarResp.getData();
    }

    public ApiResponse<MerchantLocationResponseBody> readMerchantLocationWithHttpInfo(String merchantLocationGuid) throws ApiException {
        Call localVarCall = this.readMerchantLocationValidateBeforeCall(merchantLocationGuid, null);
        Type localVarReturnType = new TypeToken<MerchantLocationResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readMerchantLocationAsync(String merchantLocationGuid, ApiCallback<MerchantLocationResponseBody> _callback) throws ApiException {
        Call localVarCall = this.readMerchantLocationValidateBeforeCall(merchantLocationGuid, _callback);
        Type localVarReturnType = new TypeToken<MerchantLocationResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

