/*
 * Decompiled with CFR 0.152.
 */
package com.mx.client.mx_platform_api;

import com.google.gson.reflect.TypeToken;
import com.mx.client.ApiCallback;
import com.mx.client.ApiClient;
import com.mx.client.ApiException;
import com.mx.client.ApiResponse;
import com.mx.client.Configuration;
import com.mx.client.Pair;
import com.mx.client.model.MemberResponseBody;
import com.mx.client.model.StatementResponseBody;
import com.mx.client.model.StatementsResponseBody;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class StatementsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public StatementsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public StatementsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call downloadStatementPDFCall(String memberGuid, String statementGuid, String userGuid, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/users/{user_guid}/members/{member_guid}/statements/{statement_guid}.pdf".replace("{member_guid}", this.localVarApiClient.escapeString(memberGuid.toString())).replace("{statement_guid}", this.localVarApiClient.escapeString(statementGuid.toString())).replace("{user_guid}", this.localVarApiClient.escapeString(userGuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.mx.api.v1+pdf"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call downloadStatementPDFValidateBeforeCall(String memberGuid, String statementGuid, String userGuid, ApiCallback _callback) throws ApiException {
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling downloadStatementPDF(Async)");
        }
        if (statementGuid == null) {
            throw new ApiException("Missing the required parameter 'statementGuid' when calling downloadStatementPDF(Async)");
        }
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling downloadStatementPDF(Async)");
        }
        return this.downloadStatementPDFCall(memberGuid, statementGuid, userGuid, _callback);
    }

    public File downloadStatementPDF(String memberGuid, String statementGuid, String userGuid) throws ApiException {
        ApiResponse<File> localVarResp = this.downloadStatementPDFWithHttpInfo(memberGuid, statementGuid, userGuid);
        return localVarResp.getData();
    }

    public ApiResponse<File> downloadStatementPDFWithHttpInfo(String memberGuid, String statementGuid, String userGuid) throws ApiException {
        Call localVarCall = this.downloadStatementPDFValidateBeforeCall(memberGuid, statementGuid, userGuid, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call downloadStatementPDFAsync(String memberGuid, String statementGuid, String userGuid, ApiCallback<File> _callback) throws ApiException {
        Call localVarCall = this.downloadStatementPDFValidateBeforeCall(memberGuid, statementGuid, userGuid, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call fetchStatementsCall(String memberGuid, String userGuid, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/users/{user_guid}/members/{member_guid}/fetch_statements".replace("{member_guid}", this.localVarApiClient.escapeString(memberGuid.toString())).replace("{user_guid}", this.localVarApiClient.escapeString(userGuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.mx.api.v1+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call fetchStatementsValidateBeforeCall(String memberGuid, String userGuid, ApiCallback _callback) throws ApiException {
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling fetchStatements(Async)");
        }
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling fetchStatements(Async)");
        }
        return this.fetchStatementsCall(memberGuid, userGuid, _callback);
    }

    public MemberResponseBody fetchStatements(String memberGuid, String userGuid) throws ApiException {
        ApiResponse<MemberResponseBody> localVarResp = this.fetchStatementsWithHttpInfo(memberGuid, userGuid);
        return localVarResp.getData();
    }

    public ApiResponse<MemberResponseBody> fetchStatementsWithHttpInfo(String memberGuid, String userGuid) throws ApiException {
        Call localVarCall = this.fetchStatementsValidateBeforeCall(memberGuid, userGuid, null);
        Type localVarReturnType = new TypeToken<MemberResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call fetchStatementsAsync(String memberGuid, String userGuid, ApiCallback<MemberResponseBody> _callback) throws ApiException {
        Call localVarCall = this.fetchStatementsValidateBeforeCall(memberGuid, userGuid, _callback);
        Type localVarReturnType = new TypeToken<MemberResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listStatementsByMemberCall(String memberGuid, String userGuid, Integer page, Integer recordsPerPage, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/users/{user_guid}/members/{member_guid}/statements".replace("{member_guid}", this.localVarApiClient.escapeString(memberGuid.toString())).replace("{user_guid}", this.localVarApiClient.escapeString(userGuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (recordsPerPage != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("records_per_page", recordsPerPage));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/vnd.mx.api.v1+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listStatementsByMemberValidateBeforeCall(String memberGuid, String userGuid, Integer page, Integer recordsPerPage, ApiCallback _callback) throws ApiException {
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling listStatementsByMember(Async)");
        }
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling listStatementsByMember(Async)");
        }
        return this.listStatementsByMemberCall(memberGuid, userGuid, page, recordsPerPage, _callback);
    }

    public StatementsResponseBody listStatementsByMember(String memberGuid, String userGuid, Integer page, Integer recordsPerPage) throws ApiException {
        ApiResponse<StatementsResponseBody> localVarResp = this.listStatementsByMemberWithHttpInfo(memberGuid, userGuid, page, recordsPerPage);
        return localVarResp.getData();
    }

    public ApiResponse<StatementsResponseBody> listStatementsByMemberWithHttpInfo(String memberGuid, String userGuid, Integer page, Integer recordsPerPage) throws ApiException {
        Call localVarCall = this.listStatementsByMemberValidateBeforeCall(memberGuid, userGuid, page, recordsPerPage, null);
        Type localVarReturnType = new TypeToken<StatementsResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listStatementsByMemberAsync(String memberGuid, String userGuid, Integer page, Integer recordsPerPage, ApiCallback<StatementsResponseBody> _callback) throws ApiException {
        Call localVarCall = this.listStatementsByMemberValidateBeforeCall(memberGuid, userGuid, page, recordsPerPage, _callback);
        Type localVarReturnType = new TypeToken<StatementsResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readStatementByMemberCall(String memberGuid, String statementGuid, String userGuid, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/users/{user_guid}/members/{member_guid}/statements/{statement_guid}".replace("{member_guid}", this.localVarApiClient.escapeString(memberGuid.toString())).replace("{statement_guid}", this.localVarApiClient.escapeString(statementGuid.toString())).replace("{user_guid}", this.localVarApiClient.escapeString(userGuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.mx.api.v1+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readStatementByMemberValidateBeforeCall(String memberGuid, String statementGuid, String userGuid, ApiCallback _callback) throws ApiException {
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling readStatementByMember(Async)");
        }
        if (statementGuid == null) {
            throw new ApiException("Missing the required parameter 'statementGuid' when calling readStatementByMember(Async)");
        }
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling readStatementByMember(Async)");
        }
        return this.readStatementByMemberCall(memberGuid, statementGuid, userGuid, _callback);
    }

    public StatementResponseBody readStatementByMember(String memberGuid, String statementGuid, String userGuid) throws ApiException {
        ApiResponse<StatementResponseBody> localVarResp = this.readStatementByMemberWithHttpInfo(memberGuid, statementGuid, userGuid);
        return localVarResp.getData();
    }

    public ApiResponse<StatementResponseBody> readStatementByMemberWithHttpInfo(String memberGuid, String statementGuid, String userGuid) throws ApiException {
        Call localVarCall = this.readStatementByMemberValidateBeforeCall(memberGuid, statementGuid, userGuid, null);
        Type localVarReturnType = new TypeToken<StatementResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readStatementByMemberAsync(String memberGuid, String statementGuid, String userGuid, ApiCallback<StatementResponseBody> _callback) throws ApiException {
        Call localVarCall = this.readStatementByMemberValidateBeforeCall(memberGuid, statementGuid, userGuid, _callback);
        Type localVarReturnType = new TypeToken<StatementResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

