/*
 * Decompiled with CFR 0.152.
 */
package com.mx.client.mx_platform_api;

import com.google.gson.reflect.TypeToken;
import com.mx.client.ApiCallback;
import com.mx.client.ApiClient;
import com.mx.client.ApiException;
import com.mx.client.ApiResponse;
import com.mx.client.Configuration;
import com.mx.client.Pair;
import com.mx.client.model.TagCreateRequestBody;
import com.mx.client.model.TagResponseBody;
import com.mx.client.model.TagUpdateRequestBody;
import com.mx.client.model.TagsResponseBody;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class TagsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public TagsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public TagsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createTagCall(String userGuid, TagCreateRequestBody tagCreateRequestBody, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        TagCreateRequestBody localVarPostBody = tagCreateRequestBody;
        String localVarPath = "/users/{user_guid}/tags".replace("{user_guid}", this.localVarApiClient.escapeString(userGuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.mx.api.v1+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createTagValidateBeforeCall(String userGuid, TagCreateRequestBody tagCreateRequestBody, ApiCallback _callback) throws ApiException {
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling createTag(Async)");
        }
        if (tagCreateRequestBody == null) {
            throw new ApiException("Missing the required parameter 'tagCreateRequestBody' when calling createTag(Async)");
        }
        return this.createTagCall(userGuid, tagCreateRequestBody, _callback);
    }

    public TagResponseBody createTag(String userGuid, TagCreateRequestBody tagCreateRequestBody) throws ApiException {
        ApiResponse<TagResponseBody> localVarResp = this.createTagWithHttpInfo(userGuid, tagCreateRequestBody);
        return localVarResp.getData();
    }

    public ApiResponse<TagResponseBody> createTagWithHttpInfo(String userGuid, TagCreateRequestBody tagCreateRequestBody) throws ApiException {
        Call localVarCall = this.createTagValidateBeforeCall(userGuid, tagCreateRequestBody, null);
        Type localVarReturnType = new TypeToken<TagResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createTagAsync(String userGuid, TagCreateRequestBody tagCreateRequestBody, ApiCallback<TagResponseBody> _callback) throws ApiException {
        Call localVarCall = this.createTagValidateBeforeCall(userGuid, tagCreateRequestBody, _callback);
        Type localVarReturnType = new TypeToken<TagResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteTagCall(String tagGuid, String accept, String userGuid, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/users/{user_guid}/tags/{tag_guid}".replace("{tag_guid}", this.localVarApiClient.escapeString(tagGuid.toString())).replace("{user_guid}", this.localVarApiClient.escapeString(userGuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (accept != null) {
            localVarHeaderParams.put("Accept", this.localVarApiClient.parameterToString(accept));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[0])) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteTagValidateBeforeCall(String tagGuid, String accept, String userGuid, ApiCallback _callback) throws ApiException {
        if (tagGuid == null) {
            throw new ApiException("Missing the required parameter 'tagGuid' when calling deleteTag(Async)");
        }
        if (accept == null) {
            throw new ApiException("Missing the required parameter 'accept' when calling deleteTag(Async)");
        }
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling deleteTag(Async)");
        }
        return this.deleteTagCall(tagGuid, accept, userGuid, _callback);
    }

    public void deleteTag(String tagGuid, String accept, String userGuid) throws ApiException {
        this.deleteTagWithHttpInfo(tagGuid, accept, userGuid);
    }

    public ApiResponse<Void> deleteTagWithHttpInfo(String tagGuid, String accept, String userGuid) throws ApiException {
        Call localVarCall = this.deleteTagValidateBeforeCall(tagGuid, accept, userGuid, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteTagAsync(String tagGuid, String accept, String userGuid, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteTagValidateBeforeCall(tagGuid, accept, userGuid, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call listTagsCall(String userGuid, Integer page, Integer recordsPerPage, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/users/{user_guid}/tags".replace("{user_guid}", this.localVarApiClient.escapeString(userGuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (recordsPerPage != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("records_per_page", recordsPerPage));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/vnd.mx.api.v1+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listTagsValidateBeforeCall(String userGuid, Integer page, Integer recordsPerPage, ApiCallback _callback) throws ApiException {
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling listTags(Async)");
        }
        return this.listTagsCall(userGuid, page, recordsPerPage, _callback);
    }

    public TagsResponseBody listTags(String userGuid, Integer page, Integer recordsPerPage) throws ApiException {
        ApiResponse<TagsResponseBody> localVarResp = this.listTagsWithHttpInfo(userGuid, page, recordsPerPage);
        return localVarResp.getData();
    }

    public ApiResponse<TagsResponseBody> listTagsWithHttpInfo(String userGuid, Integer page, Integer recordsPerPage) throws ApiException {
        Call localVarCall = this.listTagsValidateBeforeCall(userGuid, page, recordsPerPage, null);
        Type localVarReturnType = new TypeToken<TagsResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listTagsAsync(String userGuid, Integer page, Integer recordsPerPage, ApiCallback<TagsResponseBody> _callback) throws ApiException {
        Call localVarCall = this.listTagsValidateBeforeCall(userGuid, page, recordsPerPage, _callback);
        Type localVarReturnType = new TypeToken<TagsResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readTagCall(String tagGuid, String userGuid, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/users/{user_guid}/tags/{tag_guid}".replace("{tag_guid}", this.localVarApiClient.escapeString(tagGuid.toString())).replace("{user_guid}", this.localVarApiClient.escapeString(userGuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.mx.api.v1+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readTagValidateBeforeCall(String tagGuid, String userGuid, ApiCallback _callback) throws ApiException {
        if (tagGuid == null) {
            throw new ApiException("Missing the required parameter 'tagGuid' when calling readTag(Async)");
        }
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling readTag(Async)");
        }
        return this.readTagCall(tagGuid, userGuid, _callback);
    }

    public TagResponseBody readTag(String tagGuid, String userGuid) throws ApiException {
        ApiResponse<TagResponseBody> localVarResp = this.readTagWithHttpInfo(tagGuid, userGuid);
        return localVarResp.getData();
    }

    public ApiResponse<TagResponseBody> readTagWithHttpInfo(String tagGuid, String userGuid) throws ApiException {
        Call localVarCall = this.readTagValidateBeforeCall(tagGuid, userGuid, null);
        Type localVarReturnType = new TypeToken<TagResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readTagAsync(String tagGuid, String userGuid, ApiCallback<TagResponseBody> _callback) throws ApiException {
        Call localVarCall = this.readTagValidateBeforeCall(tagGuid, userGuid, _callback);
        Type localVarReturnType = new TypeToken<TagResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateTagCall(String tagGuid, String userGuid, TagUpdateRequestBody tagUpdateRequestBody, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        TagUpdateRequestBody localVarPostBody = tagUpdateRequestBody;
        String localVarPath = "/users/{user_guid}/tags/{tag_guid}".replace("{tag_guid}", this.localVarApiClient.escapeString(tagGuid.toString())).replace("{user_guid}", this.localVarApiClient.escapeString(userGuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.mx.api.v1+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateTagValidateBeforeCall(String tagGuid, String userGuid, TagUpdateRequestBody tagUpdateRequestBody, ApiCallback _callback) throws ApiException {
        if (tagGuid == null) {
            throw new ApiException("Missing the required parameter 'tagGuid' when calling updateTag(Async)");
        }
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling updateTag(Async)");
        }
        if (tagUpdateRequestBody == null) {
            throw new ApiException("Missing the required parameter 'tagUpdateRequestBody' when calling updateTag(Async)");
        }
        return this.updateTagCall(tagGuid, userGuid, tagUpdateRequestBody, _callback);
    }

    public TagResponseBody updateTag(String tagGuid, String userGuid, TagUpdateRequestBody tagUpdateRequestBody) throws ApiException {
        ApiResponse<TagResponseBody> localVarResp = this.updateTagWithHttpInfo(tagGuid, userGuid, tagUpdateRequestBody);
        return localVarResp.getData();
    }

    public ApiResponse<TagResponseBody> updateTagWithHttpInfo(String tagGuid, String userGuid, TagUpdateRequestBody tagUpdateRequestBody) throws ApiException {
        Call localVarCall = this.updateTagValidateBeforeCall(tagGuid, userGuid, tagUpdateRequestBody, null);
        Type localVarReturnType = new TypeToken<TagResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateTagAsync(String tagGuid, String userGuid, TagUpdateRequestBody tagUpdateRequestBody, ApiCallback<TagResponseBody> _callback) throws ApiException {
        Call localVarCall = this.updateTagValidateBeforeCall(tagGuid, userGuid, tagUpdateRequestBody, _callback);
        Type localVarReturnType = new TypeToken<TagResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

