/*
 * Decompiled with CFR 0.152.
 */
package com.mx.client.mx_platform_api;

import com.google.gson.reflect.TypeToken;
import com.mx.client.ApiCallback;
import com.mx.client.ApiClient;
import com.mx.client.ApiException;
import com.mx.client.ApiResponse;
import com.mx.client.Configuration;
import com.mx.client.Pair;
import com.mx.client.model.EnhanceTransactionsRequestBody;
import com.mx.client.model.EnhanceTransactionsResponseBody;
import com.mx.client.model.MemberResponseBody;
import com.mx.client.model.RepeatingTransactionsResponseBody;
import com.mx.client.model.SplitTransactionRequestBody;
import com.mx.client.model.SplitTransactionsResponseBody;
import com.mx.client.model.TransactionCreateRequestBody;
import com.mx.client.model.TransactionCreateResponseBody;
import com.mx.client.model.TransactionResponseBody;
import com.mx.client.model.TransactionUpdateRequestBody;
import com.mx.client.model.TransactionsResponseBodyIncludes;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;

public class TransactionsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public TransactionsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public TransactionsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createManualTransactionCall(String userGuid, String accountGuid, TransactionCreateRequestBody transactionCreateRequestBody, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        TransactionCreateRequestBody localVarPostBody = transactionCreateRequestBody;
        String localVarPath = "/users/{user_guid}/accounts/{account_guid}/transactions".replace("{user_guid}", this.localVarApiClient.escapeString(userGuid.toString())).replace("{account_guid}", this.localVarApiClient.escapeString(accountGuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.mx.api.v1+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createManualTransactionValidateBeforeCall(String userGuid, String accountGuid, TransactionCreateRequestBody transactionCreateRequestBody, ApiCallback _callback) throws ApiException {
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling createManualTransaction(Async)");
        }
        if (accountGuid == null) {
            throw new ApiException("Missing the required parameter 'accountGuid' when calling createManualTransaction(Async)");
        }
        if (transactionCreateRequestBody == null) {
            throw new ApiException("Missing the required parameter 'transactionCreateRequestBody' when calling createManualTransaction(Async)");
        }
        return this.createManualTransactionCall(userGuid, accountGuid, transactionCreateRequestBody, _callback);
    }

    public TransactionCreateResponseBody createManualTransaction(String userGuid, String accountGuid, TransactionCreateRequestBody transactionCreateRequestBody) throws ApiException {
        ApiResponse<TransactionCreateResponseBody> localVarResp = this.createManualTransactionWithHttpInfo(userGuid, accountGuid, transactionCreateRequestBody);
        return localVarResp.getData();
    }

    public ApiResponse<TransactionCreateResponseBody> createManualTransactionWithHttpInfo(String userGuid, String accountGuid, TransactionCreateRequestBody transactionCreateRequestBody) throws ApiException {
        Call localVarCall = this.createManualTransactionValidateBeforeCall(userGuid, accountGuid, transactionCreateRequestBody, null);
        Type localVarReturnType = new TypeToken<TransactionCreateResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createManualTransactionAsync(String userGuid, String accountGuid, TransactionCreateRequestBody transactionCreateRequestBody, ApiCallback<TransactionCreateResponseBody> _callback) throws ApiException {
        Call localVarCall = this.createManualTransactionValidateBeforeCall(userGuid, accountGuid, transactionCreateRequestBody, _callback);
        Type localVarReturnType = new TypeToken<TransactionCreateResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call createSplitTransactionsCall(String transactionGuid, String userGuid, SplitTransactionRequestBody splitTransactionRequestBody, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SplitTransactionRequestBody localVarPostBody = splitTransactionRequestBody;
        String localVarPath = "/users/{user_guid}/transactions/{transaction_guid}/split".replace("{transaction_guid}", this.localVarApiClient.escapeString(transactionGuid.toString())).replace("{user_guid}", this.localVarApiClient.escapeString(userGuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.mx.api.v1+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createSplitTransactionsValidateBeforeCall(String transactionGuid, String userGuid, SplitTransactionRequestBody splitTransactionRequestBody, ApiCallback _callback) throws ApiException {
        if (transactionGuid == null) {
            throw new ApiException("Missing the required parameter 'transactionGuid' when calling createSplitTransactions(Async)");
        }
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling createSplitTransactions(Async)");
        }
        return this.createSplitTransactionsCall(transactionGuid, userGuid, splitTransactionRequestBody, _callback);
    }

    public SplitTransactionsResponseBody createSplitTransactions(String transactionGuid, String userGuid, SplitTransactionRequestBody splitTransactionRequestBody) throws ApiException {
        ApiResponse<SplitTransactionsResponseBody> localVarResp = this.createSplitTransactionsWithHttpInfo(transactionGuid, userGuid, splitTransactionRequestBody);
        return localVarResp.getData();
    }

    public ApiResponse<SplitTransactionsResponseBody> createSplitTransactionsWithHttpInfo(String transactionGuid, String userGuid, SplitTransactionRequestBody splitTransactionRequestBody) throws ApiException {
        Call localVarCall = this.createSplitTransactionsValidateBeforeCall(transactionGuid, userGuid, splitTransactionRequestBody, null);
        Type localVarReturnType = new TypeToken<SplitTransactionsResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createSplitTransactionsAsync(String transactionGuid, String userGuid, SplitTransactionRequestBody splitTransactionRequestBody, ApiCallback<SplitTransactionsResponseBody> _callback) throws ApiException {
        Call localVarCall = this.createSplitTransactionsValidateBeforeCall(transactionGuid, userGuid, splitTransactionRequestBody, _callback);
        Type localVarReturnType = new TypeToken<SplitTransactionsResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteManualTransactionsCall(String userGuid, String transactionGuid, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/users/{user_guid}/transactions/{transaction_guid}".replace("{user_guid}", this.localVarApiClient.escapeString(userGuid.toString())).replace("{transaction_guid}", this.localVarApiClient.escapeString(transactionGuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteManualTransactionsValidateBeforeCall(String userGuid, String transactionGuid, ApiCallback _callback) throws ApiException {
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling deleteManualTransactions(Async)");
        }
        if (transactionGuid == null) {
            throw new ApiException("Missing the required parameter 'transactionGuid' when calling deleteManualTransactions(Async)");
        }
        return this.deleteManualTransactionsCall(userGuid, transactionGuid, _callback);
    }

    public void deleteManualTransactions(String userGuid, String transactionGuid) throws ApiException {
        this.deleteManualTransactionsWithHttpInfo(userGuid, transactionGuid);
    }

    public ApiResponse<Void> deleteManualTransactionsWithHttpInfo(String userGuid, String transactionGuid) throws ApiException {
        Call localVarCall = this.deleteManualTransactionsValidateBeforeCall(userGuid, transactionGuid, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteManualTransactionsAsync(String userGuid, String transactionGuid, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteManualTransactionsValidateBeforeCall(userGuid, transactionGuid, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call deleteSplitTransactionsCall(String transactionGuid, String userGuid, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/users/{user_guid}/transactions/{transaction_guid}/split".replace("{transaction_guid}", this.localVarApiClient.escapeString(transactionGuid.toString())).replace("{user_guid}", this.localVarApiClient.escapeString(userGuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteSplitTransactionsValidateBeforeCall(String transactionGuid, String userGuid, ApiCallback _callback) throws ApiException {
        if (transactionGuid == null) {
            throw new ApiException("Missing the required parameter 'transactionGuid' when calling deleteSplitTransactions(Async)");
        }
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling deleteSplitTransactions(Async)");
        }
        return this.deleteSplitTransactionsCall(transactionGuid, userGuid, _callback);
    }

    public void deleteSplitTransactions(String transactionGuid, String userGuid) throws ApiException {
        this.deleteSplitTransactionsWithHttpInfo(transactionGuid, userGuid);
    }

    public ApiResponse<Void> deleteSplitTransactionsWithHttpInfo(String transactionGuid, String userGuid) throws ApiException {
        Call localVarCall = this.deleteSplitTransactionsValidateBeforeCall(transactionGuid, userGuid, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteSplitTransactionsAsync(String transactionGuid, String userGuid, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteSplitTransactionsValidateBeforeCall(transactionGuid, userGuid, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call deleteTransactionRuleCall(String transactionRuleGuid, String userGuid, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/users/{user_guid}/transaction_rules/{transaction_rule_guid}".replace("{transaction_rule_guid}", this.localVarApiClient.escapeString(transactionRuleGuid.toString())).replace("{user_guid}", this.localVarApiClient.escapeString(userGuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteTransactionRuleValidateBeforeCall(String transactionRuleGuid, String userGuid, ApiCallback _callback) throws ApiException {
        if (transactionRuleGuid == null) {
            throw new ApiException("Missing the required parameter 'transactionRuleGuid' when calling deleteTransactionRule(Async)");
        }
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling deleteTransactionRule(Async)");
        }
        return this.deleteTransactionRuleCall(transactionRuleGuid, userGuid, _callback);
    }

    public void deleteTransactionRule(String transactionRuleGuid, String userGuid) throws ApiException {
        this.deleteTransactionRuleWithHttpInfo(transactionRuleGuid, userGuid);
    }

    public ApiResponse<Void> deleteTransactionRuleWithHttpInfo(String transactionRuleGuid, String userGuid) throws ApiException {
        Call localVarCall = this.deleteTransactionRuleValidateBeforeCall(transactionRuleGuid, userGuid, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteTransactionRuleAsync(String transactionRuleGuid, String userGuid, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteTransactionRuleValidateBeforeCall(transactionRuleGuid, userGuid, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call enhanceTransactionsCall(EnhanceTransactionsRequestBody enhanceTransactionsRequestBody, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        EnhanceTransactionsRequestBody localVarPostBody = enhanceTransactionsRequestBody;
        String localVarPath = "/transactions/enhance";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.mx.api.v1+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call enhanceTransactionsValidateBeforeCall(EnhanceTransactionsRequestBody enhanceTransactionsRequestBody, ApiCallback _callback) throws ApiException {
        if (enhanceTransactionsRequestBody == null) {
            throw new ApiException("Missing the required parameter 'enhanceTransactionsRequestBody' when calling enhanceTransactions(Async)");
        }
        return this.enhanceTransactionsCall(enhanceTransactionsRequestBody, _callback);
    }

    public EnhanceTransactionsResponseBody enhanceTransactions(EnhanceTransactionsRequestBody enhanceTransactionsRequestBody) throws ApiException {
        ApiResponse<EnhanceTransactionsResponseBody> localVarResp = this.enhanceTransactionsWithHttpInfo(enhanceTransactionsRequestBody);
        return localVarResp.getData();
    }

    public ApiResponse<EnhanceTransactionsResponseBody> enhanceTransactionsWithHttpInfo(EnhanceTransactionsRequestBody enhanceTransactionsRequestBody) throws ApiException {
        Call localVarCall = this.enhanceTransactionsValidateBeforeCall(enhanceTransactionsRequestBody, null);
        Type localVarReturnType = new TypeToken<EnhanceTransactionsResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call enhanceTransactionsAsync(EnhanceTransactionsRequestBody enhanceTransactionsRequestBody, ApiCallback<EnhanceTransactionsResponseBody> _callback) throws ApiException {
        Call localVarCall = this.enhanceTransactionsValidateBeforeCall(enhanceTransactionsRequestBody, _callback);
        Type localVarReturnType = new TypeToken<EnhanceTransactionsResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call extendHistoryCall(String memberGuid, String userGuid, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/users/{user_guid}/members/{member_guid}/extend_history".replace("{member_guid}", this.localVarApiClient.escapeString(memberGuid.toString())).replace("{user_guid}", this.localVarApiClient.escapeString(userGuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.mx.api.v1+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call extendHistoryValidateBeforeCall(String memberGuid, String userGuid, ApiCallback _callback) throws ApiException {
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling extendHistory(Async)");
        }
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling extendHistory(Async)");
        }
        return this.extendHistoryCall(memberGuid, userGuid, _callback);
    }

    public MemberResponseBody extendHistory(String memberGuid, String userGuid) throws ApiException {
        ApiResponse<MemberResponseBody> localVarResp = this.extendHistoryWithHttpInfo(memberGuid, userGuid);
        return localVarResp.getData();
    }

    public ApiResponse<MemberResponseBody> extendHistoryWithHttpInfo(String memberGuid, String userGuid) throws ApiException {
        Call localVarCall = this.extendHistoryValidateBeforeCall(memberGuid, userGuid, null);
        Type localVarReturnType = new TypeToken<MemberResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call extendHistoryAsync(String memberGuid, String userGuid, ApiCallback<MemberResponseBody> _callback) throws ApiException {
        Call localVarCall = this.extendHistoryValidateBeforeCall(memberGuid, userGuid, _callback);
        Type localVarReturnType = new TypeToken<MemberResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listTransactionsCall(String userGuid, Integer page, Integer recordsPerPage, String fromDate, String toDate, String fromCreatedAt, String toCreatedAt, String fromUpdatedAt, String toUpdatedAt, String categoryGuid, List<String> categoryGuid2, String topLevelCategoryGuid, List<String> topLevelCategoryGuid2, String useCase, String includes, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/users/{user_guid}/transactions".replace("{user_guid}", this.localVarApiClient.escapeString(userGuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (recordsPerPage != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("records_per_page", recordsPerPage));
        }
        if (fromDate != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("from_date", fromDate));
        }
        if (toDate != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("to_date", toDate));
        }
        if (fromCreatedAt != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("from_created_at", fromCreatedAt));
        }
        if (toCreatedAt != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("to_created_at", toCreatedAt));
        }
        if (fromUpdatedAt != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("from_updated_at", fromUpdatedAt));
        }
        if (toUpdatedAt != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("to_updated_at", toUpdatedAt));
        }
        if (categoryGuid != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("category_guid", categoryGuid));
        }
        if (categoryGuid2 != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "category_guid[]", categoryGuid2));
        }
        if (topLevelCategoryGuid != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("top_level_category_guid", topLevelCategoryGuid));
        }
        if (topLevelCategoryGuid2 != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "top_level_category_guid[]", topLevelCategoryGuid2));
        }
        if (useCase != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("use_case", useCase));
        }
        if (includes != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("includes", includes));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/vnd.mx.api.v1+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listTransactionsValidateBeforeCall(String userGuid, Integer page, Integer recordsPerPage, String fromDate, String toDate, String fromCreatedAt, String toCreatedAt, String fromUpdatedAt, String toUpdatedAt, String categoryGuid, List<String> categoryGuid2, String topLevelCategoryGuid, List<String> topLevelCategoryGuid2, String useCase, String includes, ApiCallback _callback) throws ApiException {
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling listTransactions(Async)");
        }
        return this.listTransactionsCall(userGuid, page, recordsPerPage, fromDate, toDate, fromCreatedAt, toCreatedAt, fromUpdatedAt, toUpdatedAt, categoryGuid, categoryGuid2, topLevelCategoryGuid, topLevelCategoryGuid2, useCase, includes, _callback);
    }

    public TransactionsResponseBodyIncludes listTransactions(String userGuid, Integer page, Integer recordsPerPage, String fromDate, String toDate, String fromCreatedAt, String toCreatedAt, String fromUpdatedAt, String toUpdatedAt, String categoryGuid, List<String> categoryGuid2, String topLevelCategoryGuid, List<String> topLevelCategoryGuid2, String useCase, String includes) throws ApiException {
        ApiResponse<TransactionsResponseBodyIncludes> localVarResp = this.listTransactionsWithHttpInfo(userGuid, page, recordsPerPage, fromDate, toDate, fromCreatedAt, toCreatedAt, fromUpdatedAt, toUpdatedAt, categoryGuid, categoryGuid2, topLevelCategoryGuid, topLevelCategoryGuid2, useCase, includes);
        return localVarResp.getData();
    }

    public ApiResponse<TransactionsResponseBodyIncludes> listTransactionsWithHttpInfo(String userGuid, Integer page, Integer recordsPerPage, String fromDate, String toDate, String fromCreatedAt, String toCreatedAt, String fromUpdatedAt, String toUpdatedAt, String categoryGuid, List<String> categoryGuid2, String topLevelCategoryGuid, List<String> topLevelCategoryGuid2, String useCase, String includes) throws ApiException {
        Call localVarCall = this.listTransactionsValidateBeforeCall(userGuid, page, recordsPerPage, fromDate, toDate, fromCreatedAt, toCreatedAt, fromUpdatedAt, toUpdatedAt, categoryGuid, categoryGuid2, topLevelCategoryGuid, topLevelCategoryGuid2, useCase, includes, null);
        Type localVarReturnType = new TypeToken<TransactionsResponseBodyIncludes>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listTransactionsAsync(String userGuid, Integer page, Integer recordsPerPage, String fromDate, String toDate, String fromCreatedAt, String toCreatedAt, String fromUpdatedAt, String toUpdatedAt, String categoryGuid, List<String> categoryGuid2, String topLevelCategoryGuid, List<String> topLevelCategoryGuid2, String useCase, String includes, ApiCallback<TransactionsResponseBodyIncludes> _callback) throws ApiException {
        Call localVarCall = this.listTransactionsValidateBeforeCall(userGuid, page, recordsPerPage, fromDate, toDate, fromCreatedAt, toCreatedAt, fromUpdatedAt, toUpdatedAt, categoryGuid, categoryGuid2, topLevelCategoryGuid, topLevelCategoryGuid2, useCase, includes, _callback);
        Type localVarReturnType = new TypeToken<TransactionsResponseBodyIncludes>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listTransactionsByAccountCall(String accountGuid, String userGuid, Integer page, Integer recordsPerPage, String fromDate, String toDate, String fromCreatedAt, String toCreatedAt, String fromUpdatedAt, String toUpdatedAt, String categoryGuid, List<String> categoryGuid2, String topLevelCategoryGuid, List<String> topLevelCategoryGuid2, String includes, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/users/{user_guid}/accounts/{account_guid}/transactions".replace("{account_guid}", this.localVarApiClient.escapeString(accountGuid.toString())).replace("{user_guid}", this.localVarApiClient.escapeString(userGuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (recordsPerPage != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("records_per_page", recordsPerPage));
        }
        if (fromDate != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("from_date", fromDate));
        }
        if (toDate != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("to_date", toDate));
        }
        if (fromCreatedAt != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("from_created_at", fromCreatedAt));
        }
        if (toCreatedAt != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("to_created_at", toCreatedAt));
        }
        if (fromUpdatedAt != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("from_updated_at", fromUpdatedAt));
        }
        if (toUpdatedAt != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("to_updated_at", toUpdatedAt));
        }
        if (categoryGuid != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("category_guid", categoryGuid));
        }
        if (categoryGuid2 != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "category_guid[]", categoryGuid2));
        }
        if (topLevelCategoryGuid != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("top_level_category_guid", topLevelCategoryGuid));
        }
        if (topLevelCategoryGuid2 != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "top_level_category_guid[]", topLevelCategoryGuid2));
        }
        if (includes != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("includes", includes));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/vnd.mx.api.v1+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listTransactionsByAccountValidateBeforeCall(String accountGuid, String userGuid, Integer page, Integer recordsPerPage, String fromDate, String toDate, String fromCreatedAt, String toCreatedAt, String fromUpdatedAt, String toUpdatedAt, String categoryGuid, List<String> categoryGuid2, String topLevelCategoryGuid, List<String> topLevelCategoryGuid2, String includes, ApiCallback _callback) throws ApiException {
        if (accountGuid == null) {
            throw new ApiException("Missing the required parameter 'accountGuid' when calling listTransactionsByAccount(Async)");
        }
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling listTransactionsByAccount(Async)");
        }
        return this.listTransactionsByAccountCall(accountGuid, userGuid, page, recordsPerPage, fromDate, toDate, fromCreatedAt, toCreatedAt, fromUpdatedAt, toUpdatedAt, categoryGuid, categoryGuid2, topLevelCategoryGuid, topLevelCategoryGuid2, includes, _callback);
    }

    public TransactionsResponseBodyIncludes listTransactionsByAccount(String accountGuid, String userGuid, Integer page, Integer recordsPerPage, String fromDate, String toDate, String fromCreatedAt, String toCreatedAt, String fromUpdatedAt, String toUpdatedAt, String categoryGuid, List<String> categoryGuid2, String topLevelCategoryGuid, List<String> topLevelCategoryGuid2, String includes) throws ApiException {
        ApiResponse<TransactionsResponseBodyIncludes> localVarResp = this.listTransactionsByAccountWithHttpInfo(accountGuid, userGuid, page, recordsPerPage, fromDate, toDate, fromCreatedAt, toCreatedAt, fromUpdatedAt, toUpdatedAt, categoryGuid, categoryGuid2, topLevelCategoryGuid, topLevelCategoryGuid2, includes);
        return localVarResp.getData();
    }

    public ApiResponse<TransactionsResponseBodyIncludes> listTransactionsByAccountWithHttpInfo(String accountGuid, String userGuid, Integer page, Integer recordsPerPage, String fromDate, String toDate, String fromCreatedAt, String toCreatedAt, String fromUpdatedAt, String toUpdatedAt, String categoryGuid, List<String> categoryGuid2, String topLevelCategoryGuid, List<String> topLevelCategoryGuid2, String includes) throws ApiException {
        Call localVarCall = this.listTransactionsByAccountValidateBeforeCall(accountGuid, userGuid, page, recordsPerPage, fromDate, toDate, fromCreatedAt, toCreatedAt, fromUpdatedAt, toUpdatedAt, categoryGuid, categoryGuid2, topLevelCategoryGuid, topLevelCategoryGuid2, includes, null);
        Type localVarReturnType = new TypeToken<TransactionsResponseBodyIncludes>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listTransactionsByAccountAsync(String accountGuid, String userGuid, Integer page, Integer recordsPerPage, String fromDate, String toDate, String fromCreatedAt, String toCreatedAt, String fromUpdatedAt, String toUpdatedAt, String categoryGuid, List<String> categoryGuid2, String topLevelCategoryGuid, List<String> topLevelCategoryGuid2, String includes, ApiCallback<TransactionsResponseBodyIncludes> _callback) throws ApiException {
        Call localVarCall = this.listTransactionsByAccountValidateBeforeCall(accountGuid, userGuid, page, recordsPerPage, fromDate, toDate, fromCreatedAt, toCreatedAt, fromUpdatedAt, toUpdatedAt, categoryGuid, categoryGuid2, topLevelCategoryGuid, topLevelCategoryGuid2, includes, _callback);
        Type localVarReturnType = new TypeToken<TransactionsResponseBodyIncludes>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listTransactionsByMemberCall(String memberGuid, String userGuid, Integer page, Integer recordsPerPage, String fromDate, String toDate, String fromCreatedAt, String toCreatedAt, String fromUpdatedAt, String toUpdatedAt, String categoryGuid, List<String> categoryGuid2, String topLevelCategoryGuid, List<String> topLevelCategoryGuid2, String includes, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/users/{user_guid}/members/{member_guid}/transactions".replace("{member_guid}", this.localVarApiClient.escapeString(memberGuid.toString())).replace("{user_guid}", this.localVarApiClient.escapeString(userGuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (recordsPerPage != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("records_per_page", recordsPerPage));
        }
        if (fromDate != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("from_date", fromDate));
        }
        if (toDate != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("to_date", toDate));
        }
        if (fromCreatedAt != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("from_created_at", fromCreatedAt));
        }
        if (toCreatedAt != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("to_created_at", toCreatedAt));
        }
        if (fromUpdatedAt != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("from_updated_at", fromUpdatedAt));
        }
        if (toUpdatedAt != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("to_updated_at", toUpdatedAt));
        }
        if (categoryGuid != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("category_guid", categoryGuid));
        }
        if (categoryGuid2 != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "category_guid[]", categoryGuid2));
        }
        if (topLevelCategoryGuid != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("top_level_category_guid", topLevelCategoryGuid));
        }
        if (topLevelCategoryGuid2 != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "top_level_category_guid[]", topLevelCategoryGuid2));
        }
        if (includes != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("includes", includes));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/vnd.mx.api.v1+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listTransactionsByMemberValidateBeforeCall(String memberGuid, String userGuid, Integer page, Integer recordsPerPage, String fromDate, String toDate, String fromCreatedAt, String toCreatedAt, String fromUpdatedAt, String toUpdatedAt, String categoryGuid, List<String> categoryGuid2, String topLevelCategoryGuid, List<String> topLevelCategoryGuid2, String includes, ApiCallback _callback) throws ApiException {
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling listTransactionsByMember(Async)");
        }
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling listTransactionsByMember(Async)");
        }
        return this.listTransactionsByMemberCall(memberGuid, userGuid, page, recordsPerPage, fromDate, toDate, fromCreatedAt, toCreatedAt, fromUpdatedAt, toUpdatedAt, categoryGuid, categoryGuid2, topLevelCategoryGuid, topLevelCategoryGuid2, includes, _callback);
    }

    public TransactionsResponseBodyIncludes listTransactionsByMember(String memberGuid, String userGuid, Integer page, Integer recordsPerPage, String fromDate, String toDate, String fromCreatedAt, String toCreatedAt, String fromUpdatedAt, String toUpdatedAt, String categoryGuid, List<String> categoryGuid2, String topLevelCategoryGuid, List<String> topLevelCategoryGuid2, String includes) throws ApiException {
        ApiResponse<TransactionsResponseBodyIncludes> localVarResp = this.listTransactionsByMemberWithHttpInfo(memberGuid, userGuid, page, recordsPerPage, fromDate, toDate, fromCreatedAt, toCreatedAt, fromUpdatedAt, toUpdatedAt, categoryGuid, categoryGuid2, topLevelCategoryGuid, topLevelCategoryGuid2, includes);
        return localVarResp.getData();
    }

    public ApiResponse<TransactionsResponseBodyIncludes> listTransactionsByMemberWithHttpInfo(String memberGuid, String userGuid, Integer page, Integer recordsPerPage, String fromDate, String toDate, String fromCreatedAt, String toCreatedAt, String fromUpdatedAt, String toUpdatedAt, String categoryGuid, List<String> categoryGuid2, String topLevelCategoryGuid, List<String> topLevelCategoryGuid2, String includes) throws ApiException {
        Call localVarCall = this.listTransactionsByMemberValidateBeforeCall(memberGuid, userGuid, page, recordsPerPage, fromDate, toDate, fromCreatedAt, toCreatedAt, fromUpdatedAt, toUpdatedAt, categoryGuid, categoryGuid2, topLevelCategoryGuid, topLevelCategoryGuid2, includes, null);
        Type localVarReturnType = new TypeToken<TransactionsResponseBodyIncludes>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listTransactionsByMemberAsync(String memberGuid, String userGuid, Integer page, Integer recordsPerPage, String fromDate, String toDate, String fromCreatedAt, String toCreatedAt, String fromUpdatedAt, String toUpdatedAt, String categoryGuid, List<String> categoryGuid2, String topLevelCategoryGuid, List<String> topLevelCategoryGuid2, String includes, ApiCallback<TransactionsResponseBodyIncludes> _callback) throws ApiException {
        Call localVarCall = this.listTransactionsByMemberValidateBeforeCall(memberGuid, userGuid, page, recordsPerPage, fromDate, toDate, fromCreatedAt, toCreatedAt, fromUpdatedAt, toUpdatedAt, categoryGuid, categoryGuid2, topLevelCategoryGuid, topLevelCategoryGuid2, includes, _callback);
        Type localVarReturnType = new TypeToken<TransactionsResponseBodyIncludes>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listTransactionsByTagCall(String userGuid, String tagGuid, Integer page, Integer recordsPerPage, String fromDate, String toDate, String fromCreatedAt, String toCreatedAt, String fromUpdatedAt, String toUpdatedAt, String categoryGuid, List<String> categoryGuid2, String topLevelCategoryGuid, List<String> topLevelCategoryGuid2, String useCase, String includes, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/users/{user_guid}/tags/{tag_guid}/transactions".replace("{user_guid}", this.localVarApiClient.escapeString(userGuid.toString())).replace("{tag_guid}", this.localVarApiClient.escapeString(tagGuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (recordsPerPage != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("records_per_page", recordsPerPage));
        }
        if (fromDate != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("from_date", fromDate));
        }
        if (toDate != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("to_date", toDate));
        }
        if (fromCreatedAt != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("from_created_at", fromCreatedAt));
        }
        if (toCreatedAt != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("to_created_at", toCreatedAt));
        }
        if (fromUpdatedAt != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("from_updated_at", fromUpdatedAt));
        }
        if (toUpdatedAt != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("to_updated_at", toUpdatedAt));
        }
        if (categoryGuid != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("category_guid", categoryGuid));
        }
        if (categoryGuid2 != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "category_guid[]", categoryGuid2));
        }
        if (topLevelCategoryGuid != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("top_level_category_guid", topLevelCategoryGuid));
        }
        if (topLevelCategoryGuid2 != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "top_level_category_guid[]", topLevelCategoryGuid2));
        }
        if (useCase != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("use_case", useCase));
        }
        if (includes != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("includes", includes));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/vnd.mx.api.v1+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listTransactionsByTagValidateBeforeCall(String userGuid, String tagGuid, Integer page, Integer recordsPerPage, String fromDate, String toDate, String fromCreatedAt, String toCreatedAt, String fromUpdatedAt, String toUpdatedAt, String categoryGuid, List<String> categoryGuid2, String topLevelCategoryGuid, List<String> topLevelCategoryGuid2, String useCase, String includes, ApiCallback _callback) throws ApiException {
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling listTransactionsByTag(Async)");
        }
        if (tagGuid == null) {
            throw new ApiException("Missing the required parameter 'tagGuid' when calling listTransactionsByTag(Async)");
        }
        return this.listTransactionsByTagCall(userGuid, tagGuid, page, recordsPerPage, fromDate, toDate, fromCreatedAt, toCreatedAt, fromUpdatedAt, toUpdatedAt, categoryGuid, categoryGuid2, topLevelCategoryGuid, topLevelCategoryGuid2, useCase, includes, _callback);
    }

    public TransactionsResponseBodyIncludes listTransactionsByTag(String userGuid, String tagGuid, Integer page, Integer recordsPerPage, String fromDate, String toDate, String fromCreatedAt, String toCreatedAt, String fromUpdatedAt, String toUpdatedAt, String categoryGuid, List<String> categoryGuid2, String topLevelCategoryGuid, List<String> topLevelCategoryGuid2, String useCase, String includes) throws ApiException {
        ApiResponse<TransactionsResponseBodyIncludes> localVarResp = this.listTransactionsByTagWithHttpInfo(userGuid, tagGuid, page, recordsPerPage, fromDate, toDate, fromCreatedAt, toCreatedAt, fromUpdatedAt, toUpdatedAt, categoryGuid, categoryGuid2, topLevelCategoryGuid, topLevelCategoryGuid2, useCase, includes);
        return localVarResp.getData();
    }

    public ApiResponse<TransactionsResponseBodyIncludes> listTransactionsByTagWithHttpInfo(String userGuid, String tagGuid, Integer page, Integer recordsPerPage, String fromDate, String toDate, String fromCreatedAt, String toCreatedAt, String fromUpdatedAt, String toUpdatedAt, String categoryGuid, List<String> categoryGuid2, String topLevelCategoryGuid, List<String> topLevelCategoryGuid2, String useCase, String includes) throws ApiException {
        Call localVarCall = this.listTransactionsByTagValidateBeforeCall(userGuid, tagGuid, page, recordsPerPage, fromDate, toDate, fromCreatedAt, toCreatedAt, fromUpdatedAt, toUpdatedAt, categoryGuid, categoryGuid2, topLevelCategoryGuid, topLevelCategoryGuid2, useCase, includes, null);
        Type localVarReturnType = new TypeToken<TransactionsResponseBodyIncludes>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listTransactionsByTagAsync(String userGuid, String tagGuid, Integer page, Integer recordsPerPage, String fromDate, String toDate, String fromCreatedAt, String toCreatedAt, String fromUpdatedAt, String toUpdatedAt, String categoryGuid, List<String> categoryGuid2, String topLevelCategoryGuid, List<String> topLevelCategoryGuid2, String useCase, String includes, ApiCallback<TransactionsResponseBodyIncludes> _callback) throws ApiException {
        Call localVarCall = this.listTransactionsByTagValidateBeforeCall(userGuid, tagGuid, page, recordsPerPage, fromDate, toDate, fromCreatedAt, toCreatedAt, fromUpdatedAt, toUpdatedAt, categoryGuid, categoryGuid2, topLevelCategoryGuid, topLevelCategoryGuid2, useCase, includes, _callback);
        Type localVarReturnType = new TypeToken<TransactionsResponseBodyIncludes>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readTransactionCall(String userGuid, String transactionGuid, String includes, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/users/{user_guid}/transactions/{transaction_guid}".replace("{user_guid}", this.localVarApiClient.escapeString(userGuid.toString())).replace("{transaction_guid}", this.localVarApiClient.escapeString(transactionGuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (includes != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("includes", includes));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/vnd.mx.api.v1+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readTransactionValidateBeforeCall(String userGuid, String transactionGuid, String includes, ApiCallback _callback) throws ApiException {
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling readTransaction(Async)");
        }
        if (transactionGuid == null) {
            throw new ApiException("Missing the required parameter 'transactionGuid' when calling readTransaction(Async)");
        }
        return this.readTransactionCall(userGuid, transactionGuid, includes, _callback);
    }

    public TransactionsResponseBodyIncludes readTransaction(String userGuid, String transactionGuid, String includes) throws ApiException {
        ApiResponse<TransactionsResponseBodyIncludes> localVarResp = this.readTransactionWithHttpInfo(userGuid, transactionGuid, includes);
        return localVarResp.getData();
    }

    public ApiResponse<TransactionsResponseBodyIncludes> readTransactionWithHttpInfo(String userGuid, String transactionGuid, String includes) throws ApiException {
        Call localVarCall = this.readTransactionValidateBeforeCall(userGuid, transactionGuid, includes, null);
        Type localVarReturnType = new TypeToken<TransactionsResponseBodyIncludes>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readTransactionAsync(String userGuid, String transactionGuid, String includes, ApiCallback<TransactionsResponseBodyIncludes> _callback) throws ApiException {
        Call localVarCall = this.readTransactionValidateBeforeCall(userGuid, transactionGuid, includes, _callback);
        Type localVarReturnType = new TypeToken<TransactionsResponseBodyIncludes>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call repeatingTransactionsCall(String userGuid, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/users/{user_guid}/repeating_transactions".replace("{user_guid}", this.localVarApiClient.escapeString(userGuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.mx.api.v1+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call repeatingTransactionsValidateBeforeCall(String userGuid, ApiCallback _callback) throws ApiException {
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling repeatingTransactions(Async)");
        }
        return this.repeatingTransactionsCall(userGuid, _callback);
    }

    public RepeatingTransactionsResponseBody repeatingTransactions(String userGuid) throws ApiException {
        ApiResponse<RepeatingTransactionsResponseBody> localVarResp = this.repeatingTransactionsWithHttpInfo(userGuid);
        return localVarResp.getData();
    }

    public ApiResponse<RepeatingTransactionsResponseBody> repeatingTransactionsWithHttpInfo(String userGuid) throws ApiException {
        Call localVarCall = this.repeatingTransactionsValidateBeforeCall(userGuid, null);
        Type localVarReturnType = new TypeToken<RepeatingTransactionsResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call repeatingTransactionsAsync(String userGuid, ApiCallback<RepeatingTransactionsResponseBody> _callback) throws ApiException {
        Call localVarCall = this.repeatingTransactionsValidateBeforeCall(userGuid, _callback);
        Type localVarReturnType = new TypeToken<RepeatingTransactionsResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call specificRepeatingTransactionCall(String userGuid, String repeatingTransactionGuid, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/users/{user_guid}/repeating_transactions/{repeating_transaction_guid}".replace("{user_guid}", this.localVarApiClient.escapeString(userGuid.toString())).replace("{repeating_transaction_guid}", this.localVarApiClient.escapeString(repeatingTransactionGuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.mx.api.v1+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call specificRepeatingTransactionValidateBeforeCall(String userGuid, String repeatingTransactionGuid, ApiCallback _callback) throws ApiException {
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling specificRepeatingTransaction(Async)");
        }
        if (repeatingTransactionGuid == null) {
            throw new ApiException("Missing the required parameter 'repeatingTransactionGuid' when calling specificRepeatingTransaction(Async)");
        }
        return this.specificRepeatingTransactionCall(userGuid, repeatingTransactionGuid, _callback);
    }

    public RepeatingTransactionsResponseBody specificRepeatingTransaction(String userGuid, String repeatingTransactionGuid) throws ApiException {
        ApiResponse<RepeatingTransactionsResponseBody> localVarResp = this.specificRepeatingTransactionWithHttpInfo(userGuid, repeatingTransactionGuid);
        return localVarResp.getData();
    }

    public ApiResponse<RepeatingTransactionsResponseBody> specificRepeatingTransactionWithHttpInfo(String userGuid, String repeatingTransactionGuid) throws ApiException {
        Call localVarCall = this.specificRepeatingTransactionValidateBeforeCall(userGuid, repeatingTransactionGuid, null);
        Type localVarReturnType = new TypeToken<RepeatingTransactionsResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call specificRepeatingTransactionAsync(String userGuid, String repeatingTransactionGuid, ApiCallback<RepeatingTransactionsResponseBody> _callback) throws ApiException {
        Call localVarCall = this.specificRepeatingTransactionValidateBeforeCall(userGuid, repeatingTransactionGuid, _callback);
        Type localVarReturnType = new TypeToken<RepeatingTransactionsResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateTransactionCall(String userGuid, String transactionGuid, TransactionUpdateRequestBody transactionUpdateRequestBody, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        TransactionUpdateRequestBody localVarPostBody = transactionUpdateRequestBody;
        String localVarPath = "/users/{user_guid}/transactions/{transaction_guid}".replace("{user_guid}", this.localVarApiClient.escapeString(userGuid.toString())).replace("{transaction_guid}", this.localVarApiClient.escapeString(transactionGuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.mx.api.v1+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateTransactionValidateBeforeCall(String userGuid, String transactionGuid, TransactionUpdateRequestBody transactionUpdateRequestBody, ApiCallback _callback) throws ApiException {
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling updateTransaction(Async)");
        }
        if (transactionGuid == null) {
            throw new ApiException("Missing the required parameter 'transactionGuid' when calling updateTransaction(Async)");
        }
        if (transactionUpdateRequestBody == null) {
            throw new ApiException("Missing the required parameter 'transactionUpdateRequestBody' when calling updateTransaction(Async)");
        }
        return this.updateTransactionCall(userGuid, transactionGuid, transactionUpdateRequestBody, _callback);
    }

    public TransactionResponseBody updateTransaction(String userGuid, String transactionGuid, TransactionUpdateRequestBody transactionUpdateRequestBody) throws ApiException {
        ApiResponse<TransactionResponseBody> localVarResp = this.updateTransactionWithHttpInfo(userGuid, transactionGuid, transactionUpdateRequestBody);
        return localVarResp.getData();
    }

    public ApiResponse<TransactionResponseBody> updateTransactionWithHttpInfo(String userGuid, String transactionGuid, TransactionUpdateRequestBody transactionUpdateRequestBody) throws ApiException {
        Call localVarCall = this.updateTransactionValidateBeforeCall(userGuid, transactionGuid, transactionUpdateRequestBody, null);
        Type localVarReturnType = new TypeToken<TransactionResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateTransactionAsync(String userGuid, String transactionGuid, TransactionUpdateRequestBody transactionUpdateRequestBody, ApiCallback<TransactionResponseBody> _callback) throws ApiException {
        Call localVarCall = this.updateTransactionValidateBeforeCall(userGuid, transactionGuid, transactionUpdateRequestBody, _callback);
        Type localVarReturnType = new TypeToken<TransactionResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateTransactionByAccountCall(String userGuid, String memberGuid, String accountGuid, String transactionGuid, TransactionUpdateRequestBody transactionUpdateRequestBody, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        TransactionUpdateRequestBody localVarPostBody = transactionUpdateRequestBody;
        String localVarPath = "/users/{user_guid}/members/{member_guid}/accounts/{account_guid}/transactions/{transaction_guid}".replace("{user_guid}", this.localVarApiClient.escapeString(userGuid.toString())).replace("{member_guid}", this.localVarApiClient.escapeString(memberGuid.toString())).replace("{account_guid}", this.localVarApiClient.escapeString(accountGuid.toString())).replace("{transaction_guid}", this.localVarApiClient.escapeString(transactionGuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateTransactionByAccountValidateBeforeCall(String userGuid, String memberGuid, String accountGuid, String transactionGuid, TransactionUpdateRequestBody transactionUpdateRequestBody, ApiCallback _callback) throws ApiException {
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling updateTransactionByAccount(Async)");
        }
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling updateTransactionByAccount(Async)");
        }
        if (accountGuid == null) {
            throw new ApiException("Missing the required parameter 'accountGuid' when calling updateTransactionByAccount(Async)");
        }
        if (transactionGuid == null) {
            throw new ApiException("Missing the required parameter 'transactionGuid' when calling updateTransactionByAccount(Async)");
        }
        if (transactionUpdateRequestBody == null) {
            throw new ApiException("Missing the required parameter 'transactionUpdateRequestBody' when calling updateTransactionByAccount(Async)");
        }
        return this.updateTransactionByAccountCall(userGuid, memberGuid, accountGuid, transactionGuid, transactionUpdateRequestBody, _callback);
    }

    public TransactionResponseBody updateTransactionByAccount(String userGuid, String memberGuid, String accountGuid, String transactionGuid, TransactionUpdateRequestBody transactionUpdateRequestBody) throws ApiException {
        ApiResponse<TransactionResponseBody> localVarResp = this.updateTransactionByAccountWithHttpInfo(userGuid, memberGuid, accountGuid, transactionGuid, transactionUpdateRequestBody);
        return localVarResp.getData();
    }

    public ApiResponse<TransactionResponseBody> updateTransactionByAccountWithHttpInfo(String userGuid, String memberGuid, String accountGuid, String transactionGuid, TransactionUpdateRequestBody transactionUpdateRequestBody) throws ApiException {
        Call localVarCall = this.updateTransactionByAccountValidateBeforeCall(userGuid, memberGuid, accountGuid, transactionGuid, transactionUpdateRequestBody, null);
        Type localVarReturnType = new TypeToken<TransactionResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateTransactionByAccountAsync(String userGuid, String memberGuid, String accountGuid, String transactionGuid, TransactionUpdateRequestBody transactionUpdateRequestBody, ApiCallback<TransactionResponseBody> _callback) throws ApiException {
        Call localVarCall = this.updateTransactionByAccountValidateBeforeCall(userGuid, memberGuid, accountGuid, transactionGuid, transactionUpdateRequestBody, _callback);
        Type localVarReturnType = new TypeToken<TransactionResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

