/*
 * MX Platform API
 * The MX Platform API is a powerful, fully-featured API designed to make aggregating and enhancing financial data easy and reliable. It can seamlessly connect your app or website to tens of thousands of financial institutions.
 *
 * The version of the OpenAPI document: 0.1.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.mx.client.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Arrays;
import org.openapitools.jackson.nullable.JsonNullable;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.mx.client.JSON;

/**
 * BudgetResponse
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class BudgetResponse {
  public static final String SERIALIZED_NAME_AMOUNT = "amount";
  @SerializedName(SERIALIZED_NAME_AMOUNT)
  private BigDecimal amount;

  public static final String SERIALIZED_NAME_CATEGORY_GUID = "category_guid";
  @SerializedName(SERIALIZED_NAME_CATEGORY_GUID)
  private String categoryGuid;

  public static final String SERIALIZED_NAME_CREATED_AT = "created_at";
  @SerializedName(SERIALIZED_NAME_CREATED_AT)
  private String createdAt;

  public static final String SERIALIZED_NAME_GUID = "guid";
  @SerializedName(SERIALIZED_NAME_GUID)
  private String guid;

  public static final String SERIALIZED_NAME_IS_EXCEEDED = "is_exceeded";
  @SerializedName(SERIALIZED_NAME_IS_EXCEEDED)
  private Boolean isExceeded;

  public static final String SERIALIZED_NAME_IS_OFF_TRACK = "is_off_track";
  @SerializedName(SERIALIZED_NAME_IS_OFF_TRACK)
  private Boolean isOffTrack;

  public static final String SERIALIZED_NAME_METADATA = "metadata";
  @SerializedName(SERIALIZED_NAME_METADATA)
  private String metadata;

  public static final String SERIALIZED_NAME_NAME = "name";
  @SerializedName(SERIALIZED_NAME_NAME)
  private String name;

  public static final String SERIALIZED_NAME_OFF_TRACK_PERCENTAGE = "off_track_percentage";
  @SerializedName(SERIALIZED_NAME_OFF_TRACK_PERCENTAGE)
  private BigDecimal offTrackPercentage;

  public static final String SERIALIZED_NAME_PARENT_GUID = "parent_guid";
  @SerializedName(SERIALIZED_NAME_PARENT_GUID)
  private String parentGuid;

  public static final String SERIALIZED_NAME_PERCENT_SPENT = "percent_spent";
  @SerializedName(SERIALIZED_NAME_PERCENT_SPENT)
  private BigDecimal percentSpent;

  public static final String SERIALIZED_NAME_PROJECTED_SPENDING = "projected_spending";
  @SerializedName(SERIALIZED_NAME_PROJECTED_SPENDING)
  private BigDecimal projectedSpending;

  public static final String SERIALIZED_NAME_REVISION = "revision";
  @SerializedName(SERIALIZED_NAME_REVISION)
  private Integer revision;

  public static final String SERIALIZED_NAME_TRANSACTION_TOTAL = "transaction_total";
  @SerializedName(SERIALIZED_NAME_TRANSACTION_TOTAL)
  private Object transactionTotal = null;

  public static final String SERIALIZED_NAME_UPDATED_AT = "updated_at";
  @SerializedName(SERIALIZED_NAME_UPDATED_AT)
  private Object updatedAt = null;

  public static final String SERIALIZED_NAME_USER_GUID = "user_guid";
  @SerializedName(SERIALIZED_NAME_USER_GUID)
  private Object userGuid = null;

  public BudgetResponse() {
  }

  public BudgetResponse amount(BigDecimal amount) {
    
    this.amount = amount;
    return this;
  }

   /**
   * A goal amount set by the user for a category&#39;s transaction total during a month.
   * @return amount
  **/
  @javax.annotation.Nullable
  public BigDecimal getAmount() {
    return amount;
  }


  public void setAmount(BigDecimal amount) {
    this.amount = amount;
  }


  public BudgetResponse categoryGuid(String categoryGuid) {
    
    this.categoryGuid = categoryGuid;
    return this;
  }

   /**
   * Unique identifier for the budget category. Defined by MX.
   * @return categoryGuid
  **/
  @javax.annotation.Nullable
  public String getCategoryGuid() {
    return categoryGuid;
  }


  public void setCategoryGuid(String categoryGuid) {
    this.categoryGuid = categoryGuid;
  }


  public BudgetResponse createdAt(String createdAt) {
    
    this.createdAt = createdAt;
    return this;
  }

   /**
   * Date and time the budget was created, represented in ISO 8601 format with timestamp.
   * @return createdAt
  **/
  @javax.annotation.Nullable
  public String getCreatedAt() {
    return createdAt;
  }


  public void setCreatedAt(String createdAt) {
    this.createdAt = createdAt;
  }


  public BudgetResponse guid(String guid) {
    
    this.guid = guid;
    return this;
  }

   /**
   * Unique identifier for the budget. Defined by MX.
   * @return guid
  **/
  @javax.annotation.Nullable
  public String getGuid() {
    return guid;
  }


  public void setGuid(String guid) {
    this.guid = guid;
  }


  public BudgetResponse isExceeded(Boolean isExceeded) {
    
    this.isExceeded = isExceeded;
    return this;
  }

   /**
   * If the budget has been exceeded, this field will be true. Otherwise, this field will be false.
   * @return isExceeded
  **/
  @javax.annotation.Nullable
  public Boolean getIsExceeded() {
    return isExceeded;
  }


  public void setIsExceeded(Boolean isExceeded) {
    this.isExceeded = isExceeded;
  }


  public BudgetResponse isOffTrack(Boolean isOffTrack) {
    
    this.isOffTrack = isOffTrack;
    return this;
  }

   /**
   * If the budget is off track, this field will be true. Otherwise, this field will be false.
   * @return isOffTrack
  **/
  @javax.annotation.Nullable
  public Boolean getIsOffTrack() {
    return isOffTrack;
  }


  public void setIsOffTrack(Boolean isOffTrack) {
    this.isOffTrack = isOffTrack;
  }


  public BudgetResponse metadata(String metadata) {
    
    this.metadata = metadata;
    return this;
  }

   /**
   * Additional information a partner can store on the budget.
   * @return metadata
  **/
  @javax.annotation.Nullable
  public String getMetadata() {
    return metadata;
  }


  public void setMetadata(String metadata) {
    this.metadata = metadata;
  }


  public BudgetResponse name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * The name of the budget that is visible to the user (ie \&quot;Food\&quot;, \&quot;Bills\&quot;, \&quot;Entertainment\&quot;, etc).
   * @return name
  **/
  @javax.annotation.Nullable
  public String getName() {
    return name;
  }


  public void setName(String name) {
    this.name = name;
  }


  public BudgetResponse offTrackPercentage(BigDecimal offTrackPercentage) {
    
    this.offTrackPercentage = offTrackPercentage;
    return this;
  }

   /**
   * The percentage amount of off track spending. (Deprecated).
   * @return offTrackPercentage
  **/
  @javax.annotation.Nullable
  public BigDecimal getOffTrackPercentage() {
    return offTrackPercentage;
  }


  public void setOffTrackPercentage(BigDecimal offTrackPercentage) {
    this.offTrackPercentage = offTrackPercentage;
  }


  public BudgetResponse parentGuid(String parentGuid) {
    
    this.parentGuid = parentGuid;
    return this;
  }

   /**
   * Unique identifier for the parent budget. Defined by MX.
   * @return parentGuid
  **/
  @javax.annotation.Nullable
  public String getParentGuid() {
    return parentGuid;
  }


  public void setParentGuid(String parentGuid) {
    this.parentGuid = parentGuid;
  }


  public BudgetResponse percentSpent(BigDecimal percentSpent) {
    
    this.percentSpent = percentSpent;
    return this;
  }

   /**
   * The percentage of a budget that has been spent during the current calendar month Calculated as the transaction total divided by the amount and then multiplied by 100.A value of zero will be returned when &#x60;amount&#x60; is zero.
   * @return percentSpent
  **/
  @javax.annotation.Nullable
  public BigDecimal getPercentSpent() {
    return percentSpent;
  }


  public void setPercentSpent(BigDecimal percentSpent) {
    this.percentSpent = percentSpent;
  }


  public BudgetResponse projectedSpending(BigDecimal projectedSpending) {
    
    this.projectedSpending = projectedSpending;
    return this;
  }

   /**
   * The projected amount of spending for the budget.
   * @return projectedSpending
  **/
  @javax.annotation.Nullable
  public BigDecimal getProjectedSpending() {
    return projectedSpending;
  }


  public void setProjectedSpending(BigDecimal projectedSpending) {
    this.projectedSpending = projectedSpending;
  }


  public BudgetResponse revision(Integer revision) {
    
    this.revision = revision;
    return this;
  }

   /**
   * The revision number of this budget record.
   * @return revision
  **/
  @javax.annotation.Nullable
  public Integer getRevision() {
    return revision;
  }


  public void setRevision(Integer revision) {
    this.revision = revision;
  }


  public BudgetResponse transactionTotal(Object transactionTotal) {
    
    this.transactionTotal = transactionTotal;
    return this;
  }

   /**
   * The cumulative amount of all transactions under the budget.
   * @return transactionTotal
  **/
  @javax.annotation.Nullable
  public Object getTransactionTotal() {
    return transactionTotal;
  }


  public void setTransactionTotal(Object transactionTotal) {
    this.transactionTotal = transactionTotal;
  }


  public BudgetResponse updatedAt(Object updatedAt) {
    
    this.updatedAt = updatedAt;
    return this;
  }

   /**
   * Date and time the budget was updated, represented in ISO 8601 format with timestamp.
   * @return updatedAt
  **/
  @javax.annotation.Nullable
  public Object getUpdatedAt() {
    return updatedAt;
  }


  public void setUpdatedAt(Object updatedAt) {
    this.updatedAt = updatedAt;
  }


  public BudgetResponse userGuid(Object userGuid) {
    
    this.userGuid = userGuid;
    return this;
  }

   /**
   * Unique identifier for the user. Defined by MX.
   * @return userGuid
  **/
  @javax.annotation.Nullable
  public Object getUserGuid() {
    return userGuid;
  }


  public void setUserGuid(Object userGuid) {
    this.userGuid = userGuid;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BudgetResponse budgetResponse = (BudgetResponse) o;
    return Objects.equals(this.amount, budgetResponse.amount) &&
        Objects.equals(this.categoryGuid, budgetResponse.categoryGuid) &&
        Objects.equals(this.createdAt, budgetResponse.createdAt) &&
        Objects.equals(this.guid, budgetResponse.guid) &&
        Objects.equals(this.isExceeded, budgetResponse.isExceeded) &&
        Objects.equals(this.isOffTrack, budgetResponse.isOffTrack) &&
        Objects.equals(this.metadata, budgetResponse.metadata) &&
        Objects.equals(this.name, budgetResponse.name) &&
        Objects.equals(this.offTrackPercentage, budgetResponse.offTrackPercentage) &&
        Objects.equals(this.parentGuid, budgetResponse.parentGuid) &&
        Objects.equals(this.percentSpent, budgetResponse.percentSpent) &&
        Objects.equals(this.projectedSpending, budgetResponse.projectedSpending) &&
        Objects.equals(this.revision, budgetResponse.revision) &&
        Objects.equals(this.transactionTotal, budgetResponse.transactionTotal) &&
        Objects.equals(this.updatedAt, budgetResponse.updatedAt) &&
        Objects.equals(this.userGuid, budgetResponse.userGuid);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(amount, categoryGuid, createdAt, guid, isExceeded, isOffTrack, metadata, name, offTrackPercentage, parentGuid, percentSpent, projectedSpending, revision, transactionTotal, updatedAt, userGuid);
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BudgetResponse {\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    categoryGuid: ").append(toIndentedString(categoryGuid)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    guid: ").append(toIndentedString(guid)).append("\n");
    sb.append("    isExceeded: ").append(toIndentedString(isExceeded)).append("\n");
    sb.append("    isOffTrack: ").append(toIndentedString(isOffTrack)).append("\n");
    sb.append("    metadata: ").append(toIndentedString(metadata)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    offTrackPercentage: ").append(toIndentedString(offTrackPercentage)).append("\n");
    sb.append("    parentGuid: ").append(toIndentedString(parentGuid)).append("\n");
    sb.append("    percentSpent: ").append(toIndentedString(percentSpent)).append("\n");
    sb.append("    projectedSpending: ").append(toIndentedString(projectedSpending)).append("\n");
    sb.append("    revision: ").append(toIndentedString(revision)).append("\n");
    sb.append("    transactionTotal: ").append(toIndentedString(transactionTotal)).append("\n");
    sb.append("    updatedAt: ").append(toIndentedString(updatedAt)).append("\n");
    sb.append("    userGuid: ").append(toIndentedString(userGuid)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("amount");
    openapiFields.add("category_guid");
    openapiFields.add("created_at");
    openapiFields.add("guid");
    openapiFields.add("is_exceeded");
    openapiFields.add("is_off_track");
    openapiFields.add("metadata");
    openapiFields.add("name");
    openapiFields.add("off_track_percentage");
    openapiFields.add("parent_guid");
    openapiFields.add("percent_spent");
    openapiFields.add("projected_spending");
    openapiFields.add("revision");
    openapiFields.add("transaction_total");
    openapiFields.add("updated_at");
    openapiFields.add("user_guid");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 /**
  * Validates the JSON Element and throws an exception if issues found
  *
  * @param jsonElement JSON Element
  * @throws IOException if the JSON Element is invalid with respect to BudgetResponse
  */
  public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (jsonElement == null) {
        if (!BudgetResponse.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in BudgetResponse is not found in the empty JSON string", BudgetResponse.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!BudgetResponse.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `BudgetResponse` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
      if ((jsonObj.get("category_guid") != null && !jsonObj.get("category_guid").isJsonNull()) && !jsonObj.get("category_guid").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `category_guid` to be a primitive type in the JSON string but got `%s`", jsonObj.get("category_guid").toString()));
      }
      if ((jsonObj.get("created_at") != null && !jsonObj.get("created_at").isJsonNull()) && !jsonObj.get("created_at").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `created_at` to be a primitive type in the JSON string but got `%s`", jsonObj.get("created_at").toString()));
      }
      if ((jsonObj.get("guid") != null && !jsonObj.get("guid").isJsonNull()) && !jsonObj.get("guid").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `guid` to be a primitive type in the JSON string but got `%s`", jsonObj.get("guid").toString()));
      }
      if ((jsonObj.get("metadata") != null && !jsonObj.get("metadata").isJsonNull()) && !jsonObj.get("metadata").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `metadata` to be a primitive type in the JSON string but got `%s`", jsonObj.get("metadata").toString()));
      }
      if ((jsonObj.get("name") != null && !jsonObj.get("name").isJsonNull()) && !jsonObj.get("name").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("name").toString()));
      }
      if ((jsonObj.get("parent_guid") != null && !jsonObj.get("parent_guid").isJsonNull()) && !jsonObj.get("parent_guid").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `parent_guid` to be a primitive type in the JSON string but got `%s`", jsonObj.get("parent_guid").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!BudgetResponse.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'BudgetResponse' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<BudgetResponse> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(BudgetResponse.class));

       return (TypeAdapter<T>) new TypeAdapter<BudgetResponse>() {
           @Override
           public void write(JsonWriter out, BudgetResponse value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public BudgetResponse read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of BudgetResponse given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of BudgetResponse
  * @throws IOException if the JSON string is invalid with respect to BudgetResponse
  */
  public static BudgetResponse fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, BudgetResponse.class);
  }

 /**
  * Convert an instance of BudgetResponse to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

