/*
 * MX Platform API
 * The MX Platform API is a powerful, fully-featured API designed to make aggregating and enhancing financial data easy and reliable. It can seamlessly connect your app or website to tens of thousands of financial institutions.
 *
 * The version of the OpenAPI document: 0.1.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.mx.client.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.mx.client.model.CredentialRequest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.mx.client.JSON;

/**
 * MemberCreateRequest
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class MemberCreateRequest {
  public static final String SERIALIZED_NAME_BACKGROUND_AGGREGATION_IS_DISABLED = "background_aggregation_is_disabled";
  @SerializedName(SERIALIZED_NAME_BACKGROUND_AGGREGATION_IS_DISABLED)
  private Boolean backgroundAggregationIsDisabled;

  public static final String SERIALIZED_NAME_CREDENTIALS = "credentials";
  @SerializedName(SERIALIZED_NAME_CREDENTIALS)
  private List<CredentialRequest> credentials = new ArrayList<>();

  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private String id;

  public static final String SERIALIZED_NAME_INSTITUTION_CODE = "institution_code";
  @SerializedName(SERIALIZED_NAME_INSTITUTION_CODE)
  private String institutionCode;

  public static final String SERIALIZED_NAME_IS_OAUTH = "is_oauth";
  @SerializedName(SERIALIZED_NAME_IS_OAUTH)
  private Boolean isOauth;

  public static final String SERIALIZED_NAME_METADATA = "metadata";
  @SerializedName(SERIALIZED_NAME_METADATA)
  private String metadata;

  public static final String SERIALIZED_NAME_SKIP_AGGREGATION = "skip_aggregation";
  @SerializedName(SERIALIZED_NAME_SKIP_AGGREGATION)
  private Boolean skipAggregation;

  public MemberCreateRequest() {
  }

  public MemberCreateRequest backgroundAggregationIsDisabled(Boolean backgroundAggregationIsDisabled) {
    
    this.backgroundAggregationIsDisabled = backgroundAggregationIsDisabled;
    return this;
  }

   /**
   * Get backgroundAggregationIsDisabled
   * @return backgroundAggregationIsDisabled
  **/
  @javax.annotation.Nullable
  public Boolean getBackgroundAggregationIsDisabled() {
    return backgroundAggregationIsDisabled;
  }


  public void setBackgroundAggregationIsDisabled(Boolean backgroundAggregationIsDisabled) {
    this.backgroundAggregationIsDisabled = backgroundAggregationIsDisabled;
  }


  public MemberCreateRequest credentials(List<CredentialRequest> credentials) {
    
    this.credentials = credentials;
    return this;
  }

  public MemberCreateRequest addCredentialsItem(CredentialRequest credentialsItem) {
    if (this.credentials == null) {
      this.credentials = new ArrayList<>();
    }
    this.credentials.add(credentialsItem);
    return this;
  }

   /**
   * Get credentials
   * @return credentials
  **/
  @javax.annotation.Nonnull
  public List<CredentialRequest> getCredentials() {
    return credentials;
  }


  public void setCredentials(List<CredentialRequest> credentials) {
    this.credentials = credentials;
  }


  public MemberCreateRequest id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * Get id
   * @return id
  **/
  @javax.annotation.Nullable
  public String getId() {
    return id;
  }


  public void setId(String id) {
    this.id = id;
  }


  public MemberCreateRequest institutionCode(String institutionCode) {
    
    this.institutionCode = institutionCode;
    return this;
  }

   /**
   * Get institutionCode
   * @return institutionCode
  **/
  @javax.annotation.Nonnull
  public String getInstitutionCode() {
    return institutionCode;
  }


  public void setInstitutionCode(String institutionCode) {
    this.institutionCode = institutionCode;
  }


  public MemberCreateRequest isOauth(Boolean isOauth) {
    
    this.isOauth = isOauth;
    return this;
  }

   /**
   * Get isOauth
   * @return isOauth
  **/
  @javax.annotation.Nullable
  public Boolean getIsOauth() {
    return isOauth;
  }


  public void setIsOauth(Boolean isOauth) {
    this.isOauth = isOauth;
  }


  public MemberCreateRequest metadata(String metadata) {
    
    this.metadata = metadata;
    return this;
  }

   /**
   * Get metadata
   * @return metadata
  **/
  @javax.annotation.Nullable
  public String getMetadata() {
    return metadata;
  }


  public void setMetadata(String metadata) {
    this.metadata = metadata;
  }


  public MemberCreateRequest skipAggregation(Boolean skipAggregation) {
    
    this.skipAggregation = skipAggregation;
    return this;
  }

   /**
   * Get skipAggregation
   * @return skipAggregation
  **/
  @javax.annotation.Nullable
  public Boolean getSkipAggregation() {
    return skipAggregation;
  }


  public void setSkipAggregation(Boolean skipAggregation) {
    this.skipAggregation = skipAggregation;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MemberCreateRequest memberCreateRequest = (MemberCreateRequest) o;
    return Objects.equals(this.backgroundAggregationIsDisabled, memberCreateRequest.backgroundAggregationIsDisabled) &&
        Objects.equals(this.credentials, memberCreateRequest.credentials) &&
        Objects.equals(this.id, memberCreateRequest.id) &&
        Objects.equals(this.institutionCode, memberCreateRequest.institutionCode) &&
        Objects.equals(this.isOauth, memberCreateRequest.isOauth) &&
        Objects.equals(this.metadata, memberCreateRequest.metadata) &&
        Objects.equals(this.skipAggregation, memberCreateRequest.skipAggregation);
  }

  @Override
  public int hashCode() {
    return Objects.hash(backgroundAggregationIsDisabled, credentials, id, institutionCode, isOauth, metadata, skipAggregation);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MemberCreateRequest {\n");
    sb.append("    backgroundAggregationIsDisabled: ").append(toIndentedString(backgroundAggregationIsDisabled)).append("\n");
    sb.append("    credentials: ").append(toIndentedString(credentials)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    institutionCode: ").append(toIndentedString(institutionCode)).append("\n");
    sb.append("    isOauth: ").append(toIndentedString(isOauth)).append("\n");
    sb.append("    metadata: ").append(toIndentedString(metadata)).append("\n");
    sb.append("    skipAggregation: ").append(toIndentedString(skipAggregation)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("background_aggregation_is_disabled");
    openapiFields.add("credentials");
    openapiFields.add("id");
    openapiFields.add("institution_code");
    openapiFields.add("is_oauth");
    openapiFields.add("metadata");
    openapiFields.add("skip_aggregation");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("credentials");
    openapiRequiredFields.add("institution_code");
  }

 /**
  * Validates the JSON Element and throws an exception if issues found
  *
  * @param jsonElement JSON Element
  * @throws IOException if the JSON Element is invalid with respect to MemberCreateRequest
  */
  public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (jsonElement == null) {
        if (!MemberCreateRequest.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in MemberCreateRequest is not found in the empty JSON string", MemberCreateRequest.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!MemberCreateRequest.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `MemberCreateRequest` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : MemberCreateRequest.openapiRequiredFields) {
        if (jsonElement.getAsJsonObject().get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
      // ensure the json data is an array
      if (!jsonObj.get("credentials").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `credentials` to be an array in the JSON string but got `%s`", jsonObj.get("credentials").toString()));
      }

      JsonArray jsonArraycredentials = jsonObj.getAsJsonArray("credentials");
      // validate the required field `credentials` (array)
      for (int i = 0; i < jsonArraycredentials.size(); i++) {
        CredentialRequest.validateJsonElement(jsonArraycredentials.get(i));
      };
      if ((jsonObj.get("id") != null && !jsonObj.get("id").isJsonNull()) && !jsonObj.get("id").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("id").toString()));
      }
      if (!jsonObj.get("institution_code").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `institution_code` to be a primitive type in the JSON string but got `%s`", jsonObj.get("institution_code").toString()));
      }
      if ((jsonObj.get("metadata") != null && !jsonObj.get("metadata").isJsonNull()) && !jsonObj.get("metadata").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `metadata` to be a primitive type in the JSON string but got `%s`", jsonObj.get("metadata").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!MemberCreateRequest.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'MemberCreateRequest' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<MemberCreateRequest> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(MemberCreateRequest.class));

       return (TypeAdapter<T>) new TypeAdapter<MemberCreateRequest>() {
           @Override
           public void write(JsonWriter out, MemberCreateRequest value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public MemberCreateRequest read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of MemberCreateRequest given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of MemberCreateRequest
  * @throws IOException if the JSON string is invalid with respect to MemberCreateRequest
  */
  public static MemberCreateRequest fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, MemberCreateRequest.class);
  }

 /**
  * Convert an instance of MemberCreateRequest to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

