/*
 * MX Platform API
 * The MX Platform API is a powerful, fully-featured API designed to make aggregating and enhancing financial data easy and reliable. It can seamlessly connect your app or website to tens of thousands of financial institutions.
 *
 * The version of the OpenAPI document: 0.1.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.mx.client.mx_platform_api;

import com.mx.client.ApiCallback;
import com.mx.client.ApiClient;
import com.mx.client.ApiException;
import com.mx.client.ApiResponse;
import com.mx.client.Configuration;
import com.mx.client.Pair;
import com.mx.client.ProgressRequestBody;
import com.mx.client.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import com.mx.client.model.BudgetCreateRequestBody;
import com.mx.client.model.BudgetResponseBody;
import com.mx.client.model.BudgetUpdateRequestBody;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BudgetsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public BudgetsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public BudgetsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    /**
     * Build call for usersUserGuidBudgetsBudgetGuidDelete
     * @param userGuid The unique identifier for the budget. Defined by MX. (required)
     * @param budgetGuid The unique identifier for the budget. Defined by MX. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No content </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call usersUserGuidBudgetsBudgetGuidDeleteCall(String userGuid, String budgetGuid, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/budgets/{budget_guid}"
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()))
            .replace("{" + "budget_guid" + "}", localVarApiClient.escapeString(budgetGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call usersUserGuidBudgetsBudgetGuidDeleteValidateBeforeCall(String userGuid, String budgetGuid, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling usersUserGuidBudgetsBudgetGuidDelete(Async)");
        }

        // verify the required parameter 'budgetGuid' is set
        if (budgetGuid == null) {
            throw new ApiException("Missing the required parameter 'budgetGuid' when calling usersUserGuidBudgetsBudgetGuidDelete(Async)");
        }

        return usersUserGuidBudgetsBudgetGuidDeleteCall(userGuid, budgetGuid, _callback);

    }

    /**
     * Delete a budget
     * Delete a budget.
     * @param userGuid The unique identifier for the budget. Defined by MX. (required)
     * @param budgetGuid The unique identifier for the budget. Defined by MX. (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No content </td><td>  -  </td></tr>
     </table>
     */
    public void usersUserGuidBudgetsBudgetGuidDelete(String userGuid, String budgetGuid) throws ApiException {
        usersUserGuidBudgetsBudgetGuidDeleteWithHttpInfo(userGuid, budgetGuid);
    }

    /**
     * Delete a budget
     * Delete a budget.
     * @param userGuid The unique identifier for the budget. Defined by MX. (required)
     * @param budgetGuid The unique identifier for the budget. Defined by MX. (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No content </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> usersUserGuidBudgetsBudgetGuidDeleteWithHttpInfo(String userGuid, String budgetGuid) throws ApiException {
        okhttp3.Call localVarCall = usersUserGuidBudgetsBudgetGuidDeleteValidateBeforeCall(userGuid, budgetGuid, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Delete a budget (asynchronously)
     * Delete a budget.
     * @param userGuid The unique identifier for the budget. Defined by MX. (required)
     * @param budgetGuid The unique identifier for the budget. Defined by MX. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No content </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call usersUserGuidBudgetsBudgetGuidDeleteAsync(String userGuid, String budgetGuid, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = usersUserGuidBudgetsBudgetGuidDeleteValidateBeforeCall(userGuid, budgetGuid, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for usersUserGuidBudgetsBudgetGuidGet
     * @param budgetGuid The unique identifier for the budget. Defined by MX. (required)
     * @param userGuid The unique identifier for the budget. Defined by MX. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call usersUserGuidBudgetsBudgetGuidGetCall(String budgetGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/budgets/{budget_guid}"
            .replace("{" + "budget_guid" + "}", localVarApiClient.escapeString(budgetGuid.toString()))
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call usersUserGuidBudgetsBudgetGuidGetValidateBeforeCall(String budgetGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'budgetGuid' is set
        if (budgetGuid == null) {
            throw new ApiException("Missing the required parameter 'budgetGuid' when calling usersUserGuidBudgetsBudgetGuidGet(Async)");
        }

        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling usersUserGuidBudgetsBudgetGuidGet(Async)");
        }

        return usersUserGuidBudgetsBudgetGuidGetCall(budgetGuid, userGuid, _callback);

    }

    /**
     * Read a specific budget
     * Read a specific budget.
     * @param budgetGuid The unique identifier for the budget. Defined by MX. (required)
     * @param userGuid The unique identifier for the budget. Defined by MX. (required)
     * @return BudgetResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public BudgetResponseBody usersUserGuidBudgetsBudgetGuidGet(String budgetGuid, String userGuid) throws ApiException {
        ApiResponse<BudgetResponseBody> localVarResp = usersUserGuidBudgetsBudgetGuidGetWithHttpInfo(budgetGuid, userGuid);
        return localVarResp.getData();
    }

    /**
     * Read a specific budget
     * Read a specific budget.
     * @param budgetGuid The unique identifier for the budget. Defined by MX. (required)
     * @param userGuid The unique identifier for the budget. Defined by MX. (required)
     * @return ApiResponse&lt;BudgetResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<BudgetResponseBody> usersUserGuidBudgetsBudgetGuidGetWithHttpInfo(String budgetGuid, String userGuid) throws ApiException {
        okhttp3.Call localVarCall = usersUserGuidBudgetsBudgetGuidGetValidateBeforeCall(budgetGuid, userGuid, null);
        Type localVarReturnType = new TypeToken<BudgetResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Read a specific budget (asynchronously)
     * Read a specific budget.
     * @param budgetGuid The unique identifier for the budget. Defined by MX. (required)
     * @param userGuid The unique identifier for the budget. Defined by MX. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call usersUserGuidBudgetsBudgetGuidGetAsync(String budgetGuid, String userGuid, final ApiCallback<BudgetResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = usersUserGuidBudgetsBudgetGuidGetValidateBeforeCall(budgetGuid, userGuid, _callback);
        Type localVarReturnType = new TypeToken<BudgetResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for usersUserGuidBudgetsBudgetGuidPut
     * @param userGuid The unique identifier for the budget. Defined by MX. (required)
     * @param budgetGuid The unique identifier for the budget. Defined by MX. (required)
     * @param budgetUpdateRequestBody  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call usersUserGuidBudgetsBudgetGuidPutCall(String userGuid, String budgetGuid, BudgetUpdateRequestBody budgetUpdateRequestBody, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = budgetUpdateRequestBody;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/budgets/{budget_guid}"
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()))
            .replace("{" + "budget_guid" + "}", localVarApiClient.escapeString(budgetGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call usersUserGuidBudgetsBudgetGuidPutValidateBeforeCall(String userGuid, String budgetGuid, BudgetUpdateRequestBody budgetUpdateRequestBody, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling usersUserGuidBudgetsBudgetGuidPut(Async)");
        }

        // verify the required parameter 'budgetGuid' is set
        if (budgetGuid == null) {
            throw new ApiException("Missing the required parameter 'budgetGuid' when calling usersUserGuidBudgetsBudgetGuidPut(Async)");
        }

        return usersUserGuidBudgetsBudgetGuidPutCall(userGuid, budgetGuid, budgetUpdateRequestBody, _callback);

    }

    /**
     * Update a specific budget
     * Update a specific budget.
     * @param userGuid The unique identifier for the budget. Defined by MX. (required)
     * @param budgetGuid The unique identifier for the budget. Defined by MX. (required)
     * @param budgetUpdateRequestBody  (optional)
     * @return BudgetResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public BudgetResponseBody usersUserGuidBudgetsBudgetGuidPut(String userGuid, String budgetGuid, BudgetUpdateRequestBody budgetUpdateRequestBody) throws ApiException {
        ApiResponse<BudgetResponseBody> localVarResp = usersUserGuidBudgetsBudgetGuidPutWithHttpInfo(userGuid, budgetGuid, budgetUpdateRequestBody);
        return localVarResp.getData();
    }

    /**
     * Update a specific budget
     * Update a specific budget.
     * @param userGuid The unique identifier for the budget. Defined by MX. (required)
     * @param budgetGuid The unique identifier for the budget. Defined by MX. (required)
     * @param budgetUpdateRequestBody  (optional)
     * @return ApiResponse&lt;BudgetResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<BudgetResponseBody> usersUserGuidBudgetsBudgetGuidPutWithHttpInfo(String userGuid, String budgetGuid, BudgetUpdateRequestBody budgetUpdateRequestBody) throws ApiException {
        okhttp3.Call localVarCall = usersUserGuidBudgetsBudgetGuidPutValidateBeforeCall(userGuid, budgetGuid, budgetUpdateRequestBody, null);
        Type localVarReturnType = new TypeToken<BudgetResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Update a specific budget (asynchronously)
     * Update a specific budget.
     * @param userGuid The unique identifier for the budget. Defined by MX. (required)
     * @param budgetGuid The unique identifier for the budget. Defined by MX. (required)
     * @param budgetUpdateRequestBody  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call usersUserGuidBudgetsBudgetGuidPutAsync(String userGuid, String budgetGuid, BudgetUpdateRequestBody budgetUpdateRequestBody, final ApiCallback<BudgetResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = usersUserGuidBudgetsBudgetGuidPutValidateBeforeCall(userGuid, budgetGuid, budgetUpdateRequestBody, _callback);
        Type localVarReturnType = new TypeToken<BudgetResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for usersUserGuidBudgetsGeneratePost
     * @param userGuid The unique identifier for the user. Defined by MX. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call usersUserGuidBudgetsGeneratePostCall(String userGuid, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/budgets/generate"
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call usersUserGuidBudgetsGeneratePostValidateBeforeCall(String userGuid, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling usersUserGuidBudgetsGeneratePost(Async)");
        }

        return usersUserGuidBudgetsGeneratePostCall(userGuid, _callback);

    }

    /**
     * Auto-generate budgets
     * This endpoint will automatically create budgets for several categories based on existing transactions; these budgets are returned as an array. Specifically, budgets will only be generated if the &#x60;user&#x60; has at least one &#x60;transaction&#x60; in a given category during each of the two previous calendar months. For example, if the request is made on March 6, and there is at least one \&quot;Bills &amp; Utilities\&quot; &#x60;transaction&#x60; in both January and February, a budget will be generated for \&quot;Bills &amp; Utilities.\&quot; If there are two \&quot;Bills &amp; Utilities\&quot; transactions in February but none in January, no budget will be generated for that category. If budgets already exist for particular categories, new budgets will be generated and returned based on the available transactions. If one or more budgets remain unchanged, they will nevertheless be returned in the response. If no transaction data for the &#x60;user&#x60; meet the above criteria, a &#x60;422 Unprocessable Entity&#x60; error will be returned with status code 4221 along with the message, &#x60;There aren&#39;t enough transactions to automatically create any budgets&#x60;.
     * @param userGuid The unique identifier for the user. Defined by MX. (required)
     * @return BudgetResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public BudgetResponseBody usersUserGuidBudgetsGeneratePost(String userGuid) throws ApiException {
        ApiResponse<BudgetResponseBody> localVarResp = usersUserGuidBudgetsGeneratePostWithHttpInfo(userGuid);
        return localVarResp.getData();
    }

    /**
     * Auto-generate budgets
     * This endpoint will automatically create budgets for several categories based on existing transactions; these budgets are returned as an array. Specifically, budgets will only be generated if the &#x60;user&#x60; has at least one &#x60;transaction&#x60; in a given category during each of the two previous calendar months. For example, if the request is made on March 6, and there is at least one \&quot;Bills &amp; Utilities\&quot; &#x60;transaction&#x60; in both January and February, a budget will be generated for \&quot;Bills &amp; Utilities.\&quot; If there are two \&quot;Bills &amp; Utilities\&quot; transactions in February but none in January, no budget will be generated for that category. If budgets already exist for particular categories, new budgets will be generated and returned based on the available transactions. If one or more budgets remain unchanged, they will nevertheless be returned in the response. If no transaction data for the &#x60;user&#x60; meet the above criteria, a &#x60;422 Unprocessable Entity&#x60; error will be returned with status code 4221 along with the message, &#x60;There aren&#39;t enough transactions to automatically create any budgets&#x60;.
     * @param userGuid The unique identifier for the user. Defined by MX. (required)
     * @return ApiResponse&lt;BudgetResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<BudgetResponseBody> usersUserGuidBudgetsGeneratePostWithHttpInfo(String userGuid) throws ApiException {
        okhttp3.Call localVarCall = usersUserGuidBudgetsGeneratePostValidateBeforeCall(userGuid, null);
        Type localVarReturnType = new TypeToken<BudgetResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Auto-generate budgets (asynchronously)
     * This endpoint will automatically create budgets for several categories based on existing transactions; these budgets are returned as an array. Specifically, budgets will only be generated if the &#x60;user&#x60; has at least one &#x60;transaction&#x60; in a given category during each of the two previous calendar months. For example, if the request is made on March 6, and there is at least one \&quot;Bills &amp; Utilities\&quot; &#x60;transaction&#x60; in both January and February, a budget will be generated for \&quot;Bills &amp; Utilities.\&quot; If there are two \&quot;Bills &amp; Utilities\&quot; transactions in February but none in January, no budget will be generated for that category. If budgets already exist for particular categories, new budgets will be generated and returned based on the available transactions. If one or more budgets remain unchanged, they will nevertheless be returned in the response. If no transaction data for the &#x60;user&#x60; meet the above criteria, a &#x60;422 Unprocessable Entity&#x60; error will be returned with status code 4221 along with the message, &#x60;There aren&#39;t enough transactions to automatically create any budgets&#x60;.
     * @param userGuid The unique identifier for the user. Defined by MX. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call usersUserGuidBudgetsGeneratePostAsync(String userGuid, final ApiCallback<BudgetResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = usersUserGuidBudgetsGeneratePostValidateBeforeCall(userGuid, _callback);
        Type localVarReturnType = new TypeToken<BudgetResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for usersUserGuidBudgetsGet
     * @param userGuid The unique identifier for the user. Defined by MX. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call usersUserGuidBudgetsGetCall(String userGuid, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/budgets"
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call usersUserGuidBudgetsGetValidateBeforeCall(String userGuid, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling usersUserGuidBudgetsGet(Async)");
        }

        return usersUserGuidBudgetsGetCall(userGuid, _callback);

    }

    /**
     * List all budgets
     * List all budgets
     * @param userGuid The unique identifier for the user. Defined by MX. (required)
     * @return BudgetResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public BudgetResponseBody usersUserGuidBudgetsGet(String userGuid) throws ApiException {
        ApiResponse<BudgetResponseBody> localVarResp = usersUserGuidBudgetsGetWithHttpInfo(userGuid);
        return localVarResp.getData();
    }

    /**
     * List all budgets
     * List all budgets
     * @param userGuid The unique identifier for the user. Defined by MX. (required)
     * @return ApiResponse&lt;BudgetResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<BudgetResponseBody> usersUserGuidBudgetsGetWithHttpInfo(String userGuid) throws ApiException {
        okhttp3.Call localVarCall = usersUserGuidBudgetsGetValidateBeforeCall(userGuid, null);
        Type localVarReturnType = new TypeToken<BudgetResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List all budgets (asynchronously)
     * List all budgets
     * @param userGuid The unique identifier for the user. Defined by MX. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call usersUserGuidBudgetsGetAsync(String userGuid, final ApiCallback<BudgetResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = usersUserGuidBudgetsGetValidateBeforeCall(userGuid, _callback);
        Type localVarReturnType = new TypeToken<BudgetResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for usersUserGuidBudgetsPost
     * @param userGuid The unique identifier for the user. Defined by MX. (required)
     * @param budgetCreateRequestBody  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call usersUserGuidBudgetsPostCall(String userGuid, BudgetCreateRequestBody budgetCreateRequestBody, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = budgetCreateRequestBody;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/budgets"
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call usersUserGuidBudgetsPostValidateBeforeCall(String userGuid, BudgetCreateRequestBody budgetCreateRequestBody, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling usersUserGuidBudgetsPost(Async)");
        }

        // verify the required parameter 'budgetCreateRequestBody' is set
        if (budgetCreateRequestBody == null) {
            throw new ApiException("Missing the required parameter 'budgetCreateRequestBody' when calling usersUserGuidBudgetsPost(Async)");
        }

        return usersUserGuidBudgetsPostCall(userGuid, budgetCreateRequestBody, _callback);

    }

    /**
     * Create a budget
     * Create a budget. This endpoint accepts the optional &#x60;MX-Skip-Webhook&#x60; header and &#x60;skip_webhook&#x60; parameter. You cannot create a duplicate budget. For example, if you attempt to create a budget for \&quot;Gas\&quot;, but that budget already exist, the request will fail. You can retrieve a list of all existing categories by using the List Categories endpoint.
     * @param userGuid The unique identifier for the user. Defined by MX. (required)
     * @param budgetCreateRequestBody  (required)
     * @return BudgetResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public BudgetResponseBody usersUserGuidBudgetsPost(String userGuid, BudgetCreateRequestBody budgetCreateRequestBody) throws ApiException {
        ApiResponse<BudgetResponseBody> localVarResp = usersUserGuidBudgetsPostWithHttpInfo(userGuid, budgetCreateRequestBody);
        return localVarResp.getData();
    }

    /**
     * Create a budget
     * Create a budget. This endpoint accepts the optional &#x60;MX-Skip-Webhook&#x60; header and &#x60;skip_webhook&#x60; parameter. You cannot create a duplicate budget. For example, if you attempt to create a budget for \&quot;Gas\&quot;, but that budget already exist, the request will fail. You can retrieve a list of all existing categories by using the List Categories endpoint.
     * @param userGuid The unique identifier for the user. Defined by MX. (required)
     * @param budgetCreateRequestBody  (required)
     * @return ApiResponse&lt;BudgetResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<BudgetResponseBody> usersUserGuidBudgetsPostWithHttpInfo(String userGuid, BudgetCreateRequestBody budgetCreateRequestBody) throws ApiException {
        okhttp3.Call localVarCall = usersUserGuidBudgetsPostValidateBeforeCall(userGuid, budgetCreateRequestBody, null);
        Type localVarReturnType = new TypeToken<BudgetResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Create a budget (asynchronously)
     * Create a budget. This endpoint accepts the optional &#x60;MX-Skip-Webhook&#x60; header and &#x60;skip_webhook&#x60; parameter. You cannot create a duplicate budget. For example, if you attempt to create a budget for \&quot;Gas\&quot;, but that budget already exist, the request will fail. You can retrieve a list of all existing categories by using the List Categories endpoint.
     * @param userGuid The unique identifier for the user. Defined by MX. (required)
     * @param budgetCreateRequestBody  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call usersUserGuidBudgetsPostAsync(String userGuid, BudgetCreateRequestBody budgetCreateRequestBody, final ApiCallback<BudgetResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = usersUserGuidBudgetsPostValidateBeforeCall(userGuid, budgetCreateRequestBody, _callback);
        Type localVarReturnType = new TypeToken<BudgetResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
