/*
 * MX Platform API
 * The MX Platform API is a powerful, fully-featured API designed to make aggregating and enhancing financial data easy and reliable. It can seamlessly connect your app or website to tens of thousands of financial institutions.
 *
 * The version of the OpenAPI document: 0.1.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.mx.client.mx_platform_api;

import com.mx.client.ApiCallback;
import com.mx.client.ApiClient;
import com.mx.client.ApiException;
import com.mx.client.ApiResponse;
import com.mx.client.Configuration;
import com.mx.client.Pair;
import com.mx.client.ProgressRequestBody;
import com.mx.client.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import com.mx.client.model.TransactionCreateRequestBody;
import com.mx.client.model.TransactionCreateResponseBody;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TransactionsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public TransactionsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public TransactionsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    /**
     * Build call for usersUserGuidAccountsAccountGuidTransactionsPost
     * @param userGuid The unique identifier for the user. (required)
     * @param accountGuid The unique identifier for the account. (required)
     * @param transactionCreateRequestBody  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call usersUserGuidAccountsAccountGuidTransactionsPostCall(String userGuid, String accountGuid, TransactionCreateRequestBody transactionCreateRequestBody, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = transactionCreateRequestBody;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/accounts/{account_guid}/transactions"
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()))
            .replace("{" + "account_guid" + "}", localVarApiClient.escapeString(accountGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call usersUserGuidAccountsAccountGuidTransactionsPostValidateBeforeCall(String userGuid, String accountGuid, TransactionCreateRequestBody transactionCreateRequestBody, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling usersUserGuidAccountsAccountGuidTransactionsPost(Async)");
        }

        // verify the required parameter 'accountGuid' is set
        if (accountGuid == null) {
            throw new ApiException("Missing the required parameter 'accountGuid' when calling usersUserGuidAccountsAccountGuidTransactionsPost(Async)");
        }

        // verify the required parameter 'transactionCreateRequestBody' is set
        if (transactionCreateRequestBody == null) {
            throw new ApiException("Missing the required parameter 'transactionCreateRequestBody' when calling usersUserGuidAccountsAccountGuidTransactionsPost(Async)");
        }

        return usersUserGuidAccountsAccountGuidTransactionsPostCall(userGuid, accountGuid, transactionCreateRequestBody, _callback);

    }

    /**
     * Create manual transaction
     * This endpoint can only be used to create manual transactions that are under a manual account. This endpoint accepts the optional MX-Skip-Webhook header and skip_webhook parameter.
     * @param userGuid The unique identifier for the user. (required)
     * @param accountGuid The unique identifier for the account. (required)
     * @param transactionCreateRequestBody  (required)
     * @return TransactionCreateResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public TransactionCreateResponseBody usersUserGuidAccountsAccountGuidTransactionsPost(String userGuid, String accountGuid, TransactionCreateRequestBody transactionCreateRequestBody) throws ApiException {
        ApiResponse<TransactionCreateResponseBody> localVarResp = usersUserGuidAccountsAccountGuidTransactionsPostWithHttpInfo(userGuid, accountGuid, transactionCreateRequestBody);
        return localVarResp.getData();
    }

    /**
     * Create manual transaction
     * This endpoint can only be used to create manual transactions that are under a manual account. This endpoint accepts the optional MX-Skip-Webhook header and skip_webhook parameter.
     * @param userGuid The unique identifier for the user. (required)
     * @param accountGuid The unique identifier for the account. (required)
     * @param transactionCreateRequestBody  (required)
     * @return ApiResponse&lt;TransactionCreateResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<TransactionCreateResponseBody> usersUserGuidAccountsAccountGuidTransactionsPostWithHttpInfo(String userGuid, String accountGuid, TransactionCreateRequestBody transactionCreateRequestBody) throws ApiException {
        okhttp3.Call localVarCall = usersUserGuidAccountsAccountGuidTransactionsPostValidateBeforeCall(userGuid, accountGuid, transactionCreateRequestBody, null);
        Type localVarReturnType = new TypeToken<TransactionCreateResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Create manual transaction (asynchronously)
     * This endpoint can only be used to create manual transactions that are under a manual account. This endpoint accepts the optional MX-Skip-Webhook header and skip_webhook parameter.
     * @param userGuid The unique identifier for the user. (required)
     * @param accountGuid The unique identifier for the account. (required)
     * @param transactionCreateRequestBody  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call usersUserGuidAccountsAccountGuidTransactionsPostAsync(String userGuid, String accountGuid, TransactionCreateRequestBody transactionCreateRequestBody, final ApiCallback<TransactionCreateResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = usersUserGuidAccountsAccountGuidTransactionsPostValidateBeforeCall(userGuid, accountGuid, transactionCreateRequestBody, _callback);
        Type localVarReturnType = new TypeToken<TransactionCreateResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
