/*
 * Decompiled with CFR 0.152.
 */
package com.mx.client.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.mx.client.JSON;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

public class PaginationResponse {
    public static final String SERIALIZED_NAME_CURRENT_PAGE = "current_page";
    @SerializedName(value="current_page")
    private Integer currentPage;
    public static final String SERIALIZED_NAME_PER_PAGE = "per_page";
    @SerializedName(value="per_page")
    private Integer perPage;
    public static final String SERIALIZED_NAME_TOTAL_ENTRIES = "total_entries";
    @SerializedName(value="total_entries")
    private Integer totalEntries;
    public static final String SERIALIZED_NAME_TOTAL_PAGES = "total_pages";
    @SerializedName(value="total_pages")
    private Integer totalPages;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public PaginationResponse currentPage(Integer currentPage) {
        this.currentPage = currentPage;
        return this;
    }

    @Nullable
    public Integer getCurrentPage() {
        return this.currentPage;
    }

    public void setCurrentPage(Integer currentPage) {
        this.currentPage = currentPage;
    }

    public PaginationResponse perPage(Integer perPage) {
        this.perPage = perPage;
        return this;
    }

    @Nullable
    public Integer getPerPage() {
        return this.perPage;
    }

    public void setPerPage(Integer perPage) {
        this.perPage = perPage;
    }

    public PaginationResponse totalEntries(Integer totalEntries) {
        this.totalEntries = totalEntries;
        return this;
    }

    @Nullable
    public Integer getTotalEntries() {
        return this.totalEntries;
    }

    public void setTotalEntries(Integer totalEntries) {
        this.totalEntries = totalEntries;
    }

    public PaginationResponse totalPages(Integer totalPages) {
        this.totalPages = totalPages;
        return this;
    }

    @Nullable
    public Integer getTotalPages() {
        return this.totalPages;
    }

    public void setTotalPages(Integer totalPages) {
        this.totalPages = totalPages;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaginationResponse paginationResponse = (PaginationResponse)o;
        return Objects.equals(this.currentPage, paginationResponse.currentPage) && Objects.equals(this.perPage, paginationResponse.perPage) && Objects.equals(this.totalEntries, paginationResponse.totalEntries) && Objects.equals(this.totalPages, paginationResponse.totalPages);
    }

    public int hashCode() {
        return Objects.hash(this.currentPage, this.perPage, this.totalEntries, this.totalPages);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaginationResponse {\n");
        sb.append("    currentPage: ").append(this.toIndentedString(this.currentPage)).append("\n");
        sb.append("    perPage: ").append(this.toIndentedString(this.perPage)).append("\n");
        sb.append("    totalEntries: ").append(this.toIndentedString(this.totalEntries)).append("\n");
        sb.append("    totalPages: ").append(this.toIndentedString(this.totalPages)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in PaginationResponse is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `PaginationResponse` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
    }

    public static PaginationResponse fromJson(String jsonString) throws IOException {
        return (PaginationResponse)JSON.getGson().fromJson(jsonString, PaginationResponse.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_CURRENT_PAGE);
        openapiFields.add(SERIALIZED_NAME_PER_PAGE);
        openapiFields.add(SERIALIZED_NAME_TOTAL_ENTRIES);
        openapiFields.add(SERIALIZED_NAME_TOTAL_PAGES);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!PaginationResponse.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(PaginationResponse.class));
            return new TypeAdapter<PaginationResponse>(){

                public void write(JsonWriter out, PaginationResponse value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public PaginationResponse read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    PaginationResponse.validateJsonElement(jsonElement);
                    return (PaginationResponse)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

