/*
 * Decompiled with CFR 0.152.
 */
package com.nativelibs4java.opencl.proxy;

import com.nativelibs4java.opencl.library.IOpenCLLibrary;
import com.nativelibs4java.opencl.proxy.PointerUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import org.bridj.BridJ;
import org.bridj.NativeObject;
import org.bridj.Pointer;
import org.bridj.StructObject;
import org.bridj.ann.Field;
import org.bridj.ann.Ptr;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxiedOpenCLImplementation
implements IOpenCLLibrary {
    private static Pointer<?> icdDispatchTable;
    private static ProxiedOpenCLImplementation instance;
    private final List<IOpenCLLibrary> implementations;
    private final List<IcdEntity> platformIds;

    public static void setIcdDispatchTable(long icdDispatchTablePeer) {
        icdDispatchTable = Pointer.pointerToAddress((long)icdDispatchTablePeer);
    }

    public static synchronized IOpenCLLibrary getInstance() {
        if (instance == null) {
            ArrayList<IOpenCLLibrary> platforms = new ArrayList<IOpenCLLibrary>();
            for (IOpenCLLibrary platform : ServiceLoader.load(IOpenCLLibrary.class)) {
                platforms.add(platform);
            }
            instance = new ProxiedOpenCLImplementation(platforms);
        }
        return instance;
    }

    @Override
    public int clCreateSubDevices(long cl_device_id1, long cl_device_partition_propertyPtr1, int cl_uint1, long cl_device_idPtr1, long cl_uintPtr1) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public long clCreateContextFromType(long cl_context_propertiesPtr1, long cl_device_type1, long arg1, long voidPtr1, long cl_intPtr1) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public long clCreateProgramWithBuiltInKernels(long cl_context1, int cl_uint1, long cl_device_idPtr1, long charPtr1, long cl_intPtr1) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int clCompileProgram(long cl_program1, int cl_uint1, long cl_device_idPtr1, long charPtr1, int cl_uint2, long cl_programPtr1, long charPtrPtr1, long arg1, long voidPtr1) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public long clLinkProgram(long cl_context1, int cl_uint1, long cl_device_idPtr1, long charPtr1, int cl_uint2, long cl_programPtr1, long arg1, long voidPtr1, long cl_intPtr1) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int clEnqueueReadBufferRect(long cl_command_queue1, long cl_mem1, int cl_bool1, long size_tPtr1, long size_tPtr2, long size_tPtr3, long size_t1, long size_t2, long size_t3, long size_t4, long voidPtr1, int cl_uint1, long cl_eventPtr1, long cl_eventPtr2) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int clEnqueueWriteBufferRect(long cl_command_queue1, long cl_mem1, int cl_bool1, long size_tPtr1, long size_tPtr2, long size_tPtr3, long size_t1, long size_t2, long size_t3, long size_t4, long voidPtr1, int cl_uint1, long cl_eventPtr1, long cl_eventPtr2) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int clEnqueueFillBuffer(long cl_command_queue1, long cl_mem1, long voidPtr1, long size_t1, long size_t2, long size_t3, int cl_uint1, long cl_eventPtr1, long cl_eventPtr2) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int clEnqueueCopyBufferRect(long cl_command_queue1, long cl_mem1, long cl_mem2, long size_tPtr1, long size_tPtr2, long size_tPtr3, long size_t1, long size_t2, long size_t3, long size_t4, int cl_uint1, long cl_eventPtr1, long cl_eventPtr2) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int clEnqueueFillImage(long cl_command_queue1, long cl_mem1, long voidPtr1, long size_tPtr1, long size_tPtr2, int cl_uint1, long cl_eventPtr1, long cl_eventPtr2) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int clEnqueueCopyImage(long cl_command_queue1, long cl_mem1, long cl_mem2, long size_tPtr1, long size_tPtr2, long size_tPtr3, int cl_uint1, long cl_eventPtr1, long cl_eventPtr2) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int clEnqueueCopyImageToBuffer(long cl_command_queue1, long cl_mem1, long cl_mem2, long size_tPtr1, long size_tPtr2, long size_t1, int cl_uint1, long cl_eventPtr1, long cl_eventPtr2) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int clEnqueueCopyBufferToImage(long cl_command_queue1, long cl_mem1, long cl_mem2, long size_t1, long size_tPtr1, long size_tPtr2, int cl_uint1, long cl_eventPtr1, long cl_eventPtr2) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int clEnqueueMigrateMemObjects(long cl_command_queue1, int cl_uint1, long cl_memPtr1, long cl_mem_migration_flags1, int cl_uint2, long cl_eventPtr1, long cl_eventPtr2) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int clEnqueueNativeKernel(long cl_command_queue1, long arg1, long voidPtr1, long size_t1, int cl_uint1, long cl_memPtr1, long voidPtrPtr1, int cl_uint2, long cl_eventPtr1, long cl_eventPtr2) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int clEnqueueMarkerWithWaitList(long cl_command_queue1, int cl_uint1, long cl_eventPtr1, long cl_eventPtr2) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int clEnqueueBarrierWithWaitList(long cl_command_queue1, int cl_uint1, long cl_eventPtr1, long cl_eventPtr2) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int clSetPrintfCallback(long cl_context1, long arg1, long voidPtr1) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public long clGetExtensionFunctionAddressForPlatform(long cl_platform_id1, long charPtr1) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public long clGetExtensionFunctionAddress(long charPtr1) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public long clCreateEventFromGLsyncKHR(long cl_context1, long cl_GLsync1, long cl_intPtr1) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int clSetMemObjectDestructorAPPLE(long cl_mem1, long arg1, long voidPtr1) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void clLogMessagesToSystemLogAPPLE(long charPtr1, long voidPtr1, long size_t1, long voidPtr2) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void clLogMessagesToStdoutAPPLE(long charPtr1, long voidPtr1, long size_t1, long voidPtr2) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void clLogMessagesToStderrAPPLE(long charPtr1, long voidPtr1, long size_t1, long voidPtr2) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int clCreateSubDevicesEXT(long cl_device_id1, long cl_device_partition_property_extPtr1, int cl_uint1, long cl_device_idPtr1, long cl_uintPtr1) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public static IcdEntity createEntity(int implementationIndex, int entityIndex) {
        IcdEntity entity = new IcdEntity();
        entity.implementationIndex = implementationIndex;
        entity.entityIndex = entityIndex;
        BridJ.writeToNative((NativeObject)entity);
        return entity;
    }

    public ProxiedOpenCLImplementation(List<IOpenCLLibrary> implementations) {
        this.implementations = new ArrayList<IOpenCLLibrary>(implementations);
        ArrayList<IcdEntity> platformIds = new ArrayList<IcdEntity>();
        for (IOpenCLLibrary implementation : this.implementations) {
            int implementationIndex = implementations.size();
            implementations.add(implementation);
            platformIds.add(ProxiedOpenCLImplementation.createEntity(implementationIndex, implementationIndex));
        }
        this.platformIds = platformIds;
    }

    protected IOpenCLLibrary getImplementation(long icdEntityPeer) {
        Pointer<IcdEntity> icdEntityPtr = PointerUtils.getPointer(icdEntityPeer, IcdEntity.class);
        IcdEntity icdEntity = (IcdEntity)((Object)icdEntityPtr.get());
        if (!icdDispatchTable.equals(icdEntity.icdDispatchTable)) {
            throw new IllegalArgumentException("Not an ICD entity, or different ICD dispatch table: " + icdEntityPeer);
        }
        IOpenCLLibrary implementation = this.implementations.get(icdEntity.implementationIndex);
        return implementation;
    }

    @Override
    public int clGetPlatformIDs(int num_entries, @Ptr long platforms, @Ptr long num_platforms) {
        System.out.println("Called clGetPlatformIDs");
        if ((platforms == 0L || num_entries == 0) && num_platforms == 0L) {
            PointerUtils.setSizeT(num_platforms, this.platformIds.size());
        } else if (platforms != 0L && num_entries != 0) {
            int numWrote = 0;
            for (int i = 0; i < num_entries; ++i) {
                PointerUtils.setPointerAtIndex(platforms, i, (NativeObject)this.platformIds.get(i));
                ++numWrote;
            }
            if (num_platforms != 0L) {
                PointerUtils.setSizeT(num_platforms, numWrote);
            }
        } else {
            return -30;
        }
        return 0;
    }

    @Override
    public int clIcdGetPlatformIDsKHR(int num_entries, @Ptr long platforms, @Ptr long num_platforms) {
        return this.clGetPlatformIDs(num_entries, platforms, num_platforms);
    }

    @Override
    public int clGetDeviceIDs(long cl_platform_id1, long cl_device_type1, int cl_uint1, long cl_device_idPtr1, long cl_uintPtr1) {
        return this.getImplementation(cl_platform_id1).clGetDeviceIDs(cl_platform_id1, cl_device_type1, cl_uint1, cl_device_idPtr1, cl_uintPtr1);
    }

    @Override
    public int clGetDeviceInfo(long cl_device_id1, int cl_device_info1, long size_t1, long voidPtr1, long size_tPtr1) {
        return this.getImplementation(cl_device_id1).clGetDeviceInfo(cl_device_id1, cl_device_info1, size_t1, voidPtr1, size_tPtr1);
    }

    @Override
    public int clGetPlatformInfo(long cl_platform_id1, int cl_platform_info1, long size_t1, long voidPtr1, long size_tPtr1) {
        return this.getImplementation(cl_platform_id1).clGetPlatformInfo(cl_platform_id1, cl_platform_info1, size_t1, voidPtr1, size_tPtr1);
    }

    @Override
    public int clBuildProgram(long cl_program1, int cl_uint1, long cl_device_idPtr1, long charPtr1, long arg1, long voidPtr1) {
        return this.getImplementation(cl_program1).clBuildProgram(cl_program1, cl_uint1, cl_device_idPtr1, charPtr1, arg1, voidPtr1);
    }

    @Override
    public long clCreateBuffer(long cl_context1, long cl_mem_flags1, long size_t1, long voidPtr1, long cl_intPtr1) {
        return this.getImplementation(cl_context1).clCreateBuffer(cl_context1, cl_mem_flags1, size_t1, voidPtr1, cl_intPtr1);
    }

    @Override
    public long clCreateCommandQueue(long cl_context1, long cl_device_id1, long cl_command_queue_properties1, long cl_intPtr1) {
        return this.getImplementation(cl_context1).clCreateCommandQueue(cl_context1, cl_device_id1, cl_command_queue_properties1, cl_intPtr1);
    }

    @Override
    public long clCreateContext(long cl_context_propertiesPtr1, int cl_uint1, long cl_device_idPtr1, long arg1, long voidPtr1, long cl_intPtr1) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long clCreateFromGLBuffer(long cl_context1, long cl_mem_flags1, int cl_GLuint1, long intPtr1) {
        return this.getImplementation(cl_context1).clCreateFromGLBuffer(cl_context1, cl_mem_flags1, cl_GLuint1, intPtr1);
    }

    @Override
    public long clCreateFromGLRenderbuffer(long cl_context1, long cl_mem_flags1, int cl_GLuint1, long cl_intPtr1) {
        return this.getImplementation(cl_context1).clCreateFromGLRenderbuffer(cl_context1, cl_mem_flags1, cl_GLuint1, cl_intPtr1);
    }

    @Override
    public long clCreateFromGLTexture(long cl_context1, long cl_mem_flags1, int cl_GLenum1, int cl_GLint1, int cl_GLuint1, long cl_intPtr1) {
        return this.getImplementation(cl_context1).clCreateFromGLTexture(cl_context1, cl_mem_flags1, cl_GLenum1, cl_GLint1, cl_GLuint1, cl_intPtr1);
    }

    @Override
    public long clCreateFromGLTexture2D(long cl_context1, long cl_mem_flags1, int cl_GLenum1, int cl_GLint1, int cl_GLuint1, long cl_intPtr1) {
        return this.getImplementation(cl_context1).clCreateFromGLTexture2D(cl_context1, cl_mem_flags1, cl_GLenum1, cl_GLint1, cl_GLuint1, cl_intPtr1);
    }

    @Override
    public long clCreateFromGLTexture3D(long cl_context1, long cl_mem_flags1, int cl_GLenum1, int cl_GLint1, int cl_GLuint1, long cl_intPtr1) {
        return this.getImplementation(cl_context1).clCreateFromGLTexture3D(cl_context1, cl_mem_flags1, cl_GLenum1, cl_GLint1, cl_GLuint1, cl_intPtr1);
    }

    @Override
    public long clCreateImage(long cl_context1, long cl_mem_flags1, long cl_image_formatPtr1, long cl_image_descPtr1, long voidPtr1, long cl_intPtr1) {
        return this.getImplementation(cl_context1).clCreateImage(cl_context1, cl_mem_flags1, cl_image_formatPtr1, cl_image_descPtr1, voidPtr1, cl_intPtr1);
    }

    @Override
    public long clCreateImage2D(long cl_context1, long cl_mem_flags1, long cl_image_formatPtr1, long size_t1, long size_t2, long size_t3, long voidPtr1, long cl_intPtr1) {
        return this.getImplementation(cl_context1).clCreateImage2D(cl_context1, cl_mem_flags1, cl_image_formatPtr1, size_t1, size_t2, size_t3, voidPtr1, cl_intPtr1);
    }

    @Override
    public long clCreateImage3D(long cl_context1, long cl_mem_flags1, long cl_image_formatPtr1, long size_t1, long size_t2, long size_t3, long size_t4, long size_t5, long voidPtr1, long cl_intPtr1) {
        return this.getImplementation(cl_context1).clCreateImage3D(cl_context1, cl_mem_flags1, cl_image_formatPtr1, size_t1, size_t2, size_t3, size_t4, size_t5, voidPtr1, cl_intPtr1);
    }

    @Override
    public long clCreateKernel(long cl_program1, long charPtr1, long cl_intPtr1) {
        return this.getImplementation(cl_program1).clCreateKernel(cl_program1, charPtr1, cl_intPtr1);
    }

    @Override
    public int clCreateKernelsInProgram(long cl_program1, int cl_uint1, long cl_kernelPtr1, long cl_uintPtr1) {
        return this.getImplementation(cl_program1).clCreateKernelsInProgram(cl_program1, cl_uint1, cl_kernelPtr1, cl_uintPtr1);
    }

    @Override
    public long clCreateProgramWithBinary(long cl_context1, int cl_uint1, long cl_device_idPtr1, long size_tPtr1, long charPtrPtr1, long cl_intPtr1, long cl_intPtr2) {
        return this.getImplementation(cl_context1).clCreateProgramWithBinary(cl_context1, cl_uint1, cl_device_idPtr1, size_tPtr1, charPtrPtr1, cl_intPtr1, cl_intPtr2);
    }

    @Override
    public long clCreateProgramWithSource(long cl_context1, int cl_uint1, long charPtrPtr1, long size_tPtr1, long cl_intPtr1) {
        return this.getImplementation(cl_context1).clCreateProgramWithSource(cl_context1, cl_uint1, charPtrPtr1, size_tPtr1, cl_intPtr1);
    }

    @Override
    public long clCreateSampler(long cl_context1, int cl_bool1, int cl_addressing_mode1, int cl_filter_mode1, long cl_intPtr1) {
        return this.getImplementation(cl_context1).clCreateSampler(cl_context1, cl_bool1, cl_addressing_mode1, cl_filter_mode1, cl_intPtr1);
    }

    @Override
    public long clCreateSubBuffer(long cl_mem1, long cl_mem_flags1, int cl_buffer_create_type1, long voidPtr1, long cl_intPtr1) {
        return this.getImplementation(cl_mem1).clCreateSubBuffer(cl_mem1, cl_mem_flags1, cl_buffer_create_type1, voidPtr1, cl_intPtr1);
    }

    @Override
    public long clCreateUserEvent(long cl_context1, long cl_intPtr1) {
        return this.getImplementation(cl_context1).clCreateUserEvent(cl_context1, cl_intPtr1);
    }

    @Override
    public int clEnqueueAcquireGLObjects(long cl_command_queue1, int cl_uint1, long cl_memPtr1, int cl_uint2, long cl_eventPtr1, long cl_eventPtr2) {
        return this.getImplementation(cl_command_queue1).clEnqueueAcquireGLObjects(cl_command_queue1, cl_uint1, cl_memPtr1, cl_uint2, cl_eventPtr1, cl_eventPtr2);
    }

    @Override
    public int clEnqueueBarrier(long cl_command_queue1) {
        return this.getImplementation(cl_command_queue1).clEnqueueBarrier(cl_command_queue1);
    }

    @Override
    public int clEnqueueCopyBuffer(long cl_command_queue1, long cl_mem1, long cl_mem2, long size_t1, long size_t2, long size_t3, int cl_uint1, long cl_eventPtr1, long cl_eventPtr2) {
        return this.getImplementation(cl_command_queue1).clEnqueueCopyBuffer(cl_command_queue1, cl_mem1, cl_mem2, size_t1, size_t2, size_t3, cl_uint1, cl_eventPtr1, cl_eventPtr2);
    }

    @Override
    public long clEnqueueMapBuffer(long cl_command_queue1, long cl_mem1, int cl_bool1, long cl_map_flags1, long size_t1, long size_t2, int cl_uint1, long cl_eventPtr1, long cl_eventPtr2, long cl_intPtr1) {
        return this.getImplementation(cl_command_queue1).clEnqueueMapBuffer(cl_command_queue1, cl_mem1, cl_bool1, cl_map_flags1, size_t1, size_t2, cl_uint1, cl_eventPtr1, cl_eventPtr2, cl_intPtr1);
    }

    @Override
    public long clEnqueueMapImage(long cl_command_queue1, long cl_mem1, int cl_bool1, long cl_map_flags1, long size_tPtr1, long size_tPtr2, long size_tPtr3, long size_tPtr4, int cl_uint1, long cl_eventPtr1, long cl_eventPtr2, long cl_intPtr1) {
        return this.getImplementation(cl_command_queue1).clEnqueueMapImage(cl_command_queue1, cl_mem1, cl_bool1, cl_map_flags1, size_tPtr1, size_tPtr2, size_tPtr3, size_tPtr4, cl_uint1, cl_eventPtr1, cl_eventPtr2, cl_intPtr1);
    }

    @Override
    public int clEnqueueMarker(long cl_command_queue1, long cl_eventPtr1) {
        return this.getImplementation(cl_command_queue1).clEnqueueMarker(cl_command_queue1, cl_eventPtr1);
    }

    @Override
    public int clEnqueueNDRangeKernel(long cl_command_queue1, long cl_kernel1, int cl_uint1, long size_tPtr1, long size_tPtr2, long size_tPtr3, int cl_uint2, long cl_eventPtr1, long cl_eventPtr2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int clEnqueueReadBuffer(long cl_command_queue1, long cl_mem1, int cl_bool1, long size_t1, long size_t2, long voidPtr1, int cl_uint1, long cl_eventPtr1, long cl_eventPtr2) {
        return this.getImplementation(cl_command_queue1).clEnqueueReadBuffer(cl_command_queue1, cl_mem1, cl_bool1, size_t1, size_t2, voidPtr1, cl_uint1, cl_eventPtr1, cl_eventPtr2);
    }

    @Override
    public int clEnqueueReadImage(long cl_command_queue1, long cl_mem1, int cl_bool1, long size_tPtr1, long size_tPtr2, long size_t1, long size_t2, long voidPtr1, int cl_uint1, long cl_eventPtr1, long cl_eventPtr2) {
        return this.getImplementation(cl_command_queue1).clEnqueueReadImage(cl_command_queue1, cl_mem1, cl_bool1, size_tPtr1, size_tPtr2, size_t1, size_t2, voidPtr1, cl_uint1, cl_eventPtr1, cl_eventPtr2);
    }

    @Override
    public int clEnqueueReleaseGLObjects(long cl_command_queue1, int cl_uint1, long cl_memPtr1, int cl_uint2, long cl_eventPtr1, long cl_eventPtr2) {
        return this.getImplementation(cl_command_queue1).clEnqueueReleaseGLObjects(cl_command_queue1, cl_uint1, cl_memPtr1, cl_uint2, cl_eventPtr1, cl_eventPtr2);
    }

    @Override
    public int clEnqueueTask(long cl_command_queue1, long cl_kernel1, int cl_uint1, long cl_eventPtr1, long cl_eventPtr2) {
        return this.getImplementation(cl_command_queue1).clEnqueueTask(cl_command_queue1, cl_kernel1, cl_uint1, cl_eventPtr1, cl_eventPtr2);
    }

    @Override
    public int clEnqueueUnmapMemObject(long cl_command_queue1, long cl_mem1, long voidPtr1, int cl_uint1, long cl_eventPtr1, long cl_eventPtr2) {
        return this.getImplementation(cl_command_queue1).clEnqueueUnmapMemObject(cl_command_queue1, cl_mem1, voidPtr1, cl_uint1, cl_eventPtr1, cl_eventPtr2);
    }

    @Override
    public int clEnqueueWaitForEvents(long cl_command_queue1, int cl_uint1, long cl_eventPtr1) {
        return this.getImplementation(cl_command_queue1).clEnqueueWaitForEvents(cl_command_queue1, cl_uint1, cl_eventPtr1);
    }

    @Override
    public int clEnqueueWriteBuffer(long cl_command_queue1, long cl_mem1, int cl_bool1, long size_t1, long size_t2, long voidPtr1, int cl_uint1, long cl_eventPtr1, long cl_eventPtr2) {
        return this.getImplementation(cl_command_queue1).clEnqueueWriteBuffer(cl_command_queue1, cl_mem1, cl_bool1, size_t1, size_t2, voidPtr1, cl_uint1, cl_eventPtr1, cl_eventPtr2);
    }

    @Override
    public int clEnqueueWriteImage(long cl_command_queue1, long cl_mem1, int cl_bool1, long size_tPtr1, long size_tPtr2, long size_t1, long size_t2, long voidPtr1, int cl_uint1, long cl_eventPtr1, long cl_eventPtr2) {
        return this.getImplementation(cl_command_queue1).clEnqueueWriteImage(cl_command_queue1, cl_mem1, cl_bool1, size_tPtr1, size_tPtr2, size_t1, size_t2, voidPtr1, cl_uint1, cl_eventPtr1, cl_eventPtr2);
    }

    @Override
    public int clFinish(long cl_command_queue1) {
        return this.getImplementation(cl_command_queue1).clFinish(cl_command_queue1);
    }

    @Override
    public int clFlush(long cl_command_queue1) {
        return this.getImplementation(cl_command_queue1).clFlush(cl_command_queue1);
    }

    @Override
    public int clGetCommandQueueInfo(long cl_command_queue1, int cl_command_queue_info1, long size_t1, long voidPtr1, long size_tPtr1) {
        return this.getImplementation(cl_command_queue1).clGetCommandQueueInfo(cl_command_queue1, cl_command_queue_info1, size_t1, voidPtr1, size_tPtr1);
    }

    @Override
    public int clGetContextInfo(long cl_context1, int cl_context_info1, long size_t1, long voidPtr1, long size_tPtr1) {
        return this.getImplementation(cl_context1).clGetContextInfo(cl_context1, cl_context_info1, size_t1, voidPtr1, size_tPtr1);
    }

    @Override
    public int clGetEventInfo(long cl_event1, int cl_event_info1, long size_t1, long voidPtr1, long size_tPtr1) {
        return this.getImplementation(cl_event1).clGetEventInfo(cl_event1, cl_event_info1, size_t1, voidPtr1, size_tPtr1);
    }

    @Override
    public int clGetEventProfilingInfo(long cl_event1, int cl_profiling_info1, long size_t1, long voidPtr1, long size_tPtr1) {
        return this.getImplementation(cl_event1).clGetEventProfilingInfo(cl_event1, cl_profiling_info1, size_t1, voidPtr1, size_tPtr1);
    }

    @Override
    public int clGetGLContextInfoAPPLE(long cl_context1, long voidPtr1, int cl_gl_platform_info1, long size_t1, long voidPtr2, long size_tPtr1) {
        return this.getImplementation(cl_context1).clGetGLContextInfoAPPLE(cl_context1, voidPtr1, cl_gl_platform_info1, size_t1, voidPtr2, size_tPtr1);
    }

    @Override
    public int clGetGLContextInfoKHR(long cl_context_propertiesPtr1, int cl_gl_context_info1, long size_t1, long voidPtr1, long size_tPtr1) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int clGetGLObjectInfo(long cl_mem1, long cl_gl_object_typePtr1, long cl_GLuintPtr1) {
        return this.getImplementation(cl_mem1).clGetGLObjectInfo(cl_mem1, cl_gl_object_typePtr1, cl_GLuintPtr1);
    }

    @Override
    public int clGetGLTextureInfo(long cl_mem1, int cl_gl_texture_info1, long size_t1, long voidPtr1, long size_tPtr1) {
        return this.getImplementation(cl_mem1).clGetGLTextureInfo(cl_mem1, cl_gl_texture_info1, size_t1, voidPtr1, size_tPtr1);
    }

    @Override
    public int clGetImageInfo(long cl_mem1, int cl_image_info1, long size_t1, long voidPtr1, long size_tPtr1) {
        return this.getImplementation(cl_mem1).clGetImageInfo(cl_mem1, cl_image_info1, size_t1, voidPtr1, size_tPtr1);
    }

    @Override
    public int clGetKernelArgInfo(long cl_kernel1, int cl_uint1, int cl_kernel_arg_info1, long size_t1, long voidPtr1, long size_tPtr1) {
        return this.getImplementation(cl_kernel1).clGetKernelArgInfo(cl_kernel1, cl_uint1, cl_kernel_arg_info1, size_t1, voidPtr1, size_tPtr1);
    }

    @Override
    public int clGetKernelInfo(long cl_kernel1, int cl_kernel_info1, long size_t1, long voidPtr1, long size_tPtr1) {
        return this.getImplementation(cl_kernel1).clGetKernelInfo(cl_kernel1, cl_kernel_info1, size_t1, voidPtr1, size_tPtr1);
    }

    @Override
    public int clGetKernelWorkGroupInfo(long cl_kernel1, long cl_device_id1, int cl_kernel_work_group_info1, long size_t1, long voidPtr1, long size_tPtr1) {
        return this.getImplementation(cl_kernel1).clGetKernelWorkGroupInfo(cl_kernel1, cl_device_id1, cl_kernel_work_group_info1, size_t1, voidPtr1, size_tPtr1);
    }

    @Override
    public int clGetMemObjectInfo(long cl_mem1, int cl_mem_info1, long size_t1, long voidPtr1, long size_tPtr1) {
        return this.getImplementation(cl_mem1).clGetMemObjectInfo(cl_mem1, cl_mem_info1, size_t1, voidPtr1, size_tPtr1);
    }

    @Override
    public int clGetProgramBuildInfo(long cl_program1, long cl_device_id1, int cl_program_build_info1, long size_t1, long voidPtr1, long size_tPtr1) {
        return this.getImplementation(cl_program1).clGetProgramBuildInfo(cl_program1, cl_device_id1, cl_program_build_info1, size_t1, voidPtr1, size_tPtr1);
    }

    @Override
    public int clGetProgramInfo(long cl_program1, int cl_program_info1, long size_t1, long voidPtr1, long size_tPtr1) {
        return this.getImplementation(cl_program1).clGetProgramInfo(cl_program1, cl_program_info1, size_t1, voidPtr1, size_tPtr1);
    }

    @Override
    public int clGetSamplerInfo(long cl_sampler1, int cl_sampler_info1, long size_t1, long voidPtr1, long size_tPtr1) {
        return this.getImplementation(cl_sampler1).clGetSamplerInfo(cl_sampler1, cl_sampler_info1, size_t1, voidPtr1, size_tPtr1);
    }

    @Override
    public int clGetSupportedImageFormats(long cl_context1, long cl_mem_flags1, int cl_mem_object_type1, int cl_uint1, long cl_image_formatPtr1, long cl_uintPtr1) {
        return this.getImplementation(cl_context1).clGetSupportedImageFormats(cl_context1, cl_mem_flags1, cl_mem_object_type1, cl_uint1, cl_image_formatPtr1, cl_uintPtr1);
    }

    @Override
    public int clReleaseCommandQueue(long cl_command_queue1) {
        return this.getImplementation(cl_command_queue1).clReleaseCommandQueue(cl_command_queue1);
    }

    @Override
    public int clReleaseContext(long cl_context1) {
        return this.getImplementation(cl_context1).clReleaseContext(cl_context1);
    }

    @Override
    public int clReleaseDevice(long cl_device_id1) {
        return this.getImplementation(cl_device_id1).clReleaseDevice(cl_device_id1);
    }

    @Override
    public int clReleaseDeviceEXT(long cl_device_id1) {
        return this.getImplementation(cl_device_id1).clReleaseDeviceEXT(cl_device_id1);
    }

    @Override
    public int clReleaseEvent(long cl_event1) {
        return this.getImplementation(cl_event1).clReleaseEvent(cl_event1);
    }

    @Override
    public int clReleaseKernel(long cl_kernel1) {
        return this.getImplementation(cl_kernel1).clReleaseKernel(cl_kernel1);
    }

    @Override
    public int clReleaseMemObject(long cl_mem1) {
        return this.getImplementation(cl_mem1).clReleaseMemObject(cl_mem1);
    }

    @Override
    public int clReleaseProgram(long cl_program1) {
        return this.getImplementation(cl_program1).clReleaseProgram(cl_program1);
    }

    @Override
    public int clReleaseSampler(long cl_sampler1) {
        return this.getImplementation(cl_sampler1).clReleaseSampler(cl_sampler1);
    }

    @Override
    public int clRetainCommandQueue(long cl_command_queue1) {
        return this.getImplementation(cl_command_queue1).clRetainCommandQueue(cl_command_queue1);
    }

    @Override
    public int clRetainContext(long cl_context1) {
        return this.getImplementation(cl_context1).clRetainContext(cl_context1);
    }

    @Override
    public int clRetainDevice(long cl_device_id1) {
        return this.getImplementation(cl_device_id1).clRetainDevice(cl_device_id1);
    }

    @Override
    public int clRetainDeviceEXT(long cl_device_id1) {
        return this.getImplementation(cl_device_id1).clRetainDeviceEXT(cl_device_id1);
    }

    @Override
    public int clRetainEvent(long cl_event1) {
        return this.getImplementation(cl_event1).clRetainEvent(cl_event1);
    }

    @Override
    public int clRetainKernel(long cl_kernel1) {
        return this.getImplementation(cl_kernel1).clRetainKernel(cl_kernel1);
    }

    @Override
    public int clRetainMemObject(long cl_mem1) {
        return this.getImplementation(cl_mem1).clRetainMemObject(cl_mem1);
    }

    @Override
    public int clRetainProgram(long cl_program1) {
        return this.getImplementation(cl_program1).clRetainProgram(cl_program1);
    }

    @Override
    public int clRetainSampler(long cl_sampler1) {
        return this.getImplementation(cl_sampler1).clRetainSampler(cl_sampler1);
    }

    @Override
    public int clSetCommandQueueProperty(long cl_command_queue1, long cl_command_queue_properties1, int cl_bool1, long cl_command_queue_propertiesPtr1) {
        return this.getImplementation(cl_command_queue1).clSetCommandQueueProperty(cl_command_queue1, cl_command_queue_properties1, cl_bool1, cl_command_queue_propertiesPtr1);
    }

    @Override
    public int clSetEventCallback(long cl_event1, int cl_int1, long arg1, long voidPtr1) {
        return this.getImplementation(cl_event1).clSetEventCallback(cl_event1, cl_int1, arg1, voidPtr1);
    }

    @Override
    public int clSetKernelArg(long cl_kernel1, int cl_uint1, long size_t1, long voidPtr1) {
        return this.getImplementation(cl_kernel1).clSetKernelArg(cl_kernel1, cl_uint1, size_t1, voidPtr1);
    }

    @Override
    public int clSetMemObjectDestructorCallback(long cl_mem1, long arg1, long voidPtr1) {
        return this.getImplementation(cl_mem1).clSetMemObjectDestructorCallback(cl_mem1, arg1, voidPtr1);
    }

    @Override
    public int clSetUserEventStatus(long cl_event1, int cl_int1) {
        return this.getImplementation(cl_event1).clSetUserEventStatus(cl_event1, cl_int1);
    }

    @Override
    public int clUnloadCompiler() {
        for (IOpenCLLibrary implementation : this.implementations) {
            int res = implementation.clUnloadCompiler();
            if (res == 0) continue;
            return res;
        }
        return 0;
    }

    @Override
    public int clUnloadPlatformCompiler(long cl_platform_id1) {
        return this.getImplementation(cl_platform_id1).clUnloadPlatformCompiler(cl_platform_id1);
    }

    @Override
    public int clWaitForEvents(int cl_uint1, long cl_eventPtr1) {
        throw new UnsupportedOperationException();
    }

    static /* synthetic */ Pointer access$000() {
        return icdDispatchTable;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class IcdEntity
    extends StructObject {
        @Field(value=0)
        public Pointer<?> icdDispatchTable = ProxiedOpenCLImplementation.access$000();
        @Field(value=1)
        public int implementationIndex;
        @Field(value=2)
        public int entityIndex;

        public IcdEntity() {
        }

        public IcdEntity(Pointer<? extends IcdEntity> peer, Object ... targs) {
            super(peer, new Object[0]);
        }
    }
}

