/*
 * Decompiled with CFR 0.152.
 */
package com.nbsaas.codegen;

import com.google.common.base.Predicate;
import com.nbsaas.codegen.command.ActionCommand;
import com.nbsaas.codegen.command.ClearCommand;
import com.nbsaas.codegen.command.DaoCommand;
import com.nbsaas.codegen.command.ManagerCommand;
import com.nbsaas.codegen.command.RestCommand;
import com.nbsaas.codegen.command.RouterPageCommand;
import com.nbsaas.codegen.command.SoCommand;
import com.nbsaas.codegen.fields.FieldBean;
import com.nbsaas.codegen.fields.FormBean;
import com.nbsaas.codegen.fields.FormBeanConver;
import com.nbsaas.codegen.handle.BeanHandle;
import com.nbsaas.codegen.template.hibernate.TemplateHibernateDir;
import com.nbsaas.codegen.templates.ace.TemplateAceDir;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.Id;
import org.apache.commons.chain.Context;
import org.apache.commons.chain.impl.ChainBase;
import org.apache.commons.chain.impl.ContextBase;
import org.reflections.ReflectionUtils;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChainMake {
    private Logger logger = LoggerFactory.getLogger((String)"imake");
    private File view;
    private boolean isAction = true;
    private boolean isDao = true;
    private boolean isService = false;
    private boolean isView = true;
    private boolean isSo = false;
    private boolean isRest = false;
    private String base;
    private String api;
    private boolean isApi = true;
    private String menus;
    private Class<?> dir;
    private Class<?> codeDir;
    private Map<String, Object> attributes = new HashMap<String, Object>();
    private String action;

    public boolean isSo() {
        return this.isSo;
    }

    public boolean isRest() {
        return this.isRest;
    }

    public void setRest(boolean rest) {
        this.isRest = rest;
    }

    public boolean isApi() {
        return this.isApi;
    }

    public void setApi(boolean api) {
        this.isApi = api;
    }

    public ChainMake(Class<?> dir, Class<?> codeDir) {
        this.dir = dir;
        this.codeDir = codeDir;
    }

    public ChainMake() {
        this.dir = TemplateAceDir.class;
        this.codeDir = TemplateHibernateDir.class;
    }

    public void put(String key, Object value) {
        this.attributes.put(key, value);
    }

    public boolean isAction() {
        return this.isAction;
    }

    public void setAction(boolean isAction) {
        this.isAction = isAction;
    }

    public boolean isDao() {
        return this.isDao;
    }

    public void setDao(boolean isDao) {
        this.isDao = isDao;
    }

    public boolean isService() {
        return this.isService;
    }

    public void setService(boolean isService) {
        this.isService = isService;
    }

    public boolean isView() {
        return this.isView;
    }

    public void setView(boolean isView) {
        this.isView = isView;
    }

    public void setSo(boolean isSo) {
        this.isSo = isSo;
    }

    public File getView() {
        return this.view;
    }

    public void setView(File view) {
        this.view = view;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public void clear(Class<?> entity) {
        ChainBase chain = new ChainBase();
        chain.addCommand(new ClearCommand());
        if (this.base == null) {
            String name = entity.getName();
            int len = name.indexOf("data.entity");
            this.base = name.substring(0, len - 1);
            this.action = this.base + ".controller.admin";
            this.api = this.base;
        }
        try {
            Context contex = this.makeContext(entity);
            chain.execute(contex);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void make(Class<?> entity) {
        ChainBase chain = new ChainBase();
        chain.addCommand(new DaoCommand());
        chain.addCommand(new ManagerCommand());
        chain.addCommand(new SoCommand());
        chain.addCommand(new ActionCommand());
        chain.addCommand(new RouterPageCommand());
        chain.addCommand(new RestCommand());
        if (this.base == null) {
            String name = entity.getName();
            int len = name.indexOf("data.entity");
            this.base = name.substring(0, len - 1);
            this.action = this.base + ".controller.admin";
            this.api = this.base;
        }
        try {
            Context contex = this.makeContext(entity);
            chain.execute(contex);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Context makeContext(Class<?> entity) {
        FormBean formBean = new FormBeanConver().converClass(entity);
        this.menus = formBean.getMenu();
        ContextBase context = new ContextBase();
        context.put("entity", entity);
        context.put("action", this.action);
        context.put("api", this.api);
        context.put("base", this.base);
        URL entityUrl = entity.getResource(".");
        if (entityUrl != null) {
            File entityPath = new File(entityUrl.getFile());
            context.put("basedir", entityPath.getParentFile());
        } else {
            this.logger.info("\u5b9e\u4f53\u8def\u5f84\u4e0d\u5b58\u5728");
        }
        context.put("config_entity", entity.getSimpleName().toLowerCase());
        context.put("view", this.view);
        context.put("isAction", this.isAction);
        context.put("isDao", this.isDao);
        context.put("isService", this.isService);
        context.put("isView", this.isView);
        context.put("isSo", this.isSo);
        context.put("dir", this.dir);
        context.put("menus", this.menus);
        context.put("codeDir", this.codeDir);
        context.put("bean", formBean);
        context.put("requests", new FormBeanConver().fields(entity));
        context.put("daoList", new FormBeanConver().daoBeans(entity));
        context.put("enumList", new FormBeanConver().enums(entity));
        Set<FieldBean> simples = new FormBeanConver().fieldsForSimple(entity);
        if (simples != null) {
            Long count = simples.stream().filter(item -> item.getType().equals("BigDecimal")).count();
            if (count > 0L) {
                context.put("haveBigDecimal", true);
            } else {
                context.put("haveBigDecimal", false);
            }
            Long dateCount = simples.stream().filter(item -> item.getType().equals("Date")).count();
            if (dateCount > 0L) {
                context.put("haveDate", true);
            } else {
                context.put("haveDate", false);
            }
        } else {
            context.put("haveBigDecimal", false);
            context.put("haveDate", false);
        }
        context.put("simples", new FormBeanConver().fieldsForSimple(entity));
        context.put("responses", new FormBeanConver().fieldsForResponse(entity));
        List<FieldBean> searchs = new FormBeanConver().search(entity);
        context.put("searchs", searchs);
        long size = searchs.stream().filter(item -> item.isShow()).count();
        long leftSize = 24L - size % 4L * 6L;
        if (leftSize == 0L) {
            leftSize = 24L;
        }
        context.put("leftSize", leftSize);
        context.put("isRest", this.isRest);
        String entityPackage = entity.getName();
        String lastpackage = entityPackage.substring(0, entityPackage.lastIndexOf("."));
        String packageBase = entityPackage.substring(0, lastpackage.lastIndexOf("."));
        context.put("dao_p", packageBase + ".dao");
        context.put("manager_p", packageBase + ".service");
        context.put("page_p", packageBase + ".page");
        context.put("so_p", packageBase + ".so");
        Set files = ReflectionUtils.getAllFields(entity, (Predicate[])new Predicate[0]);
        for (Field field : files) {
            Id id = field.getAnnotation(Id.class);
            if (id == null) continue;
            context.put("id", field.getType());
        }
        Reflections reflections = new Reflections("com.haoxuer.imake.handle", new Scanner[0]);
        Set ss = reflections.getSubTypesOf(BeanHandle.class);
        for (Class s : ss) {
            if (Modifier.isAbstract(s.getModifiers())) continue;
            try {
                BeanHandle beanHandle = (BeanHandle)s.newInstance();
                beanHandle.handle(entity, context);
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        Set<String> keys = this.attributes.keySet();
        for (String key : keys) {
            Object value = this.attributes.get(key);
            context.put(key, value);
        }
        return context;
    }

    public void makes(String packagestr) {
        Reflections reflections = new Reflections(packagestr, new Scanner[0]);
        Set ss = reflections.getTypesAnnotatedWith(Entity.class);
        for (Class class1 : ss) {
            this.make(class1);
        }
    }

    public void makes(Class<?> ... entitys) {
        for (Class<?> entity : entitys) {
            this.make(entity);
        }
    }

    public void makes(List<Class<?>> entitys) {
        for (Class<?> entity : entitys) {
            this.make(entity);
        }
    }
}

