/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.chain.impl;

import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.chain.Chain;
import org.apache.commons.chain.Command;
import org.apache.commons.chain.Context;
import org.apache.commons.chain.Filter;

public class ChainBase
implements Chain {
    protected Command[] commands = new Command[0];
    protected boolean frozen = false;

    public ChainBase() {
    }

    public ChainBase(Command command) {
        this.addCommand(command);
    }

    public ChainBase(Command[] commands) {
        if (commands == null) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < commands.length; ++i) {
            this.addCommand(commands[i]);
        }
    }

    public ChainBase(Collection commands) {
        if (commands == null) {
            throw new IllegalArgumentException();
        }
        Iterator elements = commands.iterator();
        while (elements.hasNext()) {
            this.addCommand((Command)elements.next());
        }
    }

    @Override
    public void addCommand(Command command) {
        if (command == null) {
            throw new IllegalArgumentException();
        }
        if (this.frozen) {
            throw new IllegalStateException();
        }
        Command[] results = new Command[this.commands.length + 1];
        System.arraycopy(this.commands, 0, results, 0, this.commands.length);
        results[this.commands.length] = command;
        this.commands = results;
    }

    @Override
    public boolean execute(Context context) throws Exception {
        if (context == null) {
            throw new IllegalArgumentException();
        }
        this.frozen = true;
        boolean saveResult = false;
        Exception saveException = null;
        int i = 0;
        int n = this.commands.length;
        for (i = 0; i < n; ++i) {
            try {
                saveResult = this.commands[i].execute(context);
                if (!saveResult) continue;
            }
            catch (Exception e) {
                saveException = e;
            }
            break;
        }
        if (i >= n) {
            --i;
        }
        boolean handled = false;
        boolean result = false;
        for (int j = i; j >= 0; --j) {
            if (!(this.commands[j] instanceof Filter)) continue;
            try {
                result = ((Filter)this.commands[j]).postprocess(context, saveException);
                if (!result) continue;
                handled = true;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (saveException != null && !handled) {
            throw saveException;
        }
        return saveResult;
    }

    Command[] getCommands() {
        return this.commands;
    }
}

