/*
 * Decompiled with CFR 0.152.
 */
package com.ncryptify;

import com.google.api.client.http.ByteArrayContent;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.http.json.JsonHttpContent;
import com.google.api.client.json.GenericJson;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonObjectParser;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.ObjectParser;
import com.ncryptify.Account;
import com.ncryptify.KeyNotFoundException;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Date;

public class RestClient {
    private static HttpTransport HTTP_TRANSPORT;
    static final JsonFactory JSON_FACTORY;
    public static final String NCRYPTIFY_URL;
    private static String httpProxyHost;
    private static int httpProxyPort;
    private String clientId;
    private String clientSecret;
    private String issuer;
    private String subject;
    private int expiresInMinutes;
    private Date renewal;
    private String token;

    public RestClient(String clientId, String clientSecret, String issuer, String subject, int expiresInMinutes) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.issuer = issuer;
        this.subject = subject;
        this.expiresInMinutes = expiresInMinutes;
        this.renewal = this.setRenewal();
        this.token = RestClient.constructJwt(clientId, clientSecret, issuer, subject, expiresInMinutes);
    }

    public RestClient(String jwt) {
        this.token = jwt;
    }

    public static void setProxy(String proxyURL) throws IllegalArgumentException {
        if (proxyURL != null) {
            URL url;
            try {
                url = new URL(proxyURL);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
            if (!url.getProtocol().startsWith("http")) {
                throw new IllegalArgumentException("Protocol not supported");
            }
            httpProxyHost = url.getHost();
            httpProxyPort = url.getPort();
        } else {
            httpProxyHost = null;
            httpProxyPort = 0;
        }
        HTTP_TRANSPORT = null;
    }

    HttpTransport getHttpTransport() {
        if (HTTP_TRANSPORT == null) {
            if (httpProxyHost != null && !httpProxyHost.isEmpty()) {
                try {
                    Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(httpProxyHost, httpProxyPort));
                    HTTP_TRANSPORT = new NetHttpTransport.Builder().setProxy(proxy).build();
                }
                catch (Exception e) {
                    throw new ExceptionInInitializerError(e);
                }
            } else {
                HTTP_TRANSPORT = new NetHttpTransport.Builder().build();
            }
        }
        return HTTP_TRANSPORT;
    }

    public KeyResponse getKey(String keyNameOrId) throws IOException, KeyNotFoundException {
        HttpRequestFactory requestFactory = this.getHttpTransport().createRequestFactory(new HttpRequestInitializer(){

            public void initialize(HttpRequest request) {
                request.getHeaders().setAuthorization("Bearer " + RestClient.this.getToken());
                request.getHeaders().setUserAgent("ncryptify_client/java");
                request.getHeaders().setAccept("application/json");
                request.setParser((ObjectParser)new JsonObjectParser(JSON_FACTORY));
            }
        });
        String name = URLEncoder.encode(keyNameOrId, "UTF-8");
        GenericUrl url = new GenericUrl(NCRYPTIFY_URL + "/vault/keys/" + name);
        HttpRequest request = requestFactory.buildGetRequest(url);
        try {
            HttpResponse response = request.execute();
            KeyResponse keyResponse = (KeyResponse)response.parseAs(KeyResponse.class);
            return keyResponse;
        }
        catch (HttpResponseException e) {
            if (e.getStatusCode() == 404) {
                throw new KeyNotFoundException("Key not found");
            }
            throw e;
        }
    }

    public KeyResponse createKey(String keyNameOrId) throws IOException {
        HttpRequestFactory requestFactory = this.getHttpTransport().createRequestFactory(new HttpRequestInitializer(){

            public void initialize(HttpRequest request) {
                request.getHeaders().setAuthorization("Bearer " + RestClient.this.getToken());
                request.getHeaders().setUserAgent("ncryptify_client/java");
                request.getHeaders().setContentType("application/json");
                request.getHeaders().setAccept("application/json");
                request.setParser((ObjectParser)new JsonObjectParser(JSON_FACTORY));
            }
        });
        KeyRequestBody keyRequestBody = new KeyRequestBody(keyNameOrId);
        GenericUrl url = new GenericUrl(NCRYPTIFY_URL + "/vault/keys?returnExisting=true");
        HttpRequest request = requestFactory.buildPostRequest(url, (HttpContent)new JsonHttpContent(JSON_FACTORY, (Object)keyRequestBody));
        return (KeyResponse)request.execute().parseAs(KeyResponse.class);
    }

    public void deleteKey(String keyNameOrId) throws IOException, KeyNotFoundException {
        try {
            HttpRequestFactory requestFactory = this.getHttpTransport().createRequestFactory(new HttpRequestInitializer(){

                public void initialize(HttpRequest request) {
                    request.getHeaders().setAuthorization("Bearer " + RestClient.this.getToken());
                    request.getHeaders().setUserAgent("ncryptify_client/java");
                    request.getHeaders().setAccept("application/json");
                    request.setParser((ObjectParser)new JsonObjectParser(JSON_FACTORY));
                }
            });
            GenericUrl url = new GenericUrl(NCRYPTIFY_URL + "/vault/keys/" + keyNameOrId);
            HttpRequest request = requestFactory.buildDeleteRequest(url);
            request.execute();
        }
        catch (HttpResponseException e) {
            if (e.getStatusCode() == 404) {
                throw new KeyNotFoundException("Key not found");
            }
            throw e;
        }
    }

    public RandomResponse getRandom(int bytes) throws IOException {
        HttpRequestFactory requestFactory = this.getHttpTransport().createRequestFactory(new HttpRequestInitializer(){

            public void initialize(HttpRequest request) {
                request.getHeaders().setAuthorization("Bearer " + RestClient.this.getToken());
                request.getHeaders().setUserAgent("ncryptify_client/java");
                request.getHeaders().setAccept("application/json");
                request.setParser((ObjectParser)new JsonObjectParser(JSON_FACTORY));
            }
        });
        GenericUrl url = new GenericUrl(NCRYPTIFY_URL + "/vault/random?bytes=" + Integer.toString(bytes));
        HttpRequest request = requestFactory.buildGetRequest(url);
        HttpResponse response = request.execute();
        RandomResponse randomResponse = (RandomResponse)response.parseAs(RandomResponse.class);
        return randomResponse;
    }

    public String postFpeAction(String cmd, String value, String keyName, String hint) throws IOException {
        return this.postFpeAction(cmd, value, keyName, hint, "");
    }

    public String postFpeAction(String cmd, String value, String keyName, String hint, String tweak) throws IOException {
        HttpRequestFactory requestFactory = this.getHttpTransport().createRequestFactory(new HttpRequestInitializer(){

            public void initialize(HttpRequest request) {
                request.getHeaders().setAuthorization("Bearer " + RestClient.this.getToken());
                request.getHeaders().setUserAgent("ncryptify_client/java");
                request.getHeaders().setContentType("text/plain;");
                request.getHeaders().setAccept("text/plain");
            }
        });
        GenericUrl url = new GenericUrl(NCRYPTIFY_URL + "/crypto/" + cmd).set("keyName", (Object)keyName).set("hint", (Object)hint);
        if (tweak.length() > 0) {
            url.set("tweak", (Object)tweak);
        }
        HttpRequest request = requestFactory.buildPostRequest(url, (HttpContent)new ByteArrayContent("text", value.getBytes(Charset.forName("UTF-8"))));
        HttpResponse response = request.execute();
        return response.parseAsString();
    }

    public Account getAccount() throws IOException {
        HttpRequestFactory requestFactory = this.getHttpTransport().createRequestFactory(new HttpRequestInitializer(){

            public void initialize(HttpRequest request) {
                request.getHeaders().setAuthorization("Bearer " + RestClient.this.getToken());
                request.getHeaders().setUserAgent("ncryptify_client/java");
                request.getHeaders().setAccept("application/json");
                request.setParser((ObjectParser)new JsonObjectParser(JSON_FACTORY));
            }
        });
        GenericUrl url = new GenericUrl(NCRYPTIFY_URL + "/admin/account");
        HttpRequest request = requestFactory.buildGetRequest(url);
        return (Account)request.execute().parseAs(Account.class);
    }

    public String getToken() {
        Date now = new Date();
        if (this.clientId != null && this.clientSecret != null && now.after(this.renewal)) {
            this.renewal = this.setRenewal();
            this.token = RestClient.constructJwt(this.clientId, this.clientSecret, this.issuer, this.subject, this.expiresInMinutes);
        }
        return this.token;
    }

    KeyRequestBody getKeyRequestBody(String name, String meta, String usage) {
        return new KeyRequestBody(name, meta, usage);
    }

    public static String constructJwt(String clientId, String clientSecret, String issuer, String subject, int expiresInMinutes) {
        JwtBuilder jwtBuilder = Jwts.builder();
        jwtBuilder.setHeaderParam("typ", (Object)"JWT");
        jwtBuilder.setAudience(clientId);
        jwtBuilder.setIssuer(issuer);
        jwtBuilder.setSubject(subject);
        Date now = new Date();
        jwtBuilder.setIssuedAt(now);
        jwtBuilder.setExpiration(new Date(now.getTime() + (long)(expiresInMinutes * 60 * 1000)));
        return jwtBuilder.signWith(SignatureAlgorithm.HS256, clientSecret.getBytes(Charset.forName("UTF-8"))).compact();
    }

    private Date setRenewal() {
        Date now = new Date();
        Date when = new Date(now.getTime() + (long)(this.expiresInMinutes * 60 * 1000) - 30000L);
        return when;
    }

    static {
        JSON_FACTORY = new JacksonFactory();
        NCRYPTIFY_URL = System.getenv("NCRYPTIFY_URL") != null ? System.getenv("NCRYPTIFY_URL") : "https://api.ncryptify.com/v1";
    }

    public static class LinkRequestBody
    extends GenericJson {
        @Key
        private String callback;

        LinkRequestBody(String callbackUrl) {
            this.callback = callbackUrl;
        }

        public String getCallback() {
            return this.callback;
        }
    }

    public static class KeyRequestBody
    extends GenericJson {
        @Key(value="name")
        private String name;
        @Key
        private String meta;
        @Key
        private String usage;

        KeyRequestBody(String name) {
            this.name = name;
        }

        KeyRequestBody(String name, String meta, String usage) {
            this.name = name;
            this.meta = meta;
            this.usage = usage;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getUsage() {
            return this.usage;
        }

        public void setUsage(String usage) {
            this.usage = usage;
        }

        public String getMeta() {
            return this.meta;
        }

        public void setMeta(String meta) {
            this.meta = meta;
        }
    }

    public static class RandomResponse {
        @Key
        private String material;

        public String getMaterial() {
            return this.material;
        }
    }

    public static class LinkResponse {
        @Key(value="linkauth_url")
        private String linkAuthUrl;

        public String getLinkAuthUrl() {
            return this.linkAuthUrl;
        }
    }

    public static class KeyResponse {
        @Key
        private String id;
        @Key
        private String name;
        @Key
        private String material;
        @Key
        private String createdAt;
        @Key
        private String updatedAt;
        @Key
        private String deletedAt;
        @Key
        private String usage;

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getMaterial() {
            return this.material;
        }

        public String getCreatedAt() {
            return this.createdAt;
        }

        public String getUpdatedAt() {
            return this.updatedAt;
        }

        public String getDeletedAt() {
            return this.deletedAt;
        }

        public String getUsage() {
            return this.usage;
        }
    }
}

