/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import io.swagger.client.ApiCallback;
import io.swagger.client.ApiClient;
import io.swagger.client.ApiException;
import io.swagger.client.ApiResponse;
import io.swagger.client.Configuration;
import io.swagger.client.Pair;
import io.swagger.client.ProgressRequestBody;
import io.swagger.client.ProgressResponseBody;
import io.swagger.client.model.ArrayOfElementDefinition;
import io.swagger.client.model.ArrayOfEventDefinition;
import io.swagger.client.model.ArrayOfSLAGlobalIndicatorDefinition;
import io.swagger.client.model.ArrayOfSLAPerIntervalDefinition;
import io.swagger.client.model.ArrayOfSLAPerTestDefinition;
import io.swagger.client.model.ArrayOfTestDefinition;
import io.swagger.client.model.CounterDefinition;
import io.swagger.client.model.CounterValues;
import io.swagger.client.model.ElementDefinition;
import io.swagger.client.model.ElementValues;
import io.swagger.client.model.EventType;
import io.swagger.client.model.MonitorPostRequest;
import io.swagger.client.model.Points;
import io.swagger.client.model.Sla;
import io.swagger.client.model.TestDefinition;
import io.swagger.client.model.TestRasterConfiguration;
import io.swagger.client.model.TestRasterMultiConfiguration;
import io.swagger.client.model.TestStatistics;
import io.swagger.client.model.TestUpdateRequest;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ResultsApi {
    private ApiClient apiClient;

    public ResultsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ResultsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call deleteTestCall(String testId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tests/{testId}".replaceAll("\\{testId\\}", this.apiClient.escapeString(testId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"NeoloadAuthorizer"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteTestValidateBeforeCall(String testId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (testId == null) {
            throw new ApiException("Missing the required parameter 'testId' when calling deleteTest(Async)");
        }
        Call call = this.deleteTestCall(testId, progressListener, progressRequestListener);
        return call;
    }

    public void deleteTest(String testId) throws ApiException {
        this.deleteTestWithHttpInfo(testId);
    }

    public ApiResponse<Void> deleteTestWithHttpInfo(String testId) throws ApiException {
        Call call = this.deleteTestValidateBeforeCall(testId, null, null);
        return this.apiClient.execute(call);
    }

    public Call deleteTestAsync(String testId, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteTestValidateBeforeCall(testId, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call getTestCall(String testId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tests/{testId}".replaceAll("\\{testId\\}", this.apiClient.escapeString(testId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"NeoloadAuthorizer"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getTestValidateBeforeCall(String testId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (testId == null) {
            throw new ApiException("Missing the required parameter 'testId' when calling getTest(Async)");
        }
        Call call = this.getTestCall(testId, progressListener, progressRequestListener);
        return call;
    }

    public TestDefinition getTest(String testId) throws ApiException {
        ApiResponse<TestDefinition> resp = this.getTestWithHttpInfo(testId);
        return resp.getData();
    }

    public ApiResponse<TestDefinition> getTestWithHttpInfo(String testId) throws ApiException {
        Call call = this.getTestValidateBeforeCall(testId, null, null);
        Type localVarReturnType = new TypeToken<TestDefinition>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getTestAsync(String testId, final ApiCallback<TestDefinition> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getTestValidateBeforeCall(testId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<TestDefinition>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getTestElementDefinitionCall(String testId, String elementId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tests/{testId}/elements/{elementId}".replaceAll("\\{testId\\}", this.apiClient.escapeString(testId.toString())).replaceAll("\\{elementId\\}", this.apiClient.escapeString(elementId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"NeoloadAuthorizer"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getTestElementDefinitionValidateBeforeCall(String testId, String elementId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (testId == null) {
            throw new ApiException("Missing the required parameter 'testId' when calling getTestElementDefinition(Async)");
        }
        if (elementId == null) {
            throw new ApiException("Missing the required parameter 'elementId' when calling getTestElementDefinition(Async)");
        }
        Call call = this.getTestElementDefinitionCall(testId, elementId, progressListener, progressRequestListener);
        return call;
    }

    public ElementDefinition getTestElementDefinition(String testId, String elementId) throws ApiException {
        ApiResponse<ElementDefinition> resp = this.getTestElementDefinitionWithHttpInfo(testId, elementId);
        return resp.getData();
    }

    public ApiResponse<ElementDefinition> getTestElementDefinitionWithHttpInfo(String testId, String elementId) throws ApiException {
        Call call = this.getTestElementDefinitionValidateBeforeCall(testId, elementId, null, null);
        Type localVarReturnType = new TypeToken<ElementDefinition>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getTestElementDefinitionAsync(String testId, String elementId, final ApiCallback<ElementDefinition> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getTestElementDefinitionValidateBeforeCall(testId, elementId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ElementDefinition>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getTestElementsCall(String testId, String category, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tests/{testId}/elements".replaceAll("\\{testId\\}", this.apiClient.escapeString(testId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (category != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("category", category));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"NeoloadAuthorizer"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getTestElementsValidateBeforeCall(String testId, String category, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (testId == null) {
            throw new ApiException("Missing the required parameter 'testId' when calling getTestElements(Async)");
        }
        if (category == null) {
            throw new ApiException("Missing the required parameter 'category' when calling getTestElements(Async)");
        }
        Call call = this.getTestElementsCall(testId, category, progressListener, progressRequestListener);
        return call;
    }

    public ArrayOfElementDefinition getTestElements(String testId, String category) throws ApiException {
        ApiResponse<ArrayOfElementDefinition> resp = this.getTestElementsWithHttpInfo(testId, category);
        return resp.getData();
    }

    public ApiResponse<ArrayOfElementDefinition> getTestElementsWithHttpInfo(String testId, String category) throws ApiException {
        Call call = this.getTestElementsValidateBeforeCall(testId, category, null, null);
        Type localVarReturnType = new TypeToken<ArrayOfElementDefinition>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getTestElementsAsync(String testId, String category, final ApiCallback<ArrayOfElementDefinition> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getTestElementsValidateBeforeCall(testId, category, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ArrayOfElementDefinition>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getTestElementsPointsCall(String testId, String elementId, String statistics, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tests/{testId}/elements/{elementId}/points".replaceAll("\\{testId\\}", this.apiClient.escapeString(testId.toString())).replaceAll("\\{elementId\\}", this.apiClient.escapeString(elementId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (statistics != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("statistics", statistics));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"NeoloadAuthorizer"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getTestElementsPointsValidateBeforeCall(String testId, String elementId, String statistics, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (testId == null) {
            throw new ApiException("Missing the required parameter 'testId' when calling getTestElementsPoints(Async)");
        }
        if (elementId == null) {
            throw new ApiException("Missing the required parameter 'elementId' when calling getTestElementsPoints(Async)");
        }
        if (statistics == null) {
            throw new ApiException("Missing the required parameter 'statistics' when calling getTestElementsPoints(Async)");
        }
        Call call = this.getTestElementsPointsCall(testId, elementId, statistics, progressListener, progressRequestListener);
        return call;
    }

    public Points getTestElementsPoints(String testId, String elementId, String statistics) throws ApiException {
        ApiResponse<Points> resp = this.getTestElementsPointsWithHttpInfo(testId, elementId, statistics);
        return resp.getData();
    }

    public ApiResponse<Points> getTestElementsPointsWithHttpInfo(String testId, String elementId, String statistics) throws ApiException {
        Call call = this.getTestElementsPointsValidateBeforeCall(testId, elementId, statistics, null, null);
        Type localVarReturnType = new TypeToken<Points>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getTestElementsPointsAsync(String testId, String elementId, String statistics, final ApiCallback<Points> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getTestElementsPointsValidateBeforeCall(testId, elementId, statistics, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Points>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getTestElementsSlaCall(String testId, String elementId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tests/{testId}/elements/{elementId}/sla".replaceAll("\\{testId\\}", this.apiClient.escapeString(testId.toString())).replaceAll("\\{elementId\\}", this.apiClient.escapeString(elementId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"NeoloadAuthorizer"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getTestElementsSlaValidateBeforeCall(String testId, String elementId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (testId == null) {
            throw new ApiException("Missing the required parameter 'testId' when calling getTestElementsSla(Async)");
        }
        if (elementId == null) {
            throw new ApiException("Missing the required parameter 'elementId' when calling getTestElementsSla(Async)");
        }
        Call call = this.getTestElementsSlaCall(testId, elementId, progressListener, progressRequestListener);
        return call;
    }

    public Sla getTestElementsSla(String testId, String elementId) throws ApiException {
        ApiResponse<Sla> resp = this.getTestElementsSlaWithHttpInfo(testId, elementId);
        return resp.getData();
    }

    public ApiResponse<Sla> getTestElementsSlaWithHttpInfo(String testId, String elementId) throws ApiException {
        Call call = this.getTestElementsSlaValidateBeforeCall(testId, elementId, null, null);
        Type localVarReturnType = new TypeToken<Sla>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getTestElementsSlaAsync(String testId, String elementId, final ApiCallback<Sla> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getTestElementsSlaValidateBeforeCall(testId, elementId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Sla>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getTestElementsValuesCall(String testId, String elementId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tests/{testId}/elements/{elementId}/values".replaceAll("\\{testId\\}", this.apiClient.escapeString(testId.toString())).replaceAll("\\{elementId\\}", this.apiClient.escapeString(elementId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"NeoloadAuthorizer"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getTestElementsValuesValidateBeforeCall(String testId, String elementId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (testId == null) {
            throw new ApiException("Missing the required parameter 'testId' when calling getTestElementsValues(Async)");
        }
        if (elementId == null) {
            throw new ApiException("Missing the required parameter 'elementId' when calling getTestElementsValues(Async)");
        }
        Call call = this.getTestElementsValuesCall(testId, elementId, progressListener, progressRequestListener);
        return call;
    }

    public ElementValues getTestElementsValues(String testId, String elementId) throws ApiException {
        ApiResponse<ElementValues> resp = this.getTestElementsValuesWithHttpInfo(testId, elementId);
        return resp.getData();
    }

    public ApiResponse<ElementValues> getTestElementsValuesWithHttpInfo(String testId, String elementId) throws ApiException {
        Call call = this.getTestElementsValuesValidateBeforeCall(testId, elementId, null, null);
        Type localVarReturnType = new TypeToken<ElementValues>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getTestElementsValuesAsync(String testId, String elementId, final ApiCallback<ElementValues> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getTestElementsValuesValidateBeforeCall(testId, elementId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ElementValues>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getTestEventsCall(String testId, List<EventType> types, Integer limit, Integer offset, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tests/{testId}/events".replaceAll("\\{testId\\}", this.apiClient.escapeString(testId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (types != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "types", types));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("offset", offset));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"NeoloadAuthorizer"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getTestEventsValidateBeforeCall(String testId, List<EventType> types, Integer limit, Integer offset, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (testId == null) {
            throw new ApiException("Missing the required parameter 'testId' when calling getTestEvents(Async)");
        }
        Call call = this.getTestEventsCall(testId, types, limit, offset, progressListener, progressRequestListener);
        return call;
    }

    public ArrayOfEventDefinition getTestEvents(String testId, List<EventType> types, Integer limit, Integer offset) throws ApiException {
        ApiResponse<ArrayOfEventDefinition> resp = this.getTestEventsWithHttpInfo(testId, types, limit, offset);
        return resp.getData();
    }

    public ApiResponse<ArrayOfEventDefinition> getTestEventsWithHttpInfo(String testId, List<EventType> types, Integer limit, Integer offset) throws ApiException {
        Call call = this.getTestEventsValidateBeforeCall(testId, types, limit, offset, null, null);
        Type localVarReturnType = new TypeToken<ArrayOfEventDefinition>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getTestEventsAsync(String testId, List<EventType> types, Integer limit, Integer offset, final ApiCallback<ArrayOfEventDefinition> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getTestEventsValidateBeforeCall(testId, types, limit, offset, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ArrayOfEventDefinition>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getTestGraphCall(String testId, TestRasterConfiguration body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        TestRasterConfiguration localVarPostBody = body;
        String localVarPath = "/tests/{testId}/graph".replaceAll("\\{testId\\}", this.apiClient.escapeString(testId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"image/png", "image/jpeg", "image/tiff", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"NeoloadAuthorizer"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getTestGraphValidateBeforeCall(String testId, TestRasterConfiguration body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (testId == null) {
            throw new ApiException("Missing the required parameter 'testId' when calling getTestGraph(Async)");
        }
        Call call = this.getTestGraphCall(testId, body, progressListener, progressRequestListener);
        return call;
    }

    public File getTestGraph(String testId, TestRasterConfiguration body) throws ApiException {
        ApiResponse<File> resp = this.getTestGraphWithHttpInfo(testId, body);
        return resp.getData();
    }

    public ApiResponse<File> getTestGraphWithHttpInfo(String testId, TestRasterConfiguration body) throws ApiException {
        Call call = this.getTestGraphValidateBeforeCall(testId, body, null, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getTestGraphAsync(String testId, TestRasterConfiguration body, final ApiCallback<File> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getTestGraphValidateBeforeCall(testId, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getTestMonitorDefinitionCall(String testId, String counterId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tests/{testId}/monitors/{counterId}".replaceAll("\\{testId\\}", this.apiClient.escapeString(testId.toString())).replaceAll("\\{counterId\\}", this.apiClient.escapeString(counterId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"NeoloadAuthorizer"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getTestMonitorDefinitionValidateBeforeCall(String testId, String counterId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (testId == null) {
            throw new ApiException("Missing the required parameter 'testId' when calling getTestMonitorDefinition(Async)");
        }
        if (counterId == null) {
            throw new ApiException("Missing the required parameter 'counterId' when calling getTestMonitorDefinition(Async)");
        }
        Call call = this.getTestMonitorDefinitionCall(testId, counterId, progressListener, progressRequestListener);
        return call;
    }

    public CounterDefinition getTestMonitorDefinition(String testId, String counterId) throws ApiException {
        ApiResponse<CounterDefinition> resp = this.getTestMonitorDefinitionWithHttpInfo(testId, counterId);
        return resp.getData();
    }

    public ApiResponse<CounterDefinition> getTestMonitorDefinitionWithHttpInfo(String testId, String counterId) throws ApiException {
        Call call = this.getTestMonitorDefinitionValidateBeforeCall(testId, counterId, null, null);
        Type localVarReturnType = new TypeToken<CounterDefinition>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getTestMonitorDefinitionAsync(String testId, String counterId, final ApiCallback<CounterDefinition> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getTestMonitorDefinitionValidateBeforeCall(testId, counterId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CounterDefinition>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getTestMonitorsCall(String testId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tests/{testId}/monitors".replaceAll("\\{testId\\}", this.apiClient.escapeString(testId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"NeoloadAuthorizer"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getTestMonitorsValidateBeforeCall(String testId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (testId == null) {
            throw new ApiException("Missing the required parameter 'testId' when calling getTestMonitors(Async)");
        }
        Call call = this.getTestMonitorsCall(testId, progressListener, progressRequestListener);
        return call;
    }

    public CounterDefinition getTestMonitors(String testId) throws ApiException {
        ApiResponse<CounterDefinition> resp = this.getTestMonitorsWithHttpInfo(testId);
        return resp.getData();
    }

    public ApiResponse<CounterDefinition> getTestMonitorsWithHttpInfo(String testId) throws ApiException {
        Call call = this.getTestMonitorsValidateBeforeCall(testId, null, null);
        Type localVarReturnType = new TypeToken<CounterDefinition>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getTestMonitorsAsync(String testId, final ApiCallback<CounterDefinition> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getTestMonitorsValidateBeforeCall(testId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CounterDefinition>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getTestMonitorsPointsCall(String testId, String counterId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tests/{testId}/monitors/{counterId}/points".replaceAll("\\{testId\\}", this.apiClient.escapeString(testId.toString())).replaceAll("\\{counterId\\}", this.apiClient.escapeString(counterId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"NeoloadAuthorizer"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getTestMonitorsPointsValidateBeforeCall(String testId, String counterId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (testId == null) {
            throw new ApiException("Missing the required parameter 'testId' when calling getTestMonitorsPoints(Async)");
        }
        if (counterId == null) {
            throw new ApiException("Missing the required parameter 'counterId' when calling getTestMonitorsPoints(Async)");
        }
        Call call = this.getTestMonitorsPointsCall(testId, counterId, progressListener, progressRequestListener);
        return call;
    }

    public Points getTestMonitorsPoints(String testId, String counterId) throws ApiException {
        ApiResponse<Points> resp = this.getTestMonitorsPointsWithHttpInfo(testId, counterId);
        return resp.getData();
    }

    public ApiResponse<Points> getTestMonitorsPointsWithHttpInfo(String testId, String counterId) throws ApiException {
        Call call = this.getTestMonitorsPointsValidateBeforeCall(testId, counterId, null, null);
        Type localVarReturnType = new TypeToken<Points>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getTestMonitorsPointsAsync(String testId, String counterId, final ApiCallback<Points> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getTestMonitorsPointsValidateBeforeCall(testId, counterId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Points>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getTestMonitorsValuesCall(String testId, String counterId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tests/{testId}/monitors/{counterId}/values".replaceAll("\\{testId\\}", this.apiClient.escapeString(testId.toString())).replaceAll("\\{counterId\\}", this.apiClient.escapeString(counterId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"NeoloadAuthorizer"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getTestMonitorsValuesValidateBeforeCall(String testId, String counterId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (testId == null) {
            throw new ApiException("Missing the required parameter 'testId' when calling getTestMonitorsValues(Async)");
        }
        if (counterId == null) {
            throw new ApiException("Missing the required parameter 'counterId' when calling getTestMonitorsValues(Async)");
        }
        Call call = this.getTestMonitorsValuesCall(testId, counterId, progressListener, progressRequestListener);
        return call;
    }

    public CounterValues getTestMonitorsValues(String testId, String counterId) throws ApiException {
        ApiResponse<CounterValues> resp = this.getTestMonitorsValuesWithHttpInfo(testId, counterId);
        return resp.getData();
    }

    public ApiResponse<CounterValues> getTestMonitorsValuesWithHttpInfo(String testId, String counterId) throws ApiException {
        Call call = this.getTestMonitorsValuesValidateBeforeCall(testId, counterId, null, null);
        Type localVarReturnType = new TypeToken<CounterValues>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getTestMonitorsValuesAsync(String testId, String counterId, final ApiCallback<CounterValues> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getTestMonitorsValuesValidateBeforeCall(testId, counterId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CounterValues>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getTestMultiGraphCall(TestRasterMultiConfiguration body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        TestRasterMultiConfiguration localVarPostBody = body;
        String localVarPath = "/tests/graph";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"image/png", "image/jpeg", "image/tiff", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"NeoloadAuthorizer"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getTestMultiGraphValidateBeforeCall(TestRasterMultiConfiguration body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getTestMultiGraphCall(body, progressListener, progressRequestListener);
        return call;
    }

    public File getTestMultiGraph(TestRasterMultiConfiguration body) throws ApiException {
        ApiResponse<File> resp = this.getTestMultiGraphWithHttpInfo(body);
        return resp.getData();
    }

    public ApiResponse<File> getTestMultiGraphWithHttpInfo(TestRasterMultiConfiguration body) throws ApiException {
        Call call = this.getTestMultiGraphValidateBeforeCall(body, null, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getTestMultiGraphAsync(TestRasterMultiConfiguration body, final ApiCallback<File> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getTestMultiGraphValidateBeforeCall(body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getTestSLAGlobalIndicatorsCall(String testId, String status, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tests/{testId}/slas/statistics".replaceAll("\\{testId\\}", this.apiClient.escapeString(testId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (status != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("status", status));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"NeoloadAuthorizer"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getTestSLAGlobalIndicatorsValidateBeforeCall(String testId, String status, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (testId == null) {
            throw new ApiException("Missing the required parameter 'testId' when calling getTestSLAGlobalIndicators(Async)");
        }
        Call call = this.getTestSLAGlobalIndicatorsCall(testId, status, progressListener, progressRequestListener);
        return call;
    }

    public ArrayOfSLAGlobalIndicatorDefinition getTestSLAGlobalIndicators(String testId, String status) throws ApiException {
        ApiResponse<ArrayOfSLAGlobalIndicatorDefinition> resp = this.getTestSLAGlobalIndicatorsWithHttpInfo(testId, status);
        return resp.getData();
    }

    public ApiResponse<ArrayOfSLAGlobalIndicatorDefinition> getTestSLAGlobalIndicatorsWithHttpInfo(String testId, String status) throws ApiException {
        Call call = this.getTestSLAGlobalIndicatorsValidateBeforeCall(testId, status, null, null);
        Type localVarReturnType = new TypeToken<ArrayOfSLAGlobalIndicatorDefinition>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getTestSLAGlobalIndicatorsAsync(String testId, String status, final ApiCallback<ArrayOfSLAGlobalIndicatorDefinition> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getTestSLAGlobalIndicatorsValidateBeforeCall(testId, status, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ArrayOfSLAGlobalIndicatorDefinition>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getTestSLAPerIntervalCall(String testId, String status, String category, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tests/{testId}/slas/per-interval".replaceAll("\\{testId\\}", this.apiClient.escapeString(testId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (status != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("status", status));
        }
        if (category != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("category", category));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"NeoloadAuthorizer"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getTestSLAPerIntervalValidateBeforeCall(String testId, String status, String category, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (testId == null) {
            throw new ApiException("Missing the required parameter 'testId' when calling getTestSLAPerInterval(Async)");
        }
        Call call = this.getTestSLAPerIntervalCall(testId, status, category, progressListener, progressRequestListener);
        return call;
    }

    public ArrayOfSLAPerIntervalDefinition getTestSLAPerInterval(String testId, String status, String category) throws ApiException {
        ApiResponse<ArrayOfSLAPerIntervalDefinition> resp = this.getTestSLAPerIntervalWithHttpInfo(testId, status, category);
        return resp.getData();
    }

    public ApiResponse<ArrayOfSLAPerIntervalDefinition> getTestSLAPerIntervalWithHttpInfo(String testId, String status, String category) throws ApiException {
        Call call = this.getTestSLAPerIntervalValidateBeforeCall(testId, status, category, null, null);
        Type localVarReturnType = new TypeToken<ArrayOfSLAPerIntervalDefinition>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getTestSLAPerIntervalAsync(String testId, String status, String category, final ApiCallback<ArrayOfSLAPerIntervalDefinition> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getTestSLAPerIntervalValidateBeforeCall(testId, status, category, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ArrayOfSLAPerIntervalDefinition>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getTestSLAPerTestCall(String testId, String status, String category, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tests/{testId}/slas/per-test".replaceAll("\\{testId\\}", this.apiClient.escapeString(testId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (status != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("status", status));
        }
        if (category != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("category", category));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"NeoloadAuthorizer"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getTestSLAPerTestValidateBeforeCall(String testId, String status, String category, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (testId == null) {
            throw new ApiException("Missing the required parameter 'testId' when calling getTestSLAPerTest(Async)");
        }
        Call call = this.getTestSLAPerTestCall(testId, status, category, progressListener, progressRequestListener);
        return call;
    }

    public ArrayOfSLAPerTestDefinition getTestSLAPerTest(String testId, String status, String category) throws ApiException {
        ApiResponse<ArrayOfSLAPerTestDefinition> resp = this.getTestSLAPerTestWithHttpInfo(testId, status, category);
        return resp.getData();
    }

    public ApiResponse<ArrayOfSLAPerTestDefinition> getTestSLAPerTestWithHttpInfo(String testId, String status, String category) throws ApiException {
        Call call = this.getTestSLAPerTestValidateBeforeCall(testId, status, category, null, null);
        Type localVarReturnType = new TypeToken<ArrayOfSLAPerTestDefinition>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getTestSLAPerTestAsync(String testId, String status, String category, final ApiCallback<ArrayOfSLAPerTestDefinition> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getTestSLAPerTestValidateBeforeCall(testId, status, category, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ArrayOfSLAPerTestDefinition>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getTestStatisticsCall(String testId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tests/{testId}/statistics".replaceAll("\\{testId\\}", this.apiClient.escapeString(testId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"NeoloadAuthorizer"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getTestStatisticsValidateBeforeCall(String testId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (testId == null) {
            throw new ApiException("Missing the required parameter 'testId' when calling getTestStatistics(Async)");
        }
        Call call = this.getTestStatisticsCall(testId, progressListener, progressRequestListener);
        return call;
    }

    public TestStatistics getTestStatistics(String testId) throws ApiException {
        ApiResponse<TestStatistics> resp = this.getTestStatisticsWithHttpInfo(testId);
        return resp.getData();
    }

    public ApiResponse<TestStatistics> getTestStatisticsWithHttpInfo(String testId) throws ApiException {
        Call call = this.getTestStatisticsValidateBeforeCall(testId, null, null);
        Type localVarReturnType = new TypeToken<TestStatistics>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getTestStatisticsAsync(String testId, final ApiCallback<TestStatistics> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getTestStatisticsValidateBeforeCall(testId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<TestStatistics>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getTestsCall(String status, String project, String author, Integer limit, Integer offset, String fields, Boolean pretty, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tests";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (status != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("status", status));
        }
        if (project != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("project", project));
        }
        if (author != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("author", author));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("offset", offset));
        }
        if (fields != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("fields", fields));
        }
        if (pretty != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("pretty", pretty));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"NeoloadAuthorizer"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getTestsValidateBeforeCall(String status, String project, String author, Integer limit, Integer offset, String fields, Boolean pretty, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getTestsCall(status, project, author, limit, offset, fields, pretty, progressListener, progressRequestListener);
        return call;
    }

    public ArrayOfTestDefinition getTests(String status, String project, String author, Integer limit, Integer offset, String fields, Boolean pretty) throws ApiException {
        ApiResponse<ArrayOfTestDefinition> resp = this.getTestsWithHttpInfo(status, project, author, limit, offset, fields, pretty);
        return resp.getData();
    }

    public ApiResponse<ArrayOfTestDefinition> getTestsWithHttpInfo(String status, String project, String author, Integer limit, Integer offset, String fields, Boolean pretty) throws ApiException {
        Call call = this.getTestsValidateBeforeCall(status, project, author, limit, offset, fields, pretty, null, null);
        Type localVarReturnType = new TypeToken<ArrayOfTestDefinition>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getTestsAsync(String status, String project, String author, Integer limit, Integer offset, String fields, Boolean pretty, final ApiCallback<ArrayOfTestDefinition> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getTestsValidateBeforeCall(status, project, author, limit, offset, fields, pretty, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ArrayOfTestDefinition>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call postTestMonitorsCall(MonitorPostRequest body, String testId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        MonitorPostRequest localVarPostBody = body;
        String localVarPath = "/tests/{testId}/monitors".replaceAll("\\{testId\\}", this.apiClient.escapeString(testId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"NeoloadAuthorizer"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call postTestMonitorsValidateBeforeCall(MonitorPostRequest body, String testId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling postTestMonitors(Async)");
        }
        if (testId == null) {
            throw new ApiException("Missing the required parameter 'testId' when calling postTestMonitors(Async)");
        }
        Call call = this.postTestMonitorsCall(body, testId, progressListener, progressRequestListener);
        return call;
    }

    public void postTestMonitors(MonitorPostRequest body, String testId) throws ApiException {
        this.postTestMonitorsWithHttpInfo(body, testId);
    }

    public ApiResponse<Void> postTestMonitorsWithHttpInfo(MonitorPostRequest body, String testId) throws ApiException {
        Call call = this.postTestMonitorsValidateBeforeCall(body, testId, null, null);
        return this.apiClient.execute(call);
    }

    public Call postTestMonitorsAsync(MonitorPostRequest body, String testId, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.postTestMonitorsValidateBeforeCall(body, testId, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call updateTestCall(TestUpdateRequest body, String testId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        TestUpdateRequest localVarPostBody = body;
        String localVarPath = "/tests/{testId}".replaceAll("\\{testId\\}", this.apiClient.escapeString(testId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"NeoloadAuthorizer"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateTestValidateBeforeCall(TestUpdateRequest body, String testId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling updateTest(Async)");
        }
        if (testId == null) {
            throw new ApiException("Missing the required parameter 'testId' when calling updateTest(Async)");
        }
        Call call = this.updateTestCall(body, testId, progressListener, progressRequestListener);
        return call;
    }

    public TestDefinition updateTest(TestUpdateRequest body, String testId) throws ApiException {
        ApiResponse<TestDefinition> resp = this.updateTestWithHttpInfo(body, testId);
        return resp.getData();
    }

    public ApiResponse<TestDefinition> updateTestWithHttpInfo(TestUpdateRequest body, String testId) throws ApiException {
        Call call = this.updateTestValidateBeforeCall(body, testId, null, null);
        Type localVarReturnType = new TypeToken<TestDefinition>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call updateTestAsync(TestUpdateRequest body, String testId, final ApiCallback<TestDefinition> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateTestValidateBeforeCall(body, testId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<TestDefinition>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

