/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import io.swagger.client.ApiCallback;
import io.swagger.client.ApiClient;
import io.swagger.client.ApiException;
import io.swagger.client.ApiResponse;
import io.swagger.client.Configuration;
import io.swagger.client.Pair;
import io.swagger.client.ProgressRequestBody;
import io.swagger.client.ProgressResponseBody;
import io.swagger.client.model.ProjectDefinition;
import io.swagger.client.model.RunTestDefinition;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class RuntimeApi {
    private ApiClient apiClient;

    public RuntimeApi() {
        this(Configuration.getDefaultApiClient());
    }

    public RuntimeApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call getTestsRunCall(String name, String projectId, String scenarioName, String description, String asCode, String reservationId, Long reservationDuration, Integer reservationWebVUs, Integer reservationSAPVUs, String controllerZoneId, String lgZones, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/projects/{projectId}/run".replaceAll("\\{projectId\\}", this.apiClient.escapeString(projectId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (name != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("name", name));
        }
        if (description != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("description", description));
        }
        if (asCode != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("asCode", asCode));
        }
        if (scenarioName != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("scenarioName", scenarioName));
        }
        if (reservationId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("reservationId", reservationId));
        }
        if (reservationDuration != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("reservationDuration", reservationDuration));
        }
        if (reservationWebVUs != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("reservationWebVUs", reservationWebVUs));
        }
        if (reservationSAPVUs != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("reservationSAPVUs", reservationSAPVUs));
        }
        if (controllerZoneId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("controllerZoneId", controllerZoneId));
        }
        if (lgZones != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("lgZones", lgZones));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"NeoloadAuthorizer"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getTestsRunValidateBeforeCall(String name, String projectId, String scenarioName, String description, String asCode, String reservationId, Long reservationDuration, Integer reservationWebVUs, Integer reservationSAPVUs, String controllerZoneId, String lgZones, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getTestsRun(Async)");
        }
        if (projectId == null) {
            throw new ApiException("Missing the required parameter 'projectId' when calling getTestsRun(Async)");
        }
        if (scenarioName == null) {
            throw new ApiException("Missing the required parameter 'scenarioName' when calling getTestsRun(Async)");
        }
        Call call = this.getTestsRunCall(name, projectId, scenarioName, description, asCode, reservationId, reservationDuration, reservationWebVUs, reservationSAPVUs, controllerZoneId, lgZones, progressListener, progressRequestListener);
        return call;
    }

    public RunTestDefinition getTestsRun(String name, String projectId, String scenarioName, String description, String asCode, String reservationId, Long reservationDuration, Integer reservationWebVUs, Integer reservationSAPVUs, String controllerZoneId, String lgZones) throws ApiException {
        ApiResponse<RunTestDefinition> resp = this.getTestsRunWithHttpInfo(name, projectId, scenarioName, description, asCode, reservationId, reservationDuration, reservationWebVUs, reservationSAPVUs, controllerZoneId, lgZones);
        return resp.getData();
    }

    public ApiResponse<RunTestDefinition> getTestsRunWithHttpInfo(String name, String projectId, String scenarioName, String description, String asCode, String reservationId, Long reservationDuration, Integer reservationWebVUs, Integer reservationSAPVUs, String controllerZoneId, String lgZones) throws ApiException {
        Call call = this.getTestsRunValidateBeforeCall(name, projectId, scenarioName, description, asCode, reservationId, reservationDuration, reservationWebVUs, reservationSAPVUs, controllerZoneId, lgZones, null, null);
        Type localVarReturnType = new TypeToken<RunTestDefinition>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getTestsRunAsync(String name, String projectId, String scenarioName, String description, String asCode, String reservationId, Long reservationDuration, Integer reservationWebVUs, Integer reservationSAPVUs, String controllerZoneId, String lgZones, final ApiCallback<RunTestDefinition> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getTestsRunValidateBeforeCall(name, projectId, scenarioName, description, asCode, reservationId, reservationDuration, reservationWebVUs, reservationSAPVUs, controllerZoneId, lgZones, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<RunTestDefinition>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call postUploadProjectCall(File file, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/projects";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (file != null) {
            localVarFormParams.put("file", file);
        }
        if ((localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"NeoloadAuthorizer"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call postUploadProjectValidateBeforeCall(File file, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (file == null) {
            throw new ApiException("Missing the required parameter 'file' when calling postUploadProject(Async)");
        }
        Call call = this.postUploadProjectCall(file, progressListener, progressRequestListener);
        return call;
    }

    public ProjectDefinition postUploadProject(File file) throws ApiException {
        ApiResponse<ProjectDefinition> resp = this.postUploadProjectWithHttpInfo(file);
        return resp.getData();
    }

    public ApiResponse<ProjectDefinition> postUploadProjectWithHttpInfo(File file) throws ApiException {
        Call call = this.postUploadProjectValidateBeforeCall(file, null, null);
        Type localVarReturnType = new TypeToken<ProjectDefinition>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call postUploadProjectAsync(File file, final ApiCallback<ProjectDefinition> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.postUploadProjectValidateBeforeCall(file, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ProjectDefinition>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

