/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.client.model.CustomMonitorValues;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class CustomMonitor {
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="path")
    private List<String> path = null;
    @SerializedName(value="unit")
    private String unit = null;
    @SerializedName(value="values")
    private CustomMonitorValues values = null;

    public CustomMonitor name(String name) {
        this.name = name;
        return this;
    }

    @Schema(description="Name of custom monitor.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CustomMonitor path(List<String> path) {
        this.path = path;
        return this;
    }

    public CustomMonitor addPathItem(String pathItem) {
        if (this.path == null) {
            this.path = new ArrayList<String>();
        }
        this.path.add(pathItem);
        return this;
    }

    @Schema(description="Path of the custom monitor.")
    public List<String> getPath() {
        return this.path;
    }

    public void setPath(List<String> path) {
        this.path = path;
    }

    public CustomMonitor unit(String unit) {
        this.unit = unit;
        return this;
    }

    @Schema(description="Unit of the custom monitor.")
    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public CustomMonitor values(CustomMonitorValues values) {
        this.values = values;
        return this;
    }

    @Schema(description="")
    public CustomMonitorValues getValues() {
        return this.values;
    }

    public void setValues(CustomMonitorValues values) {
        this.values = values;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomMonitor customMonitor = (CustomMonitor)o;
        return Objects.equals(this.name, customMonitor.name) && Objects.equals(this.path, customMonitor.path) && Objects.equals(this.unit, customMonitor.unit) && Objects.equals(this.values, customMonitor.values);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.path, this.unit, this.values);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CustomMonitor {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    unit: ").append(this.toIndentedString(this.unit)).append("\n");
        sb.append("    values: ").append(this.toIndentedString(this.values)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

