/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ElementDefinition {
    @SerializedName(value="id")
    private String id = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="path")
    private List<String> path = null;
    @SerializedName(value="type")
    private String type = null;

    public ElementDefinition id(String id) {
        this.id = id;
        return this;
    }

    @Schema(description="Unique identifier of the element.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ElementDefinition name(String name) {
        this.name = name;
        return this;
    }

    @Schema(description="Name of the element.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ElementDefinition path(List<String> path) {
        this.path = path;
        return this;
    }

    public ElementDefinition addPathItem(String pathItem) {
        if (this.path == null) {
            this.path = new ArrayList<String>();
        }
        this.path.add(pathItem);
        return this;
    }

    @Schema(description="Full path of the element including the element itself.")
    public List<String> getPath() {
        return this.path;
    }

    public void setPath(List<String> path) {
        this.path = path;
    }

    public ElementDefinition type(String type) {
        this.type = type;
        return this;
    }

    @Schema(description="Type of the element.")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ElementDefinition elementDefinition = (ElementDefinition)o;
        return Objects.equals(this.id, elementDefinition.id) && Objects.equals(this.name, elementDefinition.name) && Objects.equals(this.path, elementDefinition.path) && Objects.equals(this.type, elementDefinition.type);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.path, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ElementDefinition {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

