/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.client.model.ElementIdDefinition;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class TestRasterConfiguration {
    @SerializedName(value="width")
    private Integer width = null;
    @SerializedName(value="height")
    private Integer height = null;
    @SerializedName(value="title")
    private String title = null;
    @SerializedName(value="rasterType")
    private RasterTypeEnum rasterType = null;
    @SerializedName(value="xAxisLabel")
    private String xAxisLabel = null;
    @SerializedName(value="yAxisLabel")
    private String yAxisLabel = null;
    @SerializedName(value="legend")
    private Boolean legend = null;
    @SerializedName(value="multiYAxis")
    private Boolean multiYAxis = null;
    @SerializedName(value="theme")
    private ThemeEnum theme = null;
    @SerializedName(value="elementIds")
    private List<ElementIdDefinition> elementIds = null;
    @SerializedName(value="counterIds")
    private List<String> counterIds = null;

    public TestRasterConfiguration width(Integer width) {
        this.width = width;
        return this;
    }

    @Schema(example="600", description="The width of the generated graph.")
    public Integer getWidth() {
        return this.width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public TestRasterConfiguration height(Integer height) {
        this.height = height;
        return this;
    }

    @Schema(example="200", description="The height of the generated graph.")
    public Integer getHeight() {
        return this.height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public TestRasterConfiguration title(String title) {
        this.title = title;
        return this;
    }

    @Schema(example="My Test", description="The main title of the generated graph.")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public TestRasterConfiguration rasterType(RasterTypeEnum rasterType) {
        this.rasterType = rasterType;
        return this;
    }

    @Schema(example="PNG", description="The type of the generated graph. Can be PNG, TIFF or JPEG. Default is PNG.")
    public RasterTypeEnum getRasterType() {
        return this.rasterType;
    }

    public void setRasterType(RasterTypeEnum rasterType) {
        this.rasterType = rasterType;
    }

    public TestRasterConfiguration xAxisLabel(String xAxisLabel) {
        this.xAxisLabel = xAxisLabel;
        return this;
    }

    @Schema(example="X Axis", description="The xAxis label of the generated graph.")
    public String getXAxisLabel() {
        return this.xAxisLabel;
    }

    public void setXAxisLabel(String xAxisLabel) {
        this.xAxisLabel = xAxisLabel;
    }

    public TestRasterConfiguration yAxisLabel(String yAxisLabel) {
        this.yAxisLabel = yAxisLabel;
        return this;
    }

    @Schema(example="Y Axis", description="The yAxis label of the generated graph.")
    public String getYAxisLabel() {
        return this.yAxisLabel;
    }

    public void setYAxisLabel(String yAxisLabel) {
        this.yAxisLabel = yAxisLabel;
    }

    public TestRasterConfiguration legend(Boolean legend) {
        this.legend = legend;
        return this;
    }

    @Schema(example="false", description="If true the legend is displayed. Default is true.")
    public Boolean isLegend() {
        return this.legend;
    }

    public void setLegend(Boolean legend) {
        this.legend = legend;
    }

    public TestRasterConfiguration multiYAxis(Boolean multiYAxis) {
        this.multiYAxis = multiYAxis;
        return this;
    }

    @Schema(example="true", description="If true, display one axis per serie. Default is false.")
    public Boolean isMultiYAxis() {
        return this.multiYAxis;
    }

    public void setMultiYAxis(Boolean multiYAxis) {
        this.multiYAxis = multiYAxis;
    }

    public TestRasterConfiguration theme(ThemeEnum theme) {
        this.theme = theme;
        return this;
    }

    @Schema(example="DARK", description="The theme of the graph. Default is TRANSPARENT.")
    public ThemeEnum getTheme() {
        return this.theme;
    }

    public void setTheme(ThemeEnum theme) {
        this.theme = theme;
    }

    public TestRasterConfiguration elementIds(List<ElementIdDefinition> elementIds) {
        this.elementIds = elementIds;
        return this;
    }

    public TestRasterConfiguration addElementIdsItem(ElementIdDefinition elementIdsItem) {
        if (this.elementIds == null) {
            this.elementIds = new ArrayList<ElementIdDefinition>();
        }
        this.elementIds.add(elementIdsItem);
        return this;
    }

    @Schema(example="[{\"id\":\"all-requests\",\"statistics\":[\"AVG_DURATION\"]}]", description="The list of elements.")
    public List<ElementIdDefinition> getElementIds() {
        return this.elementIds;
    }

    public void setElementIds(List<ElementIdDefinition> elementIds) {
        this.elementIds = elementIds;
    }

    public TestRasterConfiguration counterIds(List<String> counterIds) {
        this.counterIds = counterIds;
        return this;
    }

    public TestRasterConfiguration addCounterIdsItem(String counterIdsItem) {
        if (this.counterIds == null) {
            this.counterIds = new ArrayList<String>();
        }
        this.counterIds.add(counterIdsItem);
        return this;
    }

    @Schema(example="[\"a4bed45a-06b2-48e1-94fd-3ea979e4f360\",\"b5be82ff-3563-4812-93a5-4ea888e4e254\"]", description="The list of counters.")
    public List<String> getCounterIds() {
        return this.counterIds;
    }

    public void setCounterIds(List<String> counterIds) {
        this.counterIds = counterIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestRasterConfiguration testRasterConfiguration = (TestRasterConfiguration)o;
        return Objects.equals(this.width, testRasterConfiguration.width) && Objects.equals(this.height, testRasterConfiguration.height) && Objects.equals(this.title, testRasterConfiguration.title) && Objects.equals((Object)this.rasterType, (Object)testRasterConfiguration.rasterType) && Objects.equals(this.xAxisLabel, testRasterConfiguration.xAxisLabel) && Objects.equals(this.yAxisLabel, testRasterConfiguration.yAxisLabel) && Objects.equals(this.legend, testRasterConfiguration.legend) && Objects.equals(this.multiYAxis, testRasterConfiguration.multiYAxis) && Objects.equals((Object)this.theme, (Object)testRasterConfiguration.theme) && Objects.equals(this.elementIds, testRasterConfiguration.elementIds) && Objects.equals(this.counterIds, testRasterConfiguration.counterIds);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.width, this.height, this.title, this.rasterType, this.xAxisLabel, this.yAxisLabel, this.legend, this.multiYAxis, this.theme, this.elementIds, this.counterIds});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TestRasterConfiguration {\n");
        sb.append("    width: ").append(this.toIndentedString(this.width)).append("\n");
        sb.append("    height: ").append(this.toIndentedString(this.height)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    rasterType: ").append(this.toIndentedString((Object)this.rasterType)).append("\n");
        sb.append("    xAxisLabel: ").append(this.toIndentedString(this.xAxisLabel)).append("\n");
        sb.append("    yAxisLabel: ").append(this.toIndentedString(this.yAxisLabel)).append("\n");
        sb.append("    legend: ").append(this.toIndentedString(this.legend)).append("\n");
        sb.append("    multiYAxis: ").append(this.toIndentedString(this.multiYAxis)).append("\n");
        sb.append("    theme: ").append(this.toIndentedString((Object)this.theme)).append("\n");
        sb.append("    elementIds: ").append(this.toIndentedString(this.elementIds)).append("\n");
        sb.append("    counterIds: ").append(this.toIndentedString(this.counterIds)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ThemeEnum {
        DARK("DARK"),
        LIGHT("LIGHT"),
        TRANSPARENT("TRANSPARENT");

        private String value;

        private ThemeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ThemeEnum fromValue(String text) {
            for (ThemeEnum b : ThemeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ThemeEnum> {
            public void write(JsonWriter jsonWriter, ThemeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ThemeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ThemeEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum RasterTypeEnum {
        PNG("PNG"),
        TIFF("TIFF"),
        JPEG("JPEG");

        private String value;

        private RasterTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static RasterTypeEnum fromValue(String text) {
            for (RasterTypeEnum b : RasterTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<RasterTypeEnum> {
            public void write(JsonWriter jsonWriter, RasterTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public RasterTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return RasterTypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

