/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.Objects;

public class TestUpdateRequest {
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="description")
    private String description = null;
    @SerializedName(value="qualityStatus")
    private QualityStatusEnum qualityStatus = null;

    public TestUpdateRequest name(String name) {
        this.name = name;
        return this;
    }

    @Schema(description="Name of the test.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public TestUpdateRequest description(String description) {
        this.description = description;
        return this;
    }

    @Schema(description="Description of the test.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public TestUpdateRequest qualityStatus(QualityStatusEnum qualityStatus) {
        this.qualityStatus = qualityStatus;
        return this;
    }

    @Schema(description="Quality status of the test.")
    public QualityStatusEnum getQualityStatus() {
        return this.qualityStatus;
    }

    public void setQualityStatus(QualityStatusEnum qualityStatus) {
        this.qualityStatus = qualityStatus;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestUpdateRequest testUpdateRequest = (TestUpdateRequest)o;
        return Objects.equals(this.name, testUpdateRequest.name) && Objects.equals(this.description, testUpdateRequest.description) && Objects.equals((Object)this.qualityStatus, (Object)testUpdateRequest.qualityStatus);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.description, this.qualityStatus});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TestUpdateRequest {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    qualityStatus: ").append(this.toIndentedString((Object)this.qualityStatus)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum QualityStatusEnum {
        PASSED("PASSED"),
        FAILED("FAILED");

        private String value;

        private QualityStatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static QualityStatusEnum fromValue(String text) {
            for (QualityStatusEnum b : QualityStatusEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<QualityStatusEnum> {
            public void write(JsonWriter jsonWriter, QualityStatusEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public QualityStatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return QualityStatusEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

