/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.Objects;

public class ThresholdDefinition {
    @SerializedName(value="operator")
    private OperatorEnum operator = null;
    @SerializedName(value="value")
    private Float value = null;

    public ThresholdDefinition operator(OperatorEnum operator) {
        this.operator = operator;
        return this;
    }

    @Schema(description="The operator of threshold definition")
    public OperatorEnum getOperator() {
        return this.operator;
    }

    public void setOperator(OperatorEnum operator) {
        this.operator = operator;
    }

    public ThresholdDefinition value(Float value) {
        this.value = value;
        return this;
    }

    @Schema(description="The value of threshold definition")
    public Float getValue() {
        return this.value;
    }

    public void setValue(Float value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ThresholdDefinition thresholdDefinition = (ThresholdDefinition)o;
        return Objects.equals((Object)this.operator, (Object)thresholdDefinition.operator) && Objects.equals(this.value, thresholdDefinition.value);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.operator, this.value});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ThresholdDefinition {\n");
        sb.append("    operator: ").append(this.toIndentedString((Object)this.operator)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum OperatorEnum {
        GREATER_THAN_OR_EQUAL_TO(">="),
        LESS_THAN_OR_EQUAL_TO("<="),
        _("==");

        private String value;

        private OperatorEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static OperatorEnum fromValue(String text) {
            for (OperatorEnum b : OperatorEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<OperatorEnum> {
            public void write(JsonWriter jsonWriter, OperatorEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public OperatorEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return OperatorEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

