/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.httpserver;

import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.Stage;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import com.google.inject.servlet.ServletModule;
import com.nesscomputing.config.Config;
import com.nesscomputing.config.ConfigModule;
import com.nesscomputing.galaxy.GalaxyConfigModule;
import com.nesscomputing.httpclient.HttpClient;
import com.nesscomputing.httpclient.HttpClientResponseHandler;
import com.nesscomputing.httpclient.guice.HttpClientModule;
import com.nesscomputing.httpclient.response.StringContentConverter;
import com.nesscomputing.httpserver.HttpServerModule;
import com.nesscomputing.lifecycle.junit.LifecycleRule;
import com.nesscomputing.lifecycle.junit.LifecycleRunner;
import com.nesscomputing.lifecycle.junit.LifecycleStatement;
import com.nesscomputing.testing.lessio.AllowNetworkAccess;
import com.nesscomputing.testing.lessio.AllowNetworkListen;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@AllowNetworkListen(ports={0})
@AllowNetworkAccess(endpoints={"127.0.0.1:0"})
@RunWith(value=LifecycleRunner.class)
public class TestGuiceModule {
    @LifecycleRule
    public final LifecycleStatement lifecycleRule = LifecycleStatement.defaultLifecycle();
    @Inject
    @Named(value="test")
    private final HttpClient httpClient = null;
    private String baseUri = null;
    private int port = 0;
    @Inject
    @Named(value="magic")
    private UUID checkUuid = null;

    @Before
    public void setUp() throws Exception {
        this.port = TestGuiceModule.findUnusedPort();
        Assert.assertFalse((this.port == 0 ? 1 : 0) != 0);
        this.baseUri = String.format("http://localhost:%d/magic", this.port);
        Config config = Config.getFixedConfig((String[])new String[]{"galaxy.internal.port.http", Integer.toString(this.port)});
        Injector injector = Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{new ConfigModule(config), new HttpServerModule(config), new HttpClientModule("test"), this.lifecycleRule.getLifecycleModule(), new GalaxyConfigModule(), new Module(){

            public void configure(Binder binder) {
                binder.requireExplicitBindings();
                binder.disableCircularProxies();
            }
        }, new ServletModule(){

            public void configureServlets() {
                this.bind(UUID.class).annotatedWith((Annotation)Names.named((String)"magic")).toInstance((Object)UUID.randomUUID());
                this.bind(MagicServlet.class).in(Scopes.SINGLETON);
                this.serve("/magic", new String[0]).with(MagicServlet.class);
            }
        }});
        injector.injectMembers((Object)this);
    }

    @Test
    public void testSimpleGet() throws Exception {
        String content = (String)this.httpClient.get(this.baseUri, (HttpClientResponseHandler)StringContentConverter.DEFAULT_RESPONSE_HANDLER).perform();
        Assert.assertEquals((Object)String.format("guice servlet: %s", this.checkUuid), (Object)content);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int findUnusedPort() throws IOException {
        int port;
        ServerSocket socket = new ServerSocket();
        try {
            socket.bind(new InetSocketAddress(0));
            port = socket.getLocalPort();
        }
        finally {
            socket.close();
        }
        return port;
    }

    @Singleton
    public static class MagicServlet
    extends HttpServlet {
        private final UUID magicUuid;

        @Inject
        public MagicServlet(@Named(value="magic") UUID magicUuid) {
            this.magicUuid = magicUuid;
        }

        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            PrintWriter writer = resp.getWriter();
            resp.setStatus(200);
            resp.setCharacterEncoding("ISO-8859-1");
            resp.setContentType("text/plain");
            ((Writer)writer).write(String.format("guice servlet: %s", this.magicUuid));
        }
    }
}

