/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.httpserver.standalone;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.nesscomputing.config.Config;
import com.nesscomputing.httpserver.standalone.StandaloneServer;
import com.nesscomputing.testing.lessio.AllowNetworkAccess;
import com.nesscomputing.testing.lessio.AllowNetworkListen;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@AllowNetworkListen(ports={0})
@AllowNetworkAccess(endpoints={"127.0.0.1:0"})
public class TestServerLifecycle {
    private StandaloneServer server = null;

    @Before
    public void setUp() {
        Assert.assertNull((Object)this.server);
        this.server = new StandaloneServer(){

            public Config getConfig() {
                return Config.getEmptyConfig();
            }

            protected Module getMainModule(Config config) {
                return new Module(){

                    public void configure(Binder binder) {
                    }
                };
            }
        };
    }

    @After
    public void tearDown() {
        Assert.assertNotNull((Object)this.server);
        if (!this.server.isStarted()) {
            this.server.startServer();
        }
        if (!this.server.isStopped()) {
            this.server.stopServer();
        }
        this.server = null;
    }

    @Test
    public void testLifecycle() throws Exception {
        Assert.assertFalse((boolean)this.server.isStarted());
        Assert.assertFalse((boolean)this.server.isStopped());
        this.server.startServer();
        Assert.assertTrue((boolean)this.server.isStarted());
        Assert.assertFalse((boolean)this.server.isStopped());
        this.server.stopServer();
        Assert.assertTrue((boolean)this.server.isStarted());
        Assert.assertTrue((boolean)this.server.isStopped());
    }

    @Test(expected=IllegalStateException.class)
    public void testDoubleStart() throws Exception {
        Assert.assertFalse((boolean)this.server.isStarted());
        Assert.assertFalse((boolean)this.server.isStopped());
        this.server.startServer();
        Assert.assertTrue((boolean)this.server.isStarted());
        Assert.assertFalse((boolean)this.server.isStopped());
        this.server.startServer();
    }

    @Test(expected=IllegalStateException.class)
    public void testDoubleStop() throws Exception {
        Assert.assertFalse((boolean)this.server.isStarted());
        Assert.assertFalse((boolean)this.server.isStopped());
        this.server.startServer();
        Assert.assertTrue((boolean)this.server.isStarted());
        Assert.assertFalse((boolean)this.server.isStopped());
        this.server.stopServer();
        Assert.assertTrue((boolean)this.server.isStarted());
        Assert.assertTrue((boolean)this.server.isStopped());
        this.server.stopServer();
    }
}

