/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.httpserver.jetty;

import com.google.common.io.ByteStreams;
import com.google.inject.Inject;
import com.nesscomputing.httpserver.HttpServerConfig;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.WriterOutputStream;
import org.eclipse.jetty.server.AbstractHttpConnection;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;

public class ClasspathResourceHandler
extends AbstractHandler {
    private final String basePath;
    private final String resourceLocation;
    private final long startupTime = System.currentTimeMillis() / 1000L;
    private static final MimeTypes MIME_TYPES;
    private boolean is304Disabled;

    @Inject
    public ClasspathResourceHandler(String basePath, String resourceLocation) {
        this.basePath = basePath;
        this.resourceLocation = resourceLocation;
    }

    @Inject
    void setHttpServerConfig(HttpServerConfig config) {
        this.is304Disabled = config.isIfModifiedSinceDisabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        InputStream resourceStream;
        block19: {
            block18: {
                boolean skipContent;
                block17: {
                    long ifModifiedSince;
                    if (baseRequest.isHandled()) {
                        return;
                    }
                    String pathInfo = request.getPathInfo();
                    if (pathInfo == null || !pathInfo.startsWith(this.basePath)) {
                        return;
                    }
                    if (!(pathInfo = pathInfo.substring(this.basePath.length())).startsWith("/") && !pathInfo.isEmpty()) {
                        return;
                    }
                    if ("/".equals(pathInfo) || "".equals(pathInfo)) {
                        pathInfo = "/index.html";
                    }
                    skipContent = false;
                    baseRequest.setHandled(true);
                    String method = request.getMethod();
                    if (!StringUtils.equals((CharSequence)"GET", (CharSequence)method)) {
                        if (StringUtils.equals((CharSequence)"HEAD", (CharSequence)method)) {
                            skipContent = true;
                        } else {
                            response.sendError(405);
                            return;
                        }
                    }
                    if ((ifModifiedSince = request.getDateHeader("If-Modified-Since")) > 0L && this.startupTime <= ifModifiedSince / 1000L && !this.is304Disabled) {
                        response.setStatus(304);
                        return;
                    }
                    resourceStream = null;
                    try {
                        if (pathInfo.startsWith("/")) {
                            String resourcePath = this.resourceLocation + pathInfo;
                            resourceStream = ((Object)((Object)this)).getClass().getResourceAsStream(resourcePath);
                        }
                        if (resourceStream != null) break block17;
                        response.sendError(404);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(resourceStream);
                        throw throwable;
                    }
                    IOUtils.closeQuietly(resourceStream);
                    return;
                }
                Buffer mime = MIME_TYPES.getMimeByExtension(request.getPathInfo());
                if (mime != null) {
                    response.setContentType(mime.toString("ISO8859-1"));
                }
                response.setDateHeader("Last-Modified", this.startupTime * 1000L);
                if (!skipContent) break block18;
                IOUtils.closeQuietly((InputStream)resourceStream);
                return;
            }
            ServletOutputStream out = null;
            try {
                out = response.getOutputStream();
            }
            catch (IllegalStateException e) {
                out = new WriterOutputStream((Writer)response.getWriter());
            }
            if (out instanceof AbstractHttpConnection.Output) {
                ((AbstractHttpConnection.Output)out).sendContent((Object)resourceStream);
                break block19;
            }
            ByteStreams.copy((InputStream)resourceStream, (OutputStream)out);
        }
        IOUtils.closeQuietly((InputStream)resourceStream);
    }

    static {
        MimeTypes mimeTypes = new MimeTypes();
        mimeTypes.addMimeMapping("json", "application/json");
        MIME_TYPES = mimeTypes;
    }
}

