/*
 * Decompiled with CFR 0.152.
 */
package rx.android.concurrency;

import android.os.Handler;
import java.util.concurrent.TimeUnit;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.robolectric.RobolectricTestRunner;
import org.robolectric.annotation.Config;
import rx.Scheduler;
import rx.Subscription;
import rx.operators.SafeObservableSubscription;
import rx.util.functions.Func2;

public class HandlerThreadScheduler
extends Scheduler {
    private final Handler handler;

    public HandlerThreadScheduler(Handler handler) {
        this.handler = handler;
    }

    public <T> Subscription schedule(T state, Func2<Scheduler, T, Subscription> action) {
        return this.schedule(state, action, 0L, TimeUnit.MILLISECONDS);
    }

    public <T> Subscription schedule(final T state, final Func2<Scheduler, T, Subscription> action, long delayTime, TimeUnit unit) {
        final SafeObservableSubscription subscription = new SafeObservableSubscription();
        final HandlerThreadScheduler _scheduler = this;
        this.handler.postDelayed(new Runnable(){

            @Override
            public void run() {
                subscription.wrap((Subscription)action.call((Object)_scheduler, state));
            }
        }, unit.toMillis(delayTime));
        return subscription;
    }

    @RunWith(value=RobolectricTestRunner.class)
    @Config(manifest="--none")
    public static final class UnitTest {
        @Test
        public void shouldScheduleImmediateActionOnHandlerThread() {
            Handler handler = (Handler)Mockito.mock(Handler.class);
            Object state = new Object();
            Func2 action = (Func2)Mockito.mock(Func2.class);
            HandlerThreadScheduler scheduler = new HandlerThreadScheduler(handler);
            scheduler.schedule(state, action);
            ArgumentCaptor runnable = ArgumentCaptor.forClass(Runnable.class);
            ((Handler)Mockito.verify((Object)handler)).postDelayed((Runnable)runnable.capture(), Matchers.eq((long)0L));
            ((Runnable)runnable.getValue()).run();
            ((Func2)Mockito.verify((Object)action)).call((Object)scheduler, state);
        }

        @Test
        public void shouldScheduleDelayedActionOnHandlerThread() {
            Handler handler = (Handler)Mockito.mock(Handler.class);
            Object state = new Object();
            Func2 action = (Func2)Mockito.mock(Func2.class);
            HandlerThreadScheduler scheduler = new HandlerThreadScheduler(handler);
            scheduler.schedule(state, action, 1L, TimeUnit.SECONDS);
            ArgumentCaptor runnable = ArgumentCaptor.forClass(Runnable.class);
            ((Handler)Mockito.verify((Object)handler)).postDelayed((Runnable)runnable.capture(), Matchers.eq((long)1000L));
            ((Runnable)runnable.getValue()).run();
            ((Func2)Mockito.verify((Object)action)).call((Object)scheduler, state);
        }
    }
}

