/*
 * Decompiled with CFR 0.152.
 */
package rx.android.observables;

import android.app.Activity;
import android.app.Fragment;
import android.os.Build;
import android.support.v4.app.FragmentActivity;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.robolectric.Robolectric;
import org.robolectric.RobolectricTestRunner;
import org.robolectric.annotation.Config;
import rx.Observable;
import rx.Observer;
import rx.operators.OperationObserveFromAndroidComponent;

public final class AndroidObservable {
    private static final boolean USES_SUPPORT_FRAGMENTS;

    private AndroidObservable() {
    }

    public static <T> Observable<T> fromActivity(Activity activity, Observable<T> sourceObservable) {
        return OperationObserveFromAndroidComponent.observeFromAndroidComponent(sourceObservable, activity);
    }

    public static <T> Observable<T> fromFragment(Object fragment, Observable<T> sourceObservable) {
        if (USES_SUPPORT_FRAGMENTS && fragment instanceof android.support.v4.app.Fragment) {
            return OperationObserveFromAndroidComponent.observeFromAndroidComponent(sourceObservable, (android.support.v4.app.Fragment)fragment);
        }
        if (Build.VERSION.SDK_INT >= 11 && fragment instanceof Fragment) {
            return OperationObserveFromAndroidComponent.observeFromAndroidComponent(sourceObservable, (Fragment)fragment);
        }
        throw new IllegalArgumentException("Target fragment is neither a native nor support library Fragment");
    }

    static {
        boolean supportFragmentsAvailable = false;
        try {
            Class.forName("android.support.v4.app.Fragment");
            supportFragmentsAvailable = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        USES_SUPPORT_FRAGMENTS = supportFragmentsAvailable;
    }

    @RunWith(value=RobolectricTestRunner.class)
    @Config(manifest="--none")
    public static final class AndroidObservableTest {
        private FragmentActivity fragmentActivity;
        private android.support.v4.app.Fragment supportFragment;
        private Activity activity;
        private Fragment fragment;
        @Mock
        private Observer<String> observer;

        @Before
        public void setup() {
            MockitoAnnotations.initMocks((Object)this);
            this.supportFragment = new android.support.v4.app.Fragment();
            this.fragmentActivity = (FragmentActivity)Robolectric.buildActivity(FragmentActivity.class).create().get();
            this.fragmentActivity.getSupportFragmentManager().beginTransaction().add(this.supportFragment, null).commit();
            this.fragment = new Fragment();
            this.activity = Robolectric.buildActivity(Activity.class).create().get();
            this.activity.getFragmentManager().beginTransaction().add(this.fragment, null).commit();
        }

        @Test
        public void itSupportsFragmentsFromTheSupportV4Library() {
            AndroidObservable.fromFragment(this.supportFragment, Observable.just((Object)"success")).subscribe(this.observer);
            ((Observer)Mockito.verify(this.observer)).onNext((Object)"success");
            ((Observer)Mockito.verify(this.observer)).onCompleted();
        }

        @Test
        public void itSupportsNativeFragments() {
            AndroidObservable.fromFragment(this.fragment, Observable.just((Object)"success")).subscribe(this.observer);
            ((Observer)Mockito.verify(this.observer)).onNext((Object)"success");
            ((Observer)Mockito.verify(this.observer)).onCompleted();
        }

        @Test(expected=IllegalArgumentException.class)
        public void itThrowsIfObjectPassedIsNotAFragment() {
            AndroidObservable.fromFragment("not a fragment", Observable.never());
        }
    }
}

