/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import android.app.Activity;
import android.app.Fragment;
import android.os.Looper;
import android.util.Log;
import java.lang.reflect.Field;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.robolectric.RobolectricTestRunner;
import org.robolectric.annotation.Config;
import rx.Observable;
import rx.Observer;
import rx.Subscription;
import rx.android.schedulers.AndroidSchedulers;
import rx.subjects.PublishSubject;

public class OperationObserveFromAndroidComponent {
    public static <T> Observable<T> observeFromAndroidComponent(Observable<T> source, Fragment fragment) {
        return Observable.create(new OnSubscribeFragment((Observable)source, fragment));
    }

    public static <T> Observable<T> observeFromAndroidComponent(Observable<T> source, android.support.v4.app.Fragment fragment) {
        return Observable.create(new OnSubscribeSupportFragment((Observable)source, fragment));
    }

    public static <T> Observable<T> observeFromAndroidComponent(Observable<T> source, Activity activity) {
        return Observable.create(new OnSubscribeBase(source, activity));
    }

    @RunWith(value=RobolectricTestRunner.class)
    @Config(manifest="--none")
    public static final class UnitTest {
        @Mock
        private Observer<Integer> mockObserver;
        @Mock
        private Fragment mockFragment;
        @Mock
        private Activity mockActivity;
        @Mock
        private Observable<Integer> mockObservable;

        @Before
        public void setupMocks() {
            MockitoAnnotations.initMocks((Object)this);
            Mockito.when((Object)this.mockFragment.isAdded()).thenReturn((Object)true);
        }

        @Test
        public void itThrowsIfObserverSubscribesFromBackgroundThread() throws Exception {
            Future<Object> future = Executors.newSingleThreadExecutor().submit(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    OperationObserveFromAndroidComponent.observeFromAndroidComponent(UnitTest.this.mockObservable, UnitTest.this.mockFragment).subscribe(UnitTest.this.mockObserver);
                    return null;
                }
            });
            future.get(1L, TimeUnit.SECONDS);
            ((Observer)Mockito.verify(this.mockObserver)).onError((Throwable)Matchers.any(IllegalStateException.class));
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockObserver});
        }

        @Test
        public void itObservesTheSourceSequenceOnTheMainUIThread() {
            OperationObserveFromAndroidComponent.observeFromAndroidComponent(this.mockObservable, this.mockFragment).subscribe(this.mockObserver);
            ((Observable)Mockito.verify(this.mockObservable)).observeOn(AndroidSchedulers.mainThread());
        }

        @Test
        public void itForwardsOnNextOnCompletedSequenceToTargetObserver() {
            Observable source = Observable.from((Object)1, (Object)2, (Object)3);
            OperationObserveFromAndroidComponent.observeFromAndroidComponent(source, this.mockFragment).subscribe(this.mockObserver);
            ((Observer)Mockito.verify(this.mockObserver, (VerificationMode)Mockito.times((int)3))).onNext((Object)Matchers.anyInt());
            ((Observer)Mockito.verify(this.mockObserver)).onCompleted();
            ((Observer)Mockito.verify(this.mockObserver, (VerificationMode)Mockito.never())).onError((Throwable)Matchers.any(Exception.class));
        }

        @Test
        public void itForwardsOnErrorToTargetObserver() {
            Exception exception = new Exception();
            Observable source = Observable.error((Throwable)exception);
            OperationObserveFromAndroidComponent.observeFromAndroidComponent(source, this.mockFragment).subscribe(this.mockObserver);
            ((Observer)Mockito.verify(this.mockObserver)).onError((Throwable)exception);
            ((Observer)Mockito.verify(this.mockObserver, (VerificationMode)Mockito.never())).onNext((Object)Matchers.anyInt());
            ((Observer)Mockito.verify(this.mockObserver, (VerificationMode)Mockito.never())).onCompleted();
        }

        @Test
        public void itDropsOnNextOnCompletedSequenceIfTargetComponentIsGone() throws Throwable {
            PublishSubject source = PublishSubject.create();
            OnSubscribeFragment<Integer> operator = new OnSubscribeFragment<Integer>((Observable)source, this.mockFragment);
            operator.onSubscribe(this.mockObserver);
            source.onNext((Object)1);
            this.releaseComponentRef(operator);
            source.onNext((Object)2);
            source.onNext((Object)3);
            source.onCompleted();
            ((Observer)Mockito.verify(this.mockObserver)).onNext((Object)1);
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockObserver});
        }

        @Test
        public void itDropsOnErrorIfTargetComponentIsGone() throws Throwable {
            PublishSubject source = PublishSubject.create();
            OnSubscribeFragment<Integer> operator = new OnSubscribeFragment<Integer>((Observable)source, this.mockFragment);
            operator.onSubscribe(this.mockObserver);
            source.onNext((Object)1);
            this.releaseComponentRef(operator);
            source.onError((Throwable)new Exception());
            ((Observer)Mockito.verify(this.mockObserver)).onNext((Object)1);
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockObserver});
        }

        private void releaseComponentRef(OnSubscribeFragment<Integer> operator) throws NoSuchFieldException, IllegalAccessException {
            Field componentRef = operator.getClass().getSuperclass().getDeclaredField("componentRef");
            componentRef.setAccessible(true);
            componentRef.set(operator, null);
        }

        @Test
        public void itDoesNotForwardOnNextOnCompletedSequenceIfFragmentIsDetached() {
            PublishSubject source = PublishSubject.create();
            OperationObserveFromAndroidComponent.observeFromAndroidComponent(source, this.mockFragment).subscribe(this.mockObserver);
            source.onNext((Object)1);
            Mockito.when((Object)this.mockFragment.isAdded()).thenReturn((Object)false);
            source.onNext((Object)2);
            source.onNext((Object)3);
            source.onCompleted();
            ((Observer)Mockito.verify(this.mockObserver)).onNext((Object)1);
            ((Observer)Mockito.verify(this.mockObserver, (VerificationMode)Mockito.never())).onCompleted();
        }

        @Test
        public void itDoesNotForwardOnErrorIfFragmentIsDetached() {
            PublishSubject source = PublishSubject.create();
            OperationObserveFromAndroidComponent.observeFromAndroidComponent(source, this.mockFragment).subscribe(this.mockObserver);
            source.onNext((Object)1);
            Mockito.when((Object)this.mockFragment.isAdded()).thenReturn((Object)false);
            source.onError((Throwable)new Exception());
            ((Observer)Mockito.verify(this.mockObserver)).onNext((Object)1);
            ((Observer)Mockito.verify(this.mockObserver, (VerificationMode)Mockito.never())).onError((Throwable)Matchers.any(Exception.class));
        }

        @Test
        public void itUnsubscribesFromTheSourceSequence() {
            Subscription underlying = (Subscription)Mockito.mock(Subscription.class);
            Mockito.when((Object)this.mockObservable.observeOn(AndroidSchedulers.mainThread())).thenReturn(this.mockObservable);
            Mockito.when((Object)this.mockObservable.subscribe((Observer)Matchers.any(Observer.class))).thenReturn((Object)underlying);
            Subscription sub = OperationObserveFromAndroidComponent.observeFromAndroidComponent(this.mockObservable, this.mockActivity).subscribe(this.mockObserver);
            sub.unsubscribe();
            ((Subscription)Mockito.verify((Object)underlying)).unsubscribe();
        }
    }

    private static final class OnSubscribeSupportFragment<T>
    extends OnSubscribeBase<T, android.support.v4.app.Fragment> {
        private OnSubscribeSupportFragment(Observable<T> source, android.support.v4.app.Fragment fragment) {
            super(source, fragment);
        }

        @Override
        protected boolean isComponentValid(android.support.v4.app.Fragment fragment) {
            return fragment.isAdded();
        }
    }

    private static final class OnSubscribeFragment<T>
    extends OnSubscribeBase<T, Fragment> {
        private OnSubscribeFragment(Observable<T> source, Fragment fragment) {
            super(source, fragment);
        }

        @Override
        protected boolean isComponentValid(Fragment fragment) {
            return fragment.isAdded();
        }
    }

    private static class OnSubscribeBase<T, AndroidComponent>
    implements Observable.OnSubscribeFunc<T> {
        private static final String LOG_TAG = "AndroidObserver";
        private final Observable<T> source;
        private AndroidComponent componentRef;
        private Observer<? super T> observerRef;

        private OnSubscribeBase(Observable<T> source, AndroidComponent component) {
            this.source = source;
            this.componentRef = component;
        }

        private void log(String message) {
            if (Log.isLoggable((String)LOG_TAG, (int)3)) {
                Log.d((String)LOG_TAG, (String)("componentRef = " + this.componentRef));
                Log.d((String)LOG_TAG, (String)("observerRef = " + this.observerRef));
                Log.d((String)LOG_TAG, (String)message);
            }
        }

        protected boolean isComponentValid(AndroidComponent component) {
            return true;
        }

        public Subscription onSubscribe(Observer<? super T> observer) {
            this.assertUiThread();
            this.observerRef = observer;
            final Subscription sourceSub = this.source.observeOn(AndroidSchedulers.mainThread()).subscribe(new Observer<T>(){

                public void onCompleted() {
                    if (OnSubscribeBase.this.componentRef != null && OnSubscribeBase.this.isComponentValid(OnSubscribeBase.this.componentRef)) {
                        OnSubscribeBase.this.observerRef.onCompleted();
                    } else {
                        OnSubscribeBase.this.log("onComplete: target component released or detached; dropping message");
                    }
                }

                public void onError(Throwable e) {
                    if (OnSubscribeBase.this.componentRef != null && OnSubscribeBase.this.isComponentValid(OnSubscribeBase.this.componentRef)) {
                        OnSubscribeBase.this.observerRef.onError(e);
                    } else {
                        OnSubscribeBase.this.log("onError: target component released or detached; dropping message");
                    }
                }

                public void onNext(T args) {
                    if (OnSubscribeBase.this.componentRef != null && OnSubscribeBase.this.isComponentValid(OnSubscribeBase.this.componentRef)) {
                        OnSubscribeBase.this.observerRef.onNext(args);
                    } else {
                        OnSubscribeBase.this.log("onNext: target component released or detached; dropping message");
                    }
                }
            });
            return new Subscription(){

                public void unsubscribe() {
                    OnSubscribeBase.this.log("unsubscribing from source sequence");
                    OnSubscribeBase.this.releaseReferences();
                    sourceSub.unsubscribe();
                }
            };
        }

        private void releaseReferences() {
            this.observerRef = null;
            this.componentRef = null;
        }

        private void assertUiThread() {
            if (Looper.getMainLooper() != Looper.myLooper()) {
                throw new IllegalStateException("Observers must subscribe from the main UI thread, but was " + Thread.currentThread());
            }
        }
    }
}

