/*
 * Decompiled with CFR 0.152.
 */
package rx.android.observables;

import android.app.Activity;
import android.app.Fragment;
import android.os.Build;
import rx.Observable;
import rx.operators.OperationObserveFromAndroidComponent;

public final class AndroidObservable {
    private static final boolean USES_SUPPORT_FRAGMENTS;

    private AndroidObservable() {
    }

    public static <T> Observable<T> fromActivity(Activity activity, Observable<T> sourceObservable) {
        return OperationObserveFromAndroidComponent.observeFromAndroidComponent(sourceObservable, activity);
    }

    public static <T> Observable<T> fromFragment(Object fragment, Observable<T> sourceObservable) {
        if (USES_SUPPORT_FRAGMENTS && fragment instanceof android.support.v4.app.Fragment) {
            return OperationObserveFromAndroidComponent.observeFromAndroidComponent(sourceObservable, (android.support.v4.app.Fragment)fragment);
        }
        if (Build.VERSION.SDK_INT >= 11 && fragment instanceof Fragment) {
            return OperationObserveFromAndroidComponent.observeFromAndroidComponent(sourceObservable, (Fragment)fragment);
        }
        throw new IllegalArgumentException("Target fragment is neither a native nor support library Fragment");
    }

    static {
        boolean supportFragmentsAvailable = false;
        try {
            Class.forName("android.support.v4.app.Fragment");
            supportFragmentsAvailable = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        USES_SUPPORT_FRAGMENTS = supportFragmentsAvailable;
    }
}

