/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import android.app.Activity;
import android.app.Fragment;
import android.os.Looper;
import android.util.Log;
import rx.Observable;
import rx.Observer;
import rx.Subscription;
import rx.android.schedulers.AndroidSchedulers;

public class OperationObserveFromAndroidComponent {
    public static <T> Observable<T> observeFromAndroidComponent(Observable<T> source, Fragment fragment) {
        return Observable.create(new OnSubscribeFragment((Observable)source, fragment));
    }

    public static <T> Observable<T> observeFromAndroidComponent(Observable<T> source, android.support.v4.app.Fragment fragment) {
        return Observable.create(new OnSubscribeSupportFragment((Observable)source, fragment));
    }

    public static <T> Observable<T> observeFromAndroidComponent(Observable<T> source, Activity activity) {
        return Observable.create(new OnSubscribeBase(source, activity));
    }

    private static final class OnSubscribeSupportFragment<T>
    extends OnSubscribeBase<T, android.support.v4.app.Fragment> {
        private OnSubscribeSupportFragment(Observable<T> source, android.support.v4.app.Fragment fragment) {
            super(source, fragment);
        }

        @Override
        protected boolean isComponentValid(android.support.v4.app.Fragment fragment) {
            return fragment.isAdded();
        }
    }

    private static final class OnSubscribeFragment<T>
    extends OnSubscribeBase<T, Fragment> {
        private OnSubscribeFragment(Observable<T> source, Fragment fragment) {
            super(source, fragment);
        }

        @Override
        protected boolean isComponentValid(Fragment fragment) {
            return fragment.isAdded();
        }
    }

    private static class OnSubscribeBase<T, AndroidComponent>
    implements Observable.OnSubscribeFunc<T> {
        private static final String LOG_TAG = "AndroidObserver";
        private final Observable<T> source;
        private AndroidComponent componentRef;
        private Observer<? super T> observerRef;

        private OnSubscribeBase(Observable<T> source, AndroidComponent component) {
            this.source = source;
            this.componentRef = component;
        }

        private void log(String message) {
            if (Log.isLoggable((String)LOG_TAG, (int)3)) {
                Log.d((String)LOG_TAG, (String)("componentRef = " + this.componentRef));
                Log.d((String)LOG_TAG, (String)("observerRef = " + this.observerRef));
                Log.d((String)LOG_TAG, (String)message);
            }
        }

        protected boolean isComponentValid(AndroidComponent component) {
            return true;
        }

        public Subscription onSubscribe(Observer<? super T> observer) {
            this.assertUiThread();
            this.observerRef = observer;
            final Subscription sourceSub = this.source.observeOn(AndroidSchedulers.mainThread()).subscribe(new Observer<T>(){

                public void onCompleted() {
                    if (OnSubscribeBase.this.componentRef != null && OnSubscribeBase.this.isComponentValid(OnSubscribeBase.this.componentRef)) {
                        OnSubscribeBase.this.observerRef.onCompleted();
                    } else {
                        OnSubscribeBase.this.log("onComplete: target component released or detached; dropping message");
                    }
                }

                public void onError(Throwable e) {
                    if (OnSubscribeBase.this.componentRef != null && OnSubscribeBase.this.isComponentValid(OnSubscribeBase.this.componentRef)) {
                        OnSubscribeBase.this.observerRef.onError(e);
                    } else {
                        OnSubscribeBase.this.log("onError: target component released or detached; dropping message");
                    }
                }

                public void onNext(T args) {
                    if (OnSubscribeBase.this.componentRef != null && OnSubscribeBase.this.isComponentValid(OnSubscribeBase.this.componentRef)) {
                        OnSubscribeBase.this.observerRef.onNext(args);
                    } else {
                        OnSubscribeBase.this.log("onNext: target component released or detached; dropping message");
                    }
                }
            });
            return new Subscription(){

                public void unsubscribe() {
                    OnSubscribeBase.this.log("unsubscribing from source sequence");
                    OnSubscribeBase.this.releaseReferences();
                    sourceSub.unsubscribe();
                }
            };
        }

        private void releaseReferences() {
            this.observerRef = null;
            this.componentRef = null;
        }

        private void assertUiThread() {
            if (Looper.getMainLooper() != Looper.myLooper()) {
                throw new IllegalStateException("Observers must subscribe from the main UI thread, but was " + Thread.currentThread());
            }
        }
    }
}

