/*
 * Decompiled with CFR 0.152.
 */
package rx.android.schedulers;

import android.os.Handler;
import java.util.concurrent.TimeUnit;
import rx.Scheduler;
import rx.Subscription;
import rx.functions.Action0;
import rx.subscriptions.BooleanSubscription;
import rx.subscriptions.Subscriptions;

public class HandlerThreadScheduler
extends Scheduler {
    private final Handler handler;

    public HandlerThreadScheduler(Handler handler) {
        this.handler = handler;
    }

    public Scheduler.Worker createWorker() {
        return new InnerHandlerThreadScheduler(this.handler);
    }

    private static class InnerHandlerThreadScheduler
    extends Scheduler.Worker {
        private final Handler handler;
        private BooleanSubscription innerSubscription = new BooleanSubscription();

        public InnerHandlerThreadScheduler(Handler handler) {
            this.handler = handler;
        }

        public void unsubscribe() {
            this.innerSubscription.unsubscribe();
        }

        public boolean isUnsubscribed() {
            return this.innerSubscription.isUnsubscribed();
        }

        public Subscription schedule(final Action0 action, long delayTime, TimeUnit unit) {
            final Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (InnerHandlerThreadScheduler.this.isUnsubscribed()) {
                        return;
                    }
                    action.call();
                }
            };
            this.handler.postDelayed(runnable, unit.toMillis(delayTime));
            return Subscriptions.create((Action0)new Action0(){

                public void call() {
                    InnerHandlerThreadScheduler.this.handler.removeCallbacks(runnable);
                }
            });
        }

        public Subscription schedule(Action0 action) {
            return this.schedule(action, 0L, TimeUnit.MILLISECONDS);
        }
    }
}

