/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import android.text.Editable;
import android.text.TextWatcher;
import android.widget.EditText;
import rx.Observable;
import rx.Subscriber;
import rx.Subscription;
import rx.android.observables.Assertions;
import rx.android.subscriptions.AndroidSubscriptions;
import rx.functions.Action0;

public class OperatorEditTextInput
implements Observable.OnSubscribe<String> {
    private final EditText input;
    private final boolean emitInitialValue;

    public OperatorEditTextInput(EditText input, boolean emitInitialValue) {
        this.input = input;
        this.emitInitialValue = emitInitialValue;
    }

    public void call(final Subscriber<? super String> observer) {
        Assertions.assertUiThread();
        final SimpleTextWatcher watcher = new SimpleTextWatcher(){

            @Override
            public void afterTextChanged(Editable editable) {
                observer.onNext((Object)editable.toString());
            }
        };
        Subscription subscription = AndroidSubscriptions.unsubscribeInUiThread(new Action0(){

            public void call() {
                OperatorEditTextInput.this.input.removeTextChangedListener(watcher);
            }
        });
        if (this.emitInitialValue) {
            observer.onNext((Object)this.input.getEditableText().toString());
        }
        this.input.addTextChangedListener((TextWatcher)watcher);
        observer.add(subscription);
    }

    private static class SimpleTextWatcher
    implements TextWatcher {
        private SimpleTextWatcher() {
        }

        public void beforeTextChanged(CharSequence sequence, int start, int count, int after) {
        }

        public void onTextChanged(CharSequence sequence, int start, int before, int count) {
        }

        public void afterTextChanged(Editable editable) {
        }
    }
}

