/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import android.text.Editable;
import android.text.TextWatcher;
import android.widget.TextView;
import rx.Observable;
import rx.Subscriber;
import rx.Subscription;
import rx.android.observables.Assertions;
import rx.android.subscriptions.AndroidSubscriptions;
import rx.functions.Action0;

public class OperatorTextViewInput<T extends TextView>
implements Observable.OnSubscribe<T> {
    private final T input;
    private final boolean emitInitialValue;

    public OperatorTextViewInput(T input, boolean emitInitialValue) {
        this.input = input;
        this.emitInitialValue = emitInitialValue;
    }

    public void call(final Subscriber<? super T> observer) {
        Assertions.assertUiThread();
        final SimpleTextWatcher watcher = new SimpleTextWatcher(){

            @Override
            public void afterTextChanged(Editable editable) {
                observer.onNext((Object)OperatorTextViewInput.this.input);
            }
        };
        Subscription subscription = AndroidSubscriptions.unsubscribeInUiThread(new Action0(){

            public void call() {
                OperatorTextViewInput.this.input.removeTextChangedListener(watcher);
            }
        });
        if (this.emitInitialValue) {
            observer.onNext(this.input);
        }
        this.input.addTextChangedListener((TextWatcher)watcher);
        observer.add(subscription);
    }

    private static class SimpleTextWatcher
    implements TextWatcher {
        private SimpleTextWatcher() {
        }

        public void beforeTextChanged(CharSequence sequence, int start, int count, int after) {
        }

        public void onTextChanged(CharSequence sequence, int start, int before, int count) {
        }

        public void afterTextChanged(Editable editable) {
        }
    }
}

