/*
 * Decompiled with CFR 0.152.
 */
package rx.apache.http.consumers;

import java.io.IOException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.ContentDecoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.protocol.AbstractAsyncResponseConsumer;
import org.apache.http.protocol.HttpContext;
import rx.Observer;
import rx.apache.http.ObservableHttpResponse;
import rx.apache.http.consumers.ResponseConsumerBasic;
import rx.apache.http.consumers.ResponseConsumerEventStream;
import rx.apache.http.consumers.ResponseDelegate;
import rx.subscriptions.CompositeSubscription;

public class ResponseConsumerDelegate
extends AbstractAsyncResponseConsumer<HttpResponse> {
    private volatile ResponseDelegate consumer = null;
    final Observer<? super ObservableHttpResponse> observer;
    final CompositeSubscription subscription;

    public ResponseConsumerDelegate(Observer<? super ObservableHttpResponse> observer, CompositeSubscription subscription) {
        this.observer = observer;
        this.subscription = subscription;
    }

    protected void onResponseReceived(HttpResponse response) throws HttpException, IOException {
        this.consumer = this.responseIsStreamLike(response) ? new ResponseConsumerEventStream(this.observer, this.subscription) : new ResponseConsumerBasic(this.observer, this.subscription);
        this.consumer._onResponseReceived(response);
    }

    private boolean responseIsStreamLike(HttpResponse response) {
        Header contentType = response.getFirstHeader("Content-Type");
        if (contentType != null && contentType.getValue().contains("text/event-stream")) {
            return true;
        }
        Header transferEncoding = response.getFirstHeader("Transfer-Encoding");
        return transferEncoding != null && transferEncoding.getValue().equals("chunked");
    }

    protected void onContentReceived(ContentDecoder decoder, IOControl ioctrl) throws IOException {
        this.consumer._onContentReceived(decoder, ioctrl);
    }

    protected void onEntityEnclosed(HttpEntity entity, ContentType contentType) throws IOException {
        this.consumer._onEntityEnclosed(entity, contentType);
    }

    protected HttpResponse buildResult(HttpContext context) throws Exception {
        return this.consumer._buildResult(context);
    }

    protected void releaseResources() {
        this.consumer._releaseResources();
    }
}

