/*
 * Decompiled with CFR 0.152.
 */
package rx.apache.http.consumers;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.ContentDecoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.client.methods.AsyncByteConsumer;
import org.apache.http.protocol.HttpContext;
import rx.Observable;
import rx.Observer;
import rx.Subscription;
import rx.apache.http.ObservableHttpResponse;
import rx.apache.http.consumers.ExpandableByteBuffer;
import rx.apache.http.consumers.ResponseDelegate;
import rx.subjects.PublishSubject;
import rx.subscriptions.CompositeSubscription;

class ResponseConsumerEventStream
extends AsyncByteConsumer<HttpResponse>
implements ResponseDelegate {
    private final Observer<? super ObservableHttpResponse> observer;
    private final PublishSubject<byte[]> contentSubject = PublishSubject.create();
    private final CompositeSubscription parentSubscription;
    final ExpandableByteBuffer dataBuffer = new ExpandableByteBuffer();

    public ResponseConsumerEventStream(Observer<? super ObservableHttpResponse> observer, CompositeSubscription parentSubscription) {
        this.observer = observer;
        this.parentSubscription = parentSubscription;
    }

    @Override
    public void _onResponseReceived(HttpResponse response) throws HttpException, IOException {
        this.onResponseReceived(response);
    }

    protected void onByteReceived(ByteBuffer buf, IOControl ioctrl) throws IOException {
        if (this.parentSubscription.isUnsubscribed()) {
            ioctrl.shutdown();
        }
        while (buf.position() < buf.limit()) {
            byte b = buf.get();
            if (b == 10 || b == 13) {
                if (this.dataBuffer.hasContent()) {
                    this.contentSubject.onNext((Object)this.dataBuffer.getBytes());
                }
                this.dataBuffer.reset();
                continue;
            }
            this.dataBuffer.addByte(b);
        }
    }

    protected void onResponseReceived(HttpResponse response) throws HttpException, IOException {
        Observable contentObservable = Observable.create((Observable.OnSubscribeFunc)new Observable.OnSubscribeFunc<byte[]>(){

            public Subscription onSubscribe(Observer<? super byte[]> observer) {
                ResponseConsumerEventStream.this.parentSubscription.add(ResponseConsumerEventStream.this.contentSubject.subscribe(observer));
                return ResponseConsumerEventStream.this.parentSubscription;
            }
        });
        this.observer.onNext((Object)new ObservableHttpResponse(response, (Observable<byte[]>)contentObservable));
    }

    protected HttpResponse buildResult(HttpContext context) throws Exception {
        return null;
    }

    @Override
    public void _onContentReceived(ContentDecoder decoder, IOControl ioctrl) throws IOException {
        this.onContentReceived(decoder, ioctrl);
    }

    @Override
    public void _onEntityEnclosed(HttpEntity entity, ContentType contentType) throws IOException {
        this.onEntityEnclosed(entity, contentType);
    }

    @Override
    public HttpResponse _buildResult(HttpContext context) throws Exception {
        return this.buildResult(context);
    }

    @Override
    public void _releaseResources() {
        this.releaseResources();
    }
}

