/*
 * Decompiled with CFR 0.152.
 */
package rx.util.async.operators;

import java.util.concurrent.Future;
import rx.Observable;
import rx.Scheduler;
import rx.functions.Func0;
import rx.util.async.operators.OperatorStartFuture;

public final class OperatorDeferFuture {
    private OperatorDeferFuture() {
        throw new IllegalStateException("No instances!");
    }

    public static <T> Observable<T> deferFuture(Func0<? extends Future<? extends Observable<? extends T>>> observableFactoryAsync) {
        return Observable.defer(new DeferFutureFunc0(observableFactoryAsync));
    }

    public static <T> Observable<T> deferFuture(Func0<? extends Future<? extends Observable<? extends T>>> observableFactoryAsync, Scheduler scheduler) {
        return Observable.defer(new DeferFutureFunc0Scheduled(observableFactoryAsync, scheduler));
    }

    private static final class DeferFutureFunc0Scheduled<T>
    implements Func0<Observable<T>> {
        final Func0<? extends Future<? extends Observable<? extends T>>> observableFactoryAsync;
        final Scheduler scheduler;

        public DeferFutureFunc0Scheduled(Func0<? extends Future<? extends Observable<? extends T>>> observableFactoryAsync, Scheduler scheduler) {
            this.observableFactoryAsync = observableFactoryAsync;
            this.scheduler = scheduler;
        }

        public Observable<T> call() {
            return Observable.merge(OperatorStartFuture.startFuture(this.observableFactoryAsync, this.scheduler));
        }
    }

    private static final class DeferFutureFunc0<T>
    implements Func0<Observable<T>> {
        final Func0<? extends Future<? extends Observable<? extends T>>> observableFactoryAsync;

        public DeferFutureFunc0(Func0<? extends Future<? extends Observable<? extends T>>> observableFactoryAsync) {
            this.observableFactoryAsync = observableFactoryAsync;
        }

        public Observable<T> call() {
            return Observable.merge(OperatorStartFuture.startFuture(this.observableFactoryAsync));
        }
    }
}

