/*
 * Decompiled with CFR 0.152.
 */
package rx.util.async.operators;

import java.util.concurrent.Callable;
import rx.Observable;
import rx.Subscriber;
import rx.functions.Action0;
import rx.functions.Actions;
import rx.functions.Func0;

public final class OperatorFromFunctionals {
    private OperatorFromFunctionals() {
        throw new IllegalStateException("No instances!");
    }

    public static <R> Observable.OnSubscribe<R> fromAction(Action0 action, R result) {
        return new InvokeAsync(Actions.toFunc((Action0)action, result));
    }

    public static <R> Observable.OnSubscribe<R> fromCallable(Callable<? extends R> callable) {
        return new InvokeAsync<R>(callable);
    }

    public static <R> Observable.OnSubscribe<R> fromRunnable(final Runnable run, final R result) {
        return new InvokeAsync(new Func0<R>(){

            public R call() {
                run.run();
                return result;
            }
        });
    }

    static final class InvokeAsync<R>
    implements Observable.OnSubscribe<R> {
        final Callable<? extends R> callable;

        public InvokeAsync(Callable<? extends R> callable) {
            if (callable == null) {
                throw new NullPointerException("function");
            }
            this.callable = callable;
        }

        public void call(Subscriber<? super R> t1) {
            try {
                t1.onNext(this.callable.call());
            }
            catch (Throwable t) {
                t1.onError(t);
                return;
            }
            t1.onCompleted();
        }
    }
}

