/*
 * Decompiled with CFR 0.152.
 */
package rx.plugins;

import rx.Notification;
import rx.Observable;
import rx.Observer;
import rx.observers.SafeSubscriber;
import rx.operators.DebugSubscriber;

public class DebugNotification<T> {
    private final Observable.OnSubscribe<T> source;
    private final Observable.Operator<? extends T, ?> from;
    private final Kind kind;
    private final Notification<T> notification;
    private final Observable.Operator<?, ? super T> to;
    private final long nanoTime;
    private final long threadId;
    private Observer o;

    public static <T> DebugNotification<T> createSubscribe(Observer<? super T> o, Observable.OnSubscribe<T> source) {
        Observable.Operator to = null;
        Observable.Operator from = null;
        if (o instanceof DebugSubscriber) {
            to = ((DebugSubscriber)((Object)o)).getTo();
            from = ((DebugSubscriber)((Object)o)).getFrom();
            o = ((DebugSubscriber)((Object)o)).getActual();
        }
        return new DebugNotification((Observer)o, from, Kind.Subscribe, null, to, source);
    }

    public static <T> DebugNotification<T> createOnNext(Observer<? super T> o, Observable.Operator<? extends T, ?> from, T t, Observable.Operator<?, ? super T> to) {
        return new DebugNotification<T>(o, from, Kind.OnNext, Notification.createOnNext(t), to, null);
    }

    public static <T> DebugNotification<T> createOnError(Observer<? super T> o, Observable.Operator<? extends T, ?> from, Throwable e, Observable.Operator<?, ? super T> to) {
        return new DebugNotification<T>(o, from, Kind.OnError, Notification.createOnError((Throwable)e), to, null);
    }

    public static <T> DebugNotification<T> createOnCompleted(Observer<? super T> o, Observable.Operator<? extends T, ?> from, Observable.Operator<?, ? super T> to) {
        return new DebugNotification<T>(o, from, Kind.OnCompleted, Notification.createOnCompleted(), to, null);
    }

    public static <T> DebugNotification<T> createUnsubscribe(Observer<? super T> o, Observable.Operator<? extends T, ?> from, Observable.Operator<?, ? super T> to) {
        return new DebugNotification<T>(o, from, Kind.Unsubscribe, null, to, null);
    }

    private DebugNotification(Observer o, Observable.Operator<? extends T, ?> from, Kind kind, Notification<T> notification, Observable.Operator<?, ? super T> to, Observable.OnSubscribe<T> source) {
        this.o = o instanceof SafeSubscriber ? ((SafeSubscriber)o).getActual() : o;
        this.from = from;
        this.kind = kind;
        this.notification = notification;
        this.to = to;
        this.source = source;
        this.nanoTime = System.nanoTime();
        this.threadId = Thread.currentThread().getId();
    }

    public Observable.Operator<? extends T, ?> getFrom() {
        return this.from;
    }

    public Notification<T> getNotification() {
        return this.notification;
    }

    public Observable.Operator<?, ? super T> getTo() {
        return this.to;
    }

    public long getNanoTime() {
        return this.nanoTime;
    }

    public long getThreadId() {
        return this.threadId;
    }

    public Kind getKind() {
        return this.kind;
    }

    public String toString() {
        StringBuilder s = new StringBuilder("{");
        s.append(" \"nano\": ").append(this.nanoTime);
        s.append(", \"thread\": ").append(this.threadId);
        s.append(", \"observer\": \"").append(this.o.getClass().getName()).append("@").append(Integer.toHexString(this.o.hashCode())).append("\"");
        s.append(", \"type\": \"").append((Object)this.kind).append("\"");
        if (this.notification != null) {
            if (this.notification.hasValue()) {
                s.append(", \"value\": \"").append(this.notification.getValue()).append("\"");
            }
            if (this.notification.hasThrowable()) {
                s.append(", \"exception\": \"").append(this.notification.getThrowable().getMessage().replace("\\", "\\\\").replace("\"", "\\\"")).append("\"");
            }
        }
        if (this.source != null) {
            s.append(", \"source\": \"").append(this.source.getClass().getName()).append("@").append(Integer.toHexString(this.source.hashCode())).append("\"");
        }
        if (this.from != null) {
            s.append(", \"from\": \"").append(this.from.getClass().getName()).append("@").append(Integer.toHexString(this.from.hashCode())).append("\"");
        }
        if (this.to != null) {
            s.append(", \"to\": \"").append(this.to.getClass().getName()).append("@").append(Integer.toHexString(this.to.hashCode())).append("\"");
        }
        s.append("}");
        return s.toString();
    }

    public static enum Kind {
        OnNext,
        OnError,
        OnCompleted,
        Subscribe,
        Unsubscribe;

    }
}

