/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import rx.Observable;
import rx.Observer;
import rx.Subscriber;
import rx.functions.Action1;
import rx.functions.Action2;
import rx.functions.Func1;
import rx.operators.DebugSubscription;
import rx.plugins.DebugNotification;

public final class DebugSubscriber<T, C>
extends Subscriber<T> {
    private final Func1<T, T> onNextHook;
    private final Func1<DebugNotification, C> start;
    private final Action1<C> complete;
    private final Action2<C, Throwable> error;
    private final Observer<? super T> o;
    private Observable.Operator<? extends T, ?> from = null;
    private Observable.Operator<?, ? super T> to = null;

    public DebugSubscriber(Func1<T, T> onNextHook, Func1<DebugNotification, C> start, Action1<C> complete, Action2<C, Throwable> error, Subscriber<? super T> _o, Observable.Operator<? extends T, ?> _out, Observable.Operator<?, ? super T> _in) {
        super(_o);
        this.start = start;
        this.complete = complete;
        this.error = error;
        this.o = _o;
        this.onNextHook = onNextHook;
        this.from = _out;
        this.to = _in;
        this.add(new DebugSubscription(this, start, complete, error));
    }

    public void onCompleted() {
        DebugNotification n = DebugNotification.createOnCompleted(this.o, this.from, this.to);
        Object context = this.start.call(n);
        try {
            this.o.onCompleted();
            this.complete.call(context);
        }
        catch (Throwable e) {
            this.error.call(context, (Object)e);
        }
    }

    public void onError(Throwable e) {
        DebugNotification n = DebugNotification.createOnError(this.o, this.from, e, this.to);
        Object context = this.start.call(n);
        try {
            this.o.onError(e);
            this.complete.call(context);
        }
        catch (Throwable e2) {
            this.error.call(context, (Object)e2);
        }
    }

    public void onNext(T t) {
        DebugNotification n = DebugNotification.createOnNext(this.o, this.from, t, this.to);
        Object context = this.start.call(n);
        try {
            this.o.onNext(this.onNextHook.call(t));
            this.complete.call(context);
        }
        catch (Throwable e) {
            this.error.call(context, (Object)e);
        }
    }

    public Observable.Operator<? extends T, ?> getFrom() {
        return this.from;
    }

    public void setFrom(Observable.Operator<? extends T, ?> bind) {
        this.from = bind;
    }

    public Observable.Operator<?, ? super T> getTo() {
        return this.to;
    }

    public void setTo(Observable.Operator<?, ? super T> op) {
        this.to = op;
    }

    public Observer<? super T> getActual() {
        return this.o;
    }
}

