/*
 * Decompiled with CFR 0.152.
 */
package rx.plugins;

import rx.Observable;
import rx.Subscriber;
import rx.Subscription;
import rx.functions.Action1;
import rx.functions.Action2;
import rx.functions.Actions;
import rx.functions.Func1;
import rx.functions.Functions;
import rx.operators.DebugSubscriber;
import rx.plugins.DebugNotification;
import rx.plugins.RxJavaObservableExecutionHook;

public class DebugHook<C>
extends RxJavaObservableExecutionHook {
    private final Func1 onNextHook;
    private final Func1<DebugNotification, C> start;
    private final Action1<C> complete;
    private final Action2<C, Throwable> error;

    public DebugHook(Func1 onNextDataHook, Func1<DebugNotification, C> start, Action1<C> complete, Action2<C, Throwable> error) {
        this.complete = complete;
        this.error = error;
        this.onNextHook = onNextDataHook == null ? Functions.identity() : onNextDataHook;
        this.start = start == null ? Actions.empty() : start;
    }

    public <T> Observable.OnSubscribe<T> onSubscribeStart(final Observable<? extends T> observableInstance, final Observable.OnSubscribe<T> f) {
        return new Observable.OnSubscribe<T>(){

            public void call(Subscriber<? super T> o) {
                Object context = DebugHook.this.start.call(DebugNotification.createSubscribe(o, observableInstance, f));
                try {
                    f.call((Object)DebugHook.this.wrapOutbound(null, o));
                    DebugHook.this.complete.call(context);
                }
                catch (Throwable e) {
                    DebugHook.this.error.call(context, (Object)e);
                }
            }
        };
    }

    public <T> Subscription onSubscribeReturn(Observable<? extends T> observableInstance, Subscription subscription) {
        return subscription;
    }

    public <T> Observable.OnSubscribe<T> onCreate(Observable.OnSubscribe<T> f) {
        return new OnCreateWrapper(f);
    }

    public <T, R> Observable.Operator<? extends R, ? super T> onLift(final Observable.Operator<? extends R, ? super T> bind) {
        return new Observable.Operator<R, T>(){

            public Subscriber<? super T> call(Subscriber<? super R> o) {
                return DebugHook.this.wrapInbound(bind, (Subscriber)bind.call((Object)DebugHook.this.wrapOutbound(bind, o)));
            }
        };
    }

    public <T> Subscription onAdd(Subscriber<T> subscriber, Subscription s) {
        return s;
    }

    private <R> Subscriber<? super R> wrapOutbound(Observable.Operator<? extends R, ?> bind, Subscriber<? super R> o) {
        if (o instanceof DebugSubscriber) {
            if (bind != null) {
                ((DebugSubscriber)o).setFrom(bind);
            }
            return o;
        }
        return new DebugSubscriber<R, C>(this.onNextHook, this.start, this.complete, this.error, o, bind, null);
    }

    private <T> Subscriber<? super T> wrapInbound(Observable.Operator<?, ? super T> bind, Subscriber<? super T> o) {
        if (o instanceof DebugSubscriber) {
            if (bind != null) {
                ((DebugSubscriber)o).setTo(bind);
            }
            return o;
        }
        return new DebugSubscriber<T, C>(this.onNextHook, this.start, this.complete, this.error, o, null, bind);
    }

    public final class OnCreateWrapper<T>
    implements Observable.OnSubscribe<T> {
        private final Observable.OnSubscribe<T> f;

        private OnCreateWrapper(Observable.OnSubscribe<T> f) {
            this.f = f;
        }

        public void call(Subscriber<? super T> o) {
            this.f.call((Object)DebugHook.this.wrapInbound(null, o));
        }

        public Observable.OnSubscribe<T> getActual() {
            return this.f;
        }
    }
}

