/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import rx.Observable;
import rx.Observer;
import rx.Subscriber;
import rx.operators.DebugSubscription;
import rx.plugins.DebugNotification;
import rx.plugins.DebugNotificationListener;

public final class DebugSubscriber<T, C>
extends Subscriber<T> {
    private DebugNotificationListener<C> listener;
    private final Observer<? super T> o;
    private Observable.Operator<? extends T, ?> from = null;
    private Observable.Operator<?, ? super T> to = null;

    public DebugSubscriber(DebugNotificationListener<C> listener, Subscriber<? super T> _o, Observable.Operator<? extends T, ?> _out, Observable.Operator<?, ? super T> _in) {
        super(_o);
        this.listener = listener;
        this.o = _o;
        this.from = _out;
        this.to = _in;
        this.add(new DebugSubscription(this, listener));
    }

    public void onCompleted() {
        DebugNotification<? super T> n = DebugNotification.createOnCompleted(this.o, this.from, this.to);
        C context = this.listener.start(n);
        try {
            this.o.onCompleted();
            this.listener.complete(context);
        }
        catch (Throwable e) {
            this.listener.error(context, e);
        }
    }

    public void onError(Throwable e) {
        DebugNotification<? super T> n = DebugNotification.createOnError(this.o, this.from, e, this.to);
        C context = this.listener.start(n);
        try {
            this.o.onError(e);
            this.listener.complete(context);
        }
        catch (Throwable e2) {
            this.listener.error(context, e2);
        }
    }

    public void onNext(T t) {
        DebugNotification<? super T> n = DebugNotification.createOnNext(this.o, this.from, t, this.to);
        t = this.listener.onNext(n);
        C context = this.listener.start(n);
        try {
            this.o.onNext(t);
            this.listener.complete(context);
        }
        catch (Throwable e) {
            this.listener.error(context, e);
        }
    }

    public Observable.Operator<? extends T, ?> getFrom() {
        return this.from;
    }

    public void setFrom(Observable.Operator<? extends T, ?> bind) {
        this.from = bind;
    }

    public Observable.Operator<?, ? super T> getTo() {
        return this.to;
    }

    public void setTo(Observable.Operator<?, ? super T> op) {
        this.to = op;
    }

    public Observer<? super T> getActual() {
        return this.o;
    }
}

